/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.transport.BytesTransportRequest;
import org.elasticsearch.transport.CompressibleBytesOutputStream;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.TcpHeader;
import org.elasticsearch.transport.TransportStatus;

abstract class OutboundMessage {
    private final Writeable message;
    protected final Version version;
    protected final long requestId;
    protected final byte status;

    OutboundMessage(Version version, byte status, long requestId, Writeable message) {
        this.version = version;
        this.status = status;
        this.requestId = requestId;
        this.message = message;
    }

    BytesReference serialize(BytesStreamOutput bytesStream) throws IOException {
        BytesReference reference;
        bytesStream.setVersion(this.version);
        bytesStream.skip(TcpHeader.headerSize(this.version));
        int variableHeaderLength = -1;
        long preHeaderPosition = bytesStream.position();
        if (this.version.onOrAfter(TcpHeader.VERSION_WITH_HEADER_SIZE)) {
            this.writeVariableHeader(bytesStream);
            variableHeaderLength = Math.toIntExact(bytesStream.position() - preHeaderPosition);
        }
        try (CompressibleBytesOutputStream stream = new CompressibleBytesOutputStream(bytesStream, TransportStatus.isCompress(this.status));){
            stream.setVersion(this.version);
            if (variableHeaderLength == -1) {
                this.writeVariableHeader(stream);
            }
            reference = this.writeMessage(stream);
        }
        bytesStream.seek(0L);
        int contentSize = reference.length() - TcpHeader.headerSize(this.version);
        TcpHeader.writeHeader(bytesStream, this.requestId, this.status, this.version, contentSize, variableHeaderLength);
        return reference;
    }

    protected void writeVariableHeader(StreamOutput stream) throws IOException {
        ThreadContext.bwcWriteHeaders(stream);
    }

    protected BytesReference writeMessage(CompressibleBytesOutputStream stream) throws IOException {
        BytesReference zeroCopyBuffer;
        if (this.message instanceof BytesTransportRequest) {
            BytesTransportRequest bRequest = (BytesTransportRequest)this.message;
            bRequest.writeThin(stream);
            zeroCopyBuffer = bRequest.bytes;
        } else if (this.message instanceof RemoteTransportException) {
            stream.writeException((RemoteTransportException)this.message);
            zeroCopyBuffer = BytesArray.EMPTY;
        } else {
            this.message.writeTo(stream);
            zeroCopyBuffer = BytesArray.EMPTY;
        }
        BytesReference message = stream.materializeBytes();
        if (zeroCopyBuffer.length() == 0) {
            return message;
        }
        return CompositeBytesReference.of(message, zeroCopyBuffer);
    }

    private static boolean canCompress(Writeable message) {
        return !(message instanceof BytesTransportRequest);
    }

    static class Response
    extends OutboundMessage {
        Response(Writeable message, Version version, long requestId, boolean isHandshake, boolean compress) {
            super(version, Response.setStatus(compress, isHandshake, message), requestId, message);
        }

        private static byte setStatus(boolean compress, boolean isHandshake, Writeable message) {
            byte status = 0;
            status = TransportStatus.setResponse(status);
            if (message instanceof RemoteTransportException) {
                status = TransportStatus.setError(status);
            }
            if (compress) {
                status = TransportStatus.setCompress(status);
            }
            if (isHandshake) {
                status = TransportStatus.setHandshake(status);
            }
            return status;
        }
    }

    static class Request
    extends OutboundMessage {
        private final String action;

        Request(Writeable message, Version version, String action, long requestId, boolean isHandshake, boolean compress) {
            super(version, Request.setStatus(compress, isHandshake, message), requestId, message);
            this.action = action;
        }

        @Override
        protected void writeVariableHeader(StreamOutput stream) throws IOException {
            super.writeVariableHeader(stream);
            if (this.version.before(Version.V_4_3_0)) {
                stream.writeStringArray(Strings.EMPTY_ARRAY);
            }
            stream.writeString(this.action);
        }

        private static byte setStatus(boolean compress, boolean isHandshake, Writeable message) {
            byte status = 0;
            status = TransportStatus.setRequest(status);
            if (compress && OutboundMessage.canCompress(message)) {
                status = TransportStatus.setCompress(status);
            }
            if (isHandshake) {
                status = TransportStatus.setHandshake(status);
            }
            return status;
        }
    }
}

