/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;

public class RequestHandlerRegistry<Request extends TransportRequest> {
    private final String action;
    private final TransportRequestHandler<Request> handler;
    private final boolean forceExecution;
    private final boolean canTripCircuitBreaker;
    private final String executor;
    private final Writeable.Reader<Request> requestReader;

    public RequestHandlerRegistry(String action, Writeable.Reader<Request> requestReader, TransportRequestHandler<Request> handler, String executor, boolean forceExecution, boolean canTripCircuitBreaker) {
        this.action = action;
        this.requestReader = requestReader;
        this.handler = handler;
        this.forceExecution = forceExecution;
        this.canTripCircuitBreaker = canTripCircuitBreaker;
        this.executor = executor;
    }

    public String getAction() {
        return this.action;
    }

    public Request newRequest(StreamInput in) throws IOException {
        return (Request)((TransportRequest)this.requestReader.read(in));
    }

    public void processMessageReceived(Request request, TransportChannel channel) throws Exception {
        this.handler.messageReceived(request, channel);
    }

    public boolean isForceExecution() {
        return this.forceExecution;
    }

    public boolean canTripCircuitBreaker() {
        return this.canTripCircuitBreaker;
    }

    public String getExecutor() {
        return this.executor;
    }

    public TransportRequestHandler<Request> getHandler() {
        return this.handler;
    }

    public String toString() {
        return this.handler.toString();
    }

    public static <R extends TransportRequest> RequestHandlerRegistry<R> replaceHandler(RequestHandlerRegistry<R> registry, TransportRequestHandler<R> handler) {
        return new RequestHandlerRegistry(registry.action, registry.requestReader, handler, registry.executor, registry.forceExecution, registry.canTripCircuitBreaker);
    }
}

