/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.transport.StatsTracker;
import org.elasticsearch.transport.netty4.Netty4Utils;

@ChannelHandler.Sharable
public class Netty4InboundStatsHandler
extends ChannelInboundHandlerAdapter
implements Releasable {
    final Set<Channel> openChannels = Collections.newSetFromMap(new ConcurrentHashMap());
    final StatsTracker statsTracker;
    final Logger logger;
    final ChannelFutureListener remover = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) throws Exception {
            boolean removed = Netty4InboundStatsHandler.this.openChannels.remove(future.channel());
            if (removed) {
                Netty4InboundStatsHandler.this.statsTracker.decrementOpenChannels();
            }
            if (Netty4InboundStatsHandler.this.logger.isTraceEnabled()) {
                Netty4InboundStatsHandler.this.logger.trace("channel closed: {}", (Object)future.channel());
            }
        }
    };

    public Netty4InboundStatsHandler(StatsTracker statsTracker, Logger logger) {
        this.statsTracker = statsTracker;
        this.logger = logger;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        boolean added;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("channel opened: {}", (Object)ctx.channel());
        }
        if (added = this.openChannels.add(ctx.channel())) {
            this.statsTracker.incrementOpenChannels();
            ctx.channel().closeFuture().addListener((GenericFutureListener)this.remover);
        }
        super.channelActive(ctx);
    }

    @Override
    public void close() {
        try {
            Netty4Utils.closeChannels(this.openChannels);
        }
        catch (IOException e) {
            this.logger.trace("exception while closing channels", (Throwable)e);
        }
        this.openChannels.clear();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf bb = (ByteBuf)msg;
            this.statsTracker.incrementBytesReceived(bb.readableBytes());
            this.statsTracker.incrementMessagesReceived();
        } else {
            this.logger.warn("Message sent is: {} and not a ByteBuf, cannot track received bytes or message count", (Object)msg.getClass().getCanonicalName());
        }
        super.channelRead(ctx, msg);
    }
}

