/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.crate.auth.AuthSettings;
import io.crate.auth.Authentication;
import io.crate.auth.Protocol;
import io.crate.common.SuppressForbidden;
import io.crate.common.exceptions.Exceptions;
import io.crate.netty.NettyBootstrap;
import io.crate.protocols.ssl.SslContextProvider;
import io.crate.protocols.ssl.SslSettings;
import io.crate.types.DataTypes;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.TransportSettings;
import org.elasticsearch.transport.netty4.HostBasedAuthHandler;
import org.elasticsearch.transport.netty4.Netty4MessageChannelHandler;

public class Netty4Transport
extends TcpTransport {
    public static final Setting<Integer> WORKER_COUNT = new Setting<Integer>("transport.netty.worker_count", s -> Integer.toString(EsExecutors.numberOfProcessors(s)), s -> Setting.parseInt(s, 1, "transport.netty.worker_count"), DataTypes.INTEGER, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_SIZE = Setting.byteSizeSetting("transport.netty.receive_predictor_size", new ByteSizeValue(64L, ByteSizeUnit.KB), Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_MIN = Setting.byteSizeSetting("transport.netty.receive_predictor_min", NETTY_RECEIVE_PREDICTOR_SIZE, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_MAX = Setting.byteSizeSetting("transport.netty.receive_predictor_max", NETTY_RECEIVE_PREDICTOR_SIZE, Setting.Property.NodeScope);
    public static final Setting<Integer> NETTY_BOSS_COUNT = Setting.intSetting("transport.netty.boss_count", 1, 1, Setting.Property.NodeScope);
    private final RecvByteBufAllocator recvByteBufAllocator;
    private final ByteSizeValue receivePredictorMin;
    private final ByteSizeValue receivePredictorMax;
    private volatile Bootstrap clientBootstrap;
    private volatile ServerBootstrap serverBootstrap;
    private final NettyBootstrap nettyBootstrap;
    private final SslContextProvider sslContextProvider;
    private final Authentication authentication;
    private final LoggingHandler loggingHandler = new LoggingHandler(LogLevel.TRACE);
    public static final AttributeKey<CloseableChannel> CHANNEL_KEY = AttributeKey.newInstance((String)"es-channel");
    static final AttributeKey<CloseableChannel> SERVER_CHANNEL_KEY = AttributeKey.newInstance((String)"es-server-channel");

    public Netty4Transport(Settings settings, Version version, ThreadPool threadPool, NetworkService networkService, PageCacheRecycler pageCacheRecycler, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService, NettyBootstrap nettyBootstrap, Authentication authentication, SslContextProvider sslContextProvider) {
        super(settings, version, threadPool, pageCacheRecycler, circuitBreakerService, namedWriteableRegistry, networkService);
        this.authentication = authentication;
        this.nettyBootstrap = nettyBootstrap;
        this.sslContextProvider = sslContextProvider;
        this.receivePredictorMin = NETTY_RECEIVE_PREDICTOR_MIN.get(settings);
        this.receivePredictorMax = NETTY_RECEIVE_PREDICTOR_MAX.get(settings);
        this.recvByteBufAllocator = this.receivePredictorMax.getBytes() == this.receivePredictorMin.getBytes() ? new FixedRecvByteBufAllocator((int)this.receivePredictorMax.getBytes()) : new AdaptiveRecvByteBufAllocator((int)this.receivePredictorMin.getBytes(), (int)this.receivePredictorMin.getBytes(), (int)this.receivePredictorMax.getBytes());
    }

    @Override
    protected void doStart() {
        boolean success = false;
        try {
            EventLoopGroup eventLoopGroup = this.nettyBootstrap.getSharedEventLoopGroup();
            this.clientBootstrap = this.createClientBootstrap(eventLoopGroup);
            if (NetworkService.NETWORK_SERVER.get(this.settings).booleanValue()) {
                this.createServerBootstrap(this.settings, eventLoopGroup);
                this.bindServer(this.settings);
            }
            super.doStart();
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    private Bootstrap createClientBootstrap(EventLoopGroup eventLoopGroup) {
        ByteSizeValue tcpReceiveBufferSize;
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(eventLoopGroup);
        bootstrap.channel(NettyBootstrap.clientChannel());
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)TransportSettings.TCP_NO_DELAY.get(this.settings));
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)TransportSettings.TCP_KEEP_ALIVE.get(this.settings));
        ByteSizeValue tcpSendBufferSize = TransportSettings.TCP_SEND_BUFFER_SIZE.get(this.settings);
        if (tcpSendBufferSize.getBytes() > 0L) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)Math.toIntExact(tcpSendBufferSize.getBytes()));
        }
        if ((tcpReceiveBufferSize = TransportSettings.TCP_RECEIVE_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)Math.toIntExact(tcpReceiveBufferSize.getBytes()));
        }
        bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
        boolean reuseAddress = TransportSettings.TCP_REUSE_ADDRESS.get(this.settings);
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
        return bootstrap;
    }

    private void createServerBootstrap(Settings settings, EventLoopGroup eventLoopGroup) {
        long receiveBufferBytes;
        List<String> transportBindHosts = TransportSettings.BIND_HOST.get(settings);
        List<String> bindHosts = transportBindHosts.isEmpty() ? NetworkService.GLOBAL_NETWORK_BIND_HOST_SETTING.get(settings) : transportBindHosts;
        List<String> publishHosts = TransportSettings.PUBLISH_HOST.get(settings);
        String portOrRange = TransportSettings.PORT.get(settings);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("port[{}], bind_host[{}], publish_host[{}], receive_predictor[{}->{}]", (Object)portOrRange, bindHosts, publishHosts, (Object)this.receivePredictorMin, (Object)this.receivePredictorMax);
        }
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        serverBootstrap.group(eventLoopGroup);
        serverBootstrap.channel(NettyBootstrap.serverChannel());
        serverBootstrap.childHandler((ChannelHandler)new ServerChannelInitializer());
        serverBootstrap.handler((ChannelHandler)new ServerChannelExceptionHandler());
        serverBootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)TransportSettings.TCP_NO_DELAY.get(settings));
        serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)TransportSettings.TCP_KEEP_ALIVE.get(settings));
        long sendBufferBytes = TransportSettings.TCP_SEND_BUFFER_SIZE.get(settings).getBytes();
        if (sendBufferBytes != -1L) {
            serverBootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)Math.toIntExact(sendBufferBytes));
        }
        if ((receiveBufferBytes = TransportSettings.TCP_RECEIVE_BUFFER_SIZE.get(settings).getBytes()) != -1L) {
            serverBootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)Math.toIntExact(receiveBufferBytes));
        }
        serverBootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
        serverBootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
        Boolean reuseAddress = TransportSettings.TCP_REUSE_ADDRESS.get(settings);
        serverBootstrap.option(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
        serverBootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
        serverBootstrap.validate();
        this.serverBootstrap = serverBootstrap;
    }

    @Override
    protected TcpTransport.ConnectResult initiateChannel(DiscoveryNode node) throws IOException {
        InetSocketAddress address = node.getAddress().address();
        Bootstrap bootstrapWithHandler = this.clientBootstrap.clone();
        bootstrapWithHandler.handler((ChannelHandler)new ClientChannelInitializer());
        bootstrapWithHandler.remoteAddress((SocketAddress)address);
        ChannelFuture connectFuture = bootstrapWithHandler.connect();
        Channel channel = connectFuture.channel();
        if (channel == null) {
            Exceptions.maybeDieOnAnotherThread((Throwable)connectFuture.cause());
            throw new IOException(connectFuture.cause());
        }
        this.addClosedExceptionLogger(channel);
        CloseableChannel nettyChannel = new CloseableChannel(channel, false);
        channel.attr(CHANNEL_KEY).set((Object)nettyChannel);
        return new TcpTransport.ConnectResult(nettyChannel, connectFuture);
    }

    @Override
    protected CloseableChannel bind(InetSocketAddress address) {
        Channel channel = this.serverBootstrap.bind((SocketAddress)address).syncUninterruptibly().channel();
        CloseableChannel esChannel = new CloseableChannel(channel, true);
        channel.attr(SERVER_CHANNEL_KEY).set((Object)esChannel);
        return esChannel;
    }

    @Override
    @SuppressForbidden(reason="debug")
    protected void stopInternal() {
        Releasables.close(() -> {
            this.serverBootstrap = null;
            this.clientBootstrap = null;
        });
    }

    private void addClosedExceptionLogger(Channel channel) {
        channel.closeFuture().addListener(f -> {
            if (!f.isSuccess()) {
                this.logger.debug(() -> new ParameterizedMessage("exception while closing channel: {}", (Object)channel), f.cause());
            }
        });
    }

    protected class ServerChannelInitializer
    extends ChannelInitializer<Channel> {
        protected ServerChannelInitializer() {
        }

        protected void initChannel(Channel ch) throws Exception {
            SslSettings.SSLMode sslMode = SslSettings.SSL_TRANSPORT_MODE.get(Netty4Transport.this.settings);
            if (sslMode == SslSettings.SSLMode.ON) {
                SslContext sslContext = Netty4Transport.this.sslContextProvider.getServerContext(Protocol.TRANSPORT);
                SslHandler sslHandler = sslContext.newHandler(ch.alloc());
                ch.pipeline().addLast(new ChannelHandler[]{sslHandler});
            }
            if (AuthSettings.AUTH_HOST_BASED_ENABLED_SETTING.get(Netty4Transport.this.settings).booleanValue() && sslMode != SslSettings.SSLMode.LEGACY) {
                ch.pipeline().addLast("hba", (ChannelHandler)new HostBasedAuthHandler(Netty4Transport.this.authentication));
            }
            Netty4Transport.this.addClosedExceptionLogger(ch);
            CloseableChannel nettyTcpChannel = new CloseableChannel(ch, true);
            ch.attr(CHANNEL_KEY).set((Object)nettyTcpChannel);
            Netty4Transport.this.serverAcceptedChannel(nettyTcpChannel);
            ch.pipeline().addLast("logging", (ChannelHandler)Netty4Transport.this.loggingHandler);
            ch.pipeline().addLast("dispatcher", (ChannelHandler)new Netty4MessageChannelHandler(Netty4Transport.this.pageCacheRecycler, Netty4Transport.this));
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            Exceptions.maybeDieOnAnotherThread((Throwable)cause);
            super.exceptionCaught(ctx, cause);
        }
    }

    @ChannelHandler.Sharable
    private class ServerChannelExceptionHandler
    extends ChannelHandlerAdapter {
        private ServerChannelExceptionHandler() {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            Exceptions.maybeDieOnAnotherThread((Throwable)cause);
            CloseableChannel serverChannel = (CloseableChannel)ctx.channel().attr(SERVER_CHANNEL_KEY).get();
            if (cause instanceof Error) {
                Netty4Transport.this.onServerException(serverChannel, new Exception(cause));
            } else {
                Netty4Transport.this.onServerException(serverChannel, (Exception)cause);
            }
        }
    }

    protected class ClientChannelInitializer
    extends ChannelInitializer<Channel> {
        protected ClientChannelInitializer() {
        }

        protected void initChannel(Channel ch) throws Exception {
            this.maybeInjectSSL(ch);
            ch.pipeline().addLast("logging", (ChannelHandler)Netty4Transport.this.loggingHandler);
            ch.pipeline().addLast("dispatcher", (ChannelHandler)new Netty4MessageChannelHandler(Netty4Transport.this.pageCacheRecycler, Netty4Transport.this));
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            Exceptions.maybeDieOnAnotherThread((Throwable)cause);
            super.exceptionCaught(ctx, cause);
        }

        private void maybeInjectSSL(Channel ch) throws Exception, AssertionError {
            SslSettings.SSLMode sslMode = SslSettings.SSL_TRANSPORT_MODE.get(Netty4Transport.this.settings);
            if (sslMode == SslSettings.SSLMode.ON) {
                SslContext sslContext = Netty4Transport.this.sslContextProvider.clientContext();
                SslHandler sslHandler = sslContext.newHandler(ch.alloc());
                sslHandler.engine().setUseClientMode(true);
                ch.pipeline().addLast(new ChannelHandler[]{sslHandler});
            }
        }
    }
}

