/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import java.util.HashSet;
import java.util.Set;

public interface CharMatcher {
    public boolean isTokenChar(int var1);

    public static final class Builder {
        private final Set<CharMatcher> matchers = new HashSet<CharMatcher>();

        Builder() {
        }

        public Builder or(CharMatcher matcher) {
            this.matchers.add(matcher);
            return this;
        }

        public CharMatcher build() {
            switch (this.matchers.size()) {
                case 0: {
                    return new CharMatcher(this){

                        @Override
                        public boolean isTokenChar(int c) {
                            return false;
                        }
                    };
                }
                case 1: {
                    return this.matchers.iterator().next();
                }
            }
            return new CharMatcher(){

                @Override
                public boolean isTokenChar(int c) {
                    for (CharMatcher matcher : matchers) {
                        if (!matcher.isTokenChar(c)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
    }

    public static enum Basic implements CharMatcher
    {
        LETTER{

            @Override
            public boolean isTokenChar(int c) {
                return Character.isLetter(c);
            }
        }
        ,
        DIGIT{

            @Override
            public boolean isTokenChar(int c) {
                return Character.isDigit(c);
            }
        }
        ,
        WHITESPACE{

            @Override
            public boolean isTokenChar(int c) {
                return Character.isWhitespace(c);
            }
        }
        ,
        PUNCTUATION{

            @Override
            public boolean isTokenChar(int c) {
                switch (Character.getType(c)) {
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 29: 
                    case 30: {
                        return true;
                    }
                }
                return false;
            }
        }
        ,
        SYMBOL{

            @Override
            public boolean isTokenChar(int c) {
                switch (Character.getType(c)) {
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: {
                        return true;
                    }
                }
                return false;
            }
        };

    }

    public static class ByUnicodeCategory
    implements CharMatcher {
        private final byte unicodeType;

        public static CharMatcher of(byte unicodeCategory) {
            return new ByUnicodeCategory(unicodeCategory);
        }

        ByUnicodeCategory(byte unicodeType) {
            this.unicodeType = unicodeType;
        }

        @Override
        public boolean isTokenChar(int c) {
            return Character.getType(c) == this.unicodeType;
        }
    }
}

