/*
 * Decompiled with CFR 0.152.
 */
package io.crate.gcs;

import io.crate.gcs.GCSBlobStore;
import io.crate.gcs.GCSService;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;

public class GCSRepository
extends BlobStoreRepository {
    static final ByteSizeValue MIN_CHUNK_SIZE = new ByteSizeValue(1L, ByteSizeUnit.BYTES);
    static final ByteSizeValue MAX_CHUNK_SIZE = new ByteSizeValue(5L, ByteSizeUnit.TB);
    static final Setting<String> BUCKET_SETTING = Setting.simpleString((String)"bucket", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<String> BASE_PATH_SETTING = Setting.simpleString((String)"base_path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting((String)"chunk_size", (ByteSizeValue)MAX_CHUNK_SIZE, (ByteSizeValue)MIN_CHUNK_SIZE, (ByteSizeValue)MAX_CHUNK_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private final GCSService service;
    private final ByteSizeValue chunkSize;
    private final String bucket;

    public GCSRepository(RepositoryMetadata metadata, NamedWriteableRegistry namedWriteableRegistry, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, GCSService service, RecoverySettings recoverySettings) {
        super(metadata, namedWriteableRegistry, namedXContentRegistry, clusterService, recoverySettings, GCSRepository.buildBasePath(metadata));
        this.service = service;
        this.chunkSize = (ByteSizeValue)CHUNK_SIZE_SETTING.get(metadata.settings());
        this.bucket = (String)BUCKET_SETTING.get(metadata.settings());
    }

    protected GCSBlobStore createBlobStore() {
        return new GCSBlobStore(this.bucket, this.service, this.metadata, this.bufferSize);
    }

    private static BlobPath buildBasePath(RepositoryMetadata metadata) {
        String basePath = (String)BASE_PATH_SETTING.get(metadata.settings());
        if (Strings.hasLength((CharSequence)basePath)) {
            BlobPath path = new BlobPath();
            for (String elem : basePath.split("/")) {
                path = path.add(elem);
            }
            return path;
        }
        return BlobPath.cleanPath();
    }

    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }
}

