/*
 * Decompiled with CFR 0.152.
 */
package io.crate.gcs;

import com.google.api.client.http.HttpResponse;
import com.google.api.core.ApiClock;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.services.storage.Storage;
import com.google.cloud.BaseService;
import com.google.cloud.RetryHelper;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.spi.v1.HttpStorageRpc;
import io.crate.common.SuppressForbidden;
import io.crate.common.io.IOUtils;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;

class GCSRetryingInputStream
extends InputStream {
    private static final Logger LOGGER = LogManager.getLogger(GCSRetryingInputStream.class);
    static final int MAX_SUPPRESSED_EXCEPTIONS = 10;
    private final Storage client;
    private final com.google.api.services.storage.Storage storage;
    private final BlobId blobId;
    private final long start;
    private final long end;
    private final int maxAttempts;
    private InputStream currentStream;
    private int attempt = 1;
    private List<StorageException> failures = new ArrayList<StorageException>(10);
    private long currentOffset;
    private boolean closed;

    GCSRetryingInputStream(Storage client, BlobId blobId) throws IOException {
        this(client, blobId, 0L, 0x7FFFFFFFFFFFFFFEL);
    }

    GCSRetryingInputStream(Storage client, BlobId blobId, long start, long end) throws IOException {
        if (start < 0L) {
            throw new IllegalArgumentException("start must be non-negative");
        }
        if (end < start || end == Long.MAX_VALUE) {
            throw new IllegalArgumentException("end must be >= start and not Long.MAX_VALUE");
        }
        this.client = client;
        this.blobId = blobId;
        this.start = start;
        this.end = end;
        this.maxAttempts = ((StorageOptions)client.getOptions()).getRetrySettings().getMaxAttempts();
        this.storage = GCSRetryingInputStream.getStorage(client);
        this.currentStream = this.openStream();
    }

    @SuppressForbidden(reason="Reflection usage")
    private static com.google.api.services.storage.Storage getStorage(Storage client) {
        assert (((StorageOptions)client.getOptions()).getRpc() instanceof HttpStorageRpc);
        assert (Stream.of(((StorageOptions)client.getOptions()).getRpc().getClass().getDeclaredFields()).anyMatch(f -> f.getName().equals("storage")));
        try {
            Field storageField = ((StorageOptions)client.getOptions()).getRpc().getClass().getDeclaredField("storage");
            storageField.setAccessible(true);
            return (com.google.api.services.storage.Storage)storageField.get(((StorageOptions)client.getOptions()).getRpc());
        }
        catch (Exception e) {
            throw new IllegalStateException("storage could not be set up", e);
        }
    }

    private InputStream openStream() throws IOException {
        try {
            try {
                return (InputStream)RetryHelper.runWithRetries(() -> {
                    try {
                        Storage.Objects.Get get = this.storage.objects().get(this.blobId.getBucket(), this.blobId.getName());
                        get.setReturnRawInputStream(true);
                        if (this.currentOffset > 0L || this.start > 0L || this.end < 0x7FFFFFFFFFFFFFFEL) {
                            get.getRequestHeaders().setRange("bytes=" + Math.addExact(this.start, this.currentOffset) + "-" + this.end);
                        }
                        HttpResponse resp = get.executeMedia();
                        Long contentLength = resp.getHeaders().getContentLength();
                        InputStream content = resp.getContent();
                        if (contentLength != null) {
                            content = new ContentLengthValidatingInputStream(content, contentLength);
                        }
                        return content;
                    }
                    catch (IOException e) {
                        throw StorageException.translate((IOException)e);
                    }
                }, (RetrySettings)((StorageOptions)this.client.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BaseService.EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.client.getOptions()).getClock());
            }
            catch (RetryHelper.RetryHelperException e) {
                throw StorageException.translateAndThrow((RetryHelper.RetryHelperException)e);
            }
        }
        catch (StorageException e) {
            if (e.getCode() == 404) {
                throw this.addSuppressedExceptions(new NoSuchFileException("Blob object [" + this.blobId.getName() + "] not found: " + e.getMessage()));
            }
            throw this.addSuppressedExceptions(e);
        }
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        while (true) {
            try {
                int result = this.currentStream.read();
                ++this.currentOffset;
                return result;
            }
            catch (IOException e) {
                this.reopenStreamOrFail(StorageException.translate((IOException)e));
                continue;
            }
            break;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        while (true) {
            try {
                int bytesRead = this.currentStream.read(b, off, len);
                if (bytesRead == -1) {
                    return -1;
                }
                this.currentOffset += (long)bytesRead;
                return bytesRead;
            }
            catch (IOException e) {
                this.reopenStreamOrFail(StorageException.translate((IOException)e));
                continue;
            }
            break;
        }
    }

    private void ensureOpen() {
        if (this.closed) {
            assert (false) : "using GoogleCloudStorageRetryingInputStream after close";
            throw new IllegalStateException("using GoogleCloudStorageRetryingInputStream after close");
        }
    }

    private void reopenStreamOrFail(StorageException e) throws IOException {
        if (this.attempt >= this.maxAttempts) {
            throw this.addSuppressedExceptions(e);
        }
        LOGGER.debug((Message)new ParameterizedMessage("failed reading [{}] at offset [{}], attempt [{}] of [{}], retrying", new Object[]{this.blobId, this.currentOffset, this.attempt, this.maxAttempts}), (Throwable)e);
        ++this.attempt;
        if (this.failures.size() < 10) {
            this.failures.add(e);
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.currentStream});
        this.currentStream = this.openStream();
    }

    @Override
    public void close() throws IOException {
        this.currentStream.close();
        this.closed = true;
    }

    @Override
    public long skip(long n) {
        throw new UnsupportedOperationException("GoogleCloudStorageRetryingInputStream does not support seeking");
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("GoogleCloudStorageRetryingInputStream does not support seeking");
    }

    private <T extends Exception> T addSuppressedExceptions(T e) {
        for (StorageException failure : this.failures) {
            e.addSuppressed(failure);
        }
        return e;
    }

    static final class ContentLengthValidatingInputStream
    extends FilterInputStream {
        private final long contentLength;
        private long read = 0L;

        ContentLengthValidatingInputStream(InputStream in, long contentLength) {
            super(in);
            this.contentLength = contentLength;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n = this.in.read(b, off, len);
            if (n == -1) {
                this.checkContentLengthOnEOF();
            } else {
                this.read += (long)n;
            }
            return n;
        }

        @Override
        public int read() throws IOException {
            int n = this.in.read();
            if (n == -1) {
                this.checkContentLengthOnEOF();
            } else {
                ++this.read;
            }
            return n;
        }

        @Override
        public long skip(long len) throws IOException {
            long n = this.in.skip(len);
            this.read += n;
            return n;
        }

        private void checkContentLengthOnEOF() throws IOException {
            if (this.read < this.contentLength) {
                throw new IOException("Connection closed prematurely: read = " + this.read + ", Content-Length = " + this.contentLength);
            }
        }
    }
}

