/*
 * Decompiled with CFR 0.152.
 */
package io.crate.operation.language;

import io.crate.data.Input;
import io.crate.types.ArrayType;
import io.crate.types.BitStringType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.FloatVectorType;
import io.crate.types.GeoPointType;
import io.crate.types.GeoShapeType;
import io.crate.types.ObjectType;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import org.graalvm.polyglot.TypeLiteral;
import org.graalvm.polyglot.Value;

class PolyglotValues {
    private static final TypeLiteral<Number> NUMBER_TYPE_LITERAL = new TypeLiteral<Number>(){};
    private static final TypeLiteral<Object> OBJECT_LITERAL = new TypeLiteral<Object>(){};

    private PolyglotValues() {
    }

    private static Object toCrateObject(Value value) {
        if (value.isNull()) {
            return null;
        }
        if (value.isHostObject()) {
            return value.asHostObject();
        }
        if (value.hasIterator()) {
            ArrayList<Object> items = new ArrayList<Object>();
            Value iterator = value.getIterator();
            while (iterator.hasIteratorNextElement()) {
                items.add(PolyglotValues.toCrateObject(iterator.getIteratorNextElement()));
            }
            return items;
        }
        if (value.hasMembers()) {
            Set memberKeys = value.getMemberKeys();
            HashMap<String, Object> result = HashMap.newHashMap(memberKeys.size());
            for (String key : memberKeys) {
                result.put(key, PolyglotValues.toCrateObject(value.getMember(key)));
            }
            return result;
        }
        return value.as(OBJECT_LITERAL);
    }

    static Object toCrateObject(Value value, DataType<?> type) {
        if (value == null) {
            return null;
        }
        if (value.isHostObject()) {
            return type.implicitCast(value.asHostObject());
        }
        DataType<?> dataType = type;
        Objects.requireNonNull(dataType);
        DataType<?> dataType2 = dataType;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArrayType.class, ObjectType.class, GeoPointType.class, GeoShapeType.class, FloatVectorType.class, BitStringType.class}, dataType2, n)) {
            case 0 -> {
                ArrayType arrayType = (ArrayType)dataType2;
                DataType innerType = arrayType.innerType();
                int size = (int)value.getArraySize();
                ArrayList<Object> items = new ArrayList<Object>(size);
                for (int idx = 0; idx < size; ++idx) {
                    Object item = PolyglotValues.toCrateObject(value.getArrayElement((long)idx), innerType);
                    items.add(idx, item);
                }
                yield type.implicitCast(items);
            }
            case 1 -> {
                ObjectType objectType = (ObjectType)dataType2;
                Set memberKeys = value.getMemberKeys();
                HashMap<String, Object> shape = HashMap.newHashMap(memberKeys.size());
                for (String key : memberKeys) {
                    shape.put(key, PolyglotValues.toCrateObject(value.getMember(key)));
                }
                yield type.implicitCast(shape);
            }
            case 2 -> {
                GeoPointType geoPointType = (GeoPointType)dataType2;
                if (value.hasArrayElements()) {
                    yield type.implicitCast(PolyglotValues.toCrateObject(value, DataTypes.DOUBLE_ARRAY));
                }
                yield type.implicitCast((Object)value.asString());
            }
            case 3 -> {
                GeoShapeType geoShapeType = (GeoShapeType)dataType2;
                if (value.isString()) {
                    yield type.implicitCast((Object)value.asString());
                }
                Set memberKeys = value.getMemberKeys();
                HashMap<String, Object> shape = HashMap.newHashMap(memberKeys.size());
                for (String key : memberKeys) {
                    shape.put(key, PolyglotValues.toCrateObject(value.getMember(key)));
                }
                yield type.implicitCast(shape);
            }
            case 4 -> {
                FloatVectorType floatVectorType = (FloatVectorType)dataType2;
                long size = value.getArraySize();
                if (!$assertionsDisabled && size != (long)floatVectorType.characterMaximumLength().intValue()) {
                    throw new AssertionError((Object)"Length of array returned from UDF must match float vector type dimensions");
                }
                float[] result = new float[floatVectorType.characterMaximumLength().intValue()];
                int i = 0;
                while ((long)i < size) {
                    result[i] = ((Number)value.getArrayElement((long)i).as(NUMBER_TYPE_LITERAL)).floatValue();
                    ++i;
                }
                yield (Object)result;
            }
            case 5 -> {
                BitStringType bitStringType = (BitStringType)dataType2;
                yield bitStringType.implicitCast((Object)value.asString());
            }
            default -> {
                Object polyglotValue = value.isNumber() ? value.as(NUMBER_TYPE_LITERAL) : (value.isString() ? value.asString() : (value.isBoolean() ? Boolean.valueOf(value.asBoolean()) : value.asString()));
                yield type.implicitCast(polyglotValue);
            }
        };
    }

    static Value[] toPolyglotValues(Input<Object>[] inputs) {
        Value[] result = new Value[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            result[i] = Value.asValue((Object)inputs[i].value());
        }
        return result;
    }
}

