/*
 * Decompiled with CFR 0.152.
 */
package io.crate.window;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.window.WindowFrameState;
import io.crate.execution.engine.window.WindowFunction;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.List;
import java.util.function.IntBinaryOperator;
import java.util.function.LongConsumer;
import org.jetbrains.annotations.Nullable;

public class RankFunctions
implements WindowFunction {
    private static final String RANK_NAME = "rank";
    private static final String DENSE_RANK_NAME = "dense_rank";
    private final Signature signature;
    private final BoundSignature boundSignature;
    private int seenLastUpperBound = -1;
    private int rank;
    private final IntBinaryOperator rankIncrementor;

    private RankFunctions(Signature signature, BoundSignature boundSignature, IntBinaryOperator rankIncrementor) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.rankIncrementor = rankIncrementor;
    }

    public Signature signature() {
        return this.signature;
    }

    public BoundSignature boundSignature() {
        return this.boundSignature;
    }

    public Object execute(LongConsumer allocateBytes, int idxInPartition, WindowFrameState currentFrame, List<? extends CollectExpression<Row, ?>> expressions, @Nullable Boolean ignoreNulls, Input<?> ... args) {
        if (ignoreNulls != null) {
            throw new IllegalArgumentException("rank cannot accept RESPECT or IGNORE NULLS flag.");
        }
        if (idxInPartition == 0) {
            this.rank = 1;
            this.seenLastUpperBound = currentFrame.upperBoundExclusive();
        }
        if (currentFrame.upperBoundExclusive() != this.seenLastUpperBound) {
            this.rank = this.rankIncrementor.applyAsInt(this.rank, this.seenLastUpperBound);
            this.seenLastUpperBound = currentFrame.upperBoundExclusive();
        }
        return this.rank;
    }

    public static void register(Functions.Builder builder) {
        builder.add(Signature.builder((String)RANK_NAME, (FunctionType)FunctionType.WINDOW).argumentTypes(new TypeSignature[0]).returnType(DataTypes.INTEGER.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), (signature, boundSignature) -> new RankFunctions((Signature)signature, (BoundSignature)boundSignature, (rank, upperBound) -> upperBound + 1));
        builder.add(Signature.builder((String)DENSE_RANK_NAME, (FunctionType)FunctionType.WINDOW).argumentTypes(new TypeSignature[0]).returnType(DataTypes.INTEGER.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), (signature, boundSignature) -> new RankFunctions((Signature)signature, (BoundSignature)boundSignature, (rank, upperBound) -> rank + 1));
    }
}

