/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common.collections;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.SequencedSet;
import java.util.StringJoiner;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public final class Lists {
    private Lists() {
    }

    public static <T> List<T> of(Iterable<? extends T> items) {
        if (items instanceof Collection) {
            Collection collection = (Collection)items;
            return new ArrayList(collection);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T item : items) {
            result.add(item);
        }
        return result;
    }

    public static <T> List<T> concat(Collection<? extends T> list1, Collection<? extends T> list2) {
        ArrayList<T> list = new ArrayList<T>(list1.size() + list2.size());
        list.addAll(list1);
        list.addAll(list2);
        return list;
    }

    public static <T> List<T> concat(Collection<? extends T> list1, T item) {
        ArrayList<T> xs = new ArrayList<T>(list1.size() + 1);
        xs.addAll(list1);
        xs.add(item);
        return xs;
    }

    public static <T> List<T> concat(T item, Collection<? extends T> list1) {
        ArrayList<T> xs = new ArrayList<T>(list1.size() + 1);
        xs.add(item);
        xs.addAll(list1);
        return xs;
    }

    @SafeVarargs
    public static final <T> List<T> concat(T first, T ... tail) {
        ArrayList<T> result = new ArrayList<T>(1 + tail.length);
        result.add(first);
        for (int i = 0; i < tail.length; ++i) {
            result.add(tail[i]);
        }
        return result;
    }

    @SafeVarargs
    public static final <T> List<T> concat(T first, T second, T ... tail) {
        ArrayList<T> result = new ArrayList<T>(2 + tail.length);
        result.add(first);
        result.add(second);
        for (int i = 0; i < tail.length; ++i) {
            result.add(tail[i]);
        }
        return result;
    }

    public static <T> List<T> concatUnique(List<? extends T> list1, Collection<? extends T> list2) {
        ArrayList<T> result = new ArrayList<T>(list1.size() + list2.size());
        result.addAll(list1);
        for (T item : list2) {
            if (list1.contains(item)) continue;
            result.add(item);
        }
        return result;
    }

    public static SequencedSet<?> flattenUnique(Iterable<?> items) {
        LinkedHashSet result = new LinkedHashSet();
        for (Object element : items) {
            if (element instanceof Iterable) {
                Iterable l = (Iterable)element;
                result.addAll(Lists.flattenUnique(l));
                continue;
            }
            result.add(element);
        }
        return result;
    }

    public static boolean equals(Collection<?> list1, Collection<?> list2) {
        if (list1 == list2) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        Iterator<?> it1 = list1.iterator();
        Iterator<?> it2 = list2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            if (Objects.equals(it1.next(), it2.next())) continue;
            return false;
        }
        return true;
    }

    public static <I, O> List<O> map(Collection<I> list, Function<? super I, ? extends O> mapper) {
        if (list.isEmpty()) {
            return List.of();
        }
        ArrayList<O> copy = new ArrayList<O>(list.size());
        for (I item : list) {
            copy.add(mapper.apply(item));
        }
        return copy;
    }

    public static <I, O> List<O> mapLazy(List<I> list, Function<? super I, ? extends O> mapper) {
        return new LazyMapList<I, O>(list, mapper);
    }

    public static <T> List<T> mapIfChange(List<T> list, Function<? super T, ? extends T> mapper) {
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<T> copy = new ArrayList<T>(list.size());
        boolean changed = false;
        for (T item : list) {
            T mapped = mapper.apply(item);
            changed = changed || item != mapped;
            copy.add(mapped);
        }
        return changed ? copy : list;
    }

    public static <T> T getOnlyElement(List<T> items) {
        switch (items.size()) {
            case 0: {
                throw new NoSuchElementException("List is empty");
            }
            case 1: {
                return items.get(0);
            }
        }
        throw new IllegalArgumentException("Expected 1 element, got: " + items.size());
    }

    public static <O, I> List<O> mapTail(O head, List<I> tail, Function<I, O> mapper) {
        ArrayList<O> list = new ArrayList<O>(tail.size() + 1);
        list.add(head);
        for (I input : tail) {
            list.add(mapper.apply(input));
        }
        return list;
    }

    public static <T> int findFirstNonPeer(List<T> items, int begin, int end, @Nullable Comparator<T> cmp) {
        if (cmp == null || begin + 1 >= end) {
            return end;
        }
        T fst = items.get(begin);
        if (cmp.compare(fst, items.get(begin + 1)) != 0) {
            return begin + 1;
        }
        int low = begin + 1;
        int high = end;
        while (low <= high) {
            int mid = low + high >>> 1;
            T t = items.get(mid);
            int cmpResult = cmp.compare(fst, t);
            if (cmpResult == 0) {
                int next = mid + 1;
                if (next == high || cmp.compare(fst, items.get(next)) != 0) {
                    return next;
                }
                low = next;
                continue;
            }
            if (cmpResult < 0) {
                high = mid;
                continue;
            }
            low = mid;
        }
        return end;
    }

    public static <T> int findFirstPreviousPeer(List<T> items, int itemIdx, @Nullable Comparator<T> cmp) {
        if (cmp == null) {
            return 0;
        }
        int firstPeer = itemIdx;
        T item = items.get(itemIdx);
        int i = itemIdx - 1;
        while (i >= 0 && cmp.compare(item, items.get(i)) == 0) {
            firstPeer = i--;
        }
        return firstPeer;
    }

    public static <T> int findFirstLTEProbeValue(List<T> sortedItems, int upperBoundary, int itemIdx, T probe, Comparator<T> cmp) {
        int start = itemIdx;
        int end = upperBoundary - 1;
        int firstLTEProbeIdx = -1;
        while (start <= end) {
            int mid = start + end >>> 1;
            if (cmp.compare(sortedItems.get(mid), probe) > 0) {
                end = mid - 1;
                continue;
            }
            firstLTEProbeIdx = mid;
            start = mid + 1;
        }
        return firstLTEProbeIdx;
    }

    public static <T> int findFirstGTEProbeValue(List<T> sortedItems, int lowerBoundary, int itemIdx, T probe, Comparator<T> cmp) {
        int start = lowerBoundary;
        int end = itemIdx - 1;
        int firstGTEProbeIdx = -1;
        while (start <= end) {
            int mid = start + end >>> 1;
            if (cmp.compare(sortedItems.get(mid), probe) < 0) {
                start = mid + 1;
                continue;
            }
            firstGTEProbeIdx = mid;
            end = mid - 1;
        }
        return firstGTEProbeIdx;
    }

    public static <T> String joinOn(String delimiter, List<? extends T> items, Function<? super T, String> mapper) {
        StringJoiner joiner = new StringJoiner(delimiter);
        for (int i = 0; i < items.size(); ++i) {
            joiner.add(mapper.apply(items.get(i)));
        }
        return joiner.toString();
    }

    public static <T> String joinOn(String delimiter, Iterable<? extends T> items, Function<? super T, String> mapper) {
        StringJoiner joiner = new StringJoiner(delimiter);
        for (T item : items) {
            joiner.add(mapper.apply(item));
        }
        return joiner.toString();
    }

    public static <T> List<T> rotate(List<T> list, int distance) {
        if (list.isEmpty()) {
            return list;
        }
        int d = distance % list.size();
        if (d < 0) {
            d += list.size();
        }
        if (d == 0) {
            return list;
        }
        return new RotatedList<T>(list, d);
    }

    public static <T> List<T> reverse(List<T> list) {
        if (list instanceof ReverseList) {
            return ((ReverseList)list).getForwardList();
        }
        if (list instanceof RandomAccess) {
            return new RandomAccessReverseList<T>(list);
        }
        return new ReverseList<T>(list);
    }

    public static <T> List<List<T>> partition(List<T> list, int size) {
        Objects.requireNonNull(list);
        Objects.checkIndex(0, size);
        return list instanceof RandomAccess ? new RandomAccessPartition<T>(list, size) : new Partition<T>(list, size);
    }

    static class LazyMapList<I, O>
    extends AbstractList<O>
    implements RandomAccess {
        private final List<I> list;
        private final Function<? super I, ? extends O> mapper;

        LazyMapList(List<I> list, Function<? super I, ? extends O> mapper) {
            this.list = list;
            this.mapper = mapper;
        }

        @Override
        public O get(int index) {
            return this.mapper.apply(this.list.get(index));
        }

        @Override
        public int size() {
            return this.list.size();
        }
    }

    private static class RotatedList<T>
    extends AbstractList<T>
    implements RandomAccess {
        private final List<T> in;
        private final int distance;

        RotatedList(List<T> list, int distance) {
            if (distance < 0 || distance >= list.size()) {
                throw new IllegalArgumentException();
            }
            if (!(list instanceof RandomAccess)) {
                throw new IllegalArgumentException();
            }
            this.in = list;
            this.distance = distance;
        }

        @Override
        public T get(int index) {
            int idx = this.distance + index;
            if (idx < 0 || idx >= this.in.size()) {
                idx -= this.in.size();
            }
            return this.in.get(idx);
        }

        @Override
        public int size() {
            return this.in.size();
        }
    }

    private static class ReverseList<T>
    extends AbstractList<T> {
        private final List<T> forwardList;

        ReverseList(List<T> forwardList) {
            this.forwardList = Objects.requireNonNull(forwardList);
        }

        List<T> getForwardList() {
            return this.forwardList;
        }

        private int reverseIndex(int index) {
            int size = this.size();
            Objects.checkIndex(index, size);
            return size - 1 - index;
        }

        private int reversePosition(int index) {
            int size = this.size();
            Objects.checkIndex(index, size);
            return size - index;
        }

        @Override
        public void add(int index, @Nullable T element) {
            this.forwardList.add(this.reversePosition(index), element);
        }

        @Override
        public void clear() {
            this.forwardList.clear();
        }

        @Override
        public T remove(int index) {
            return this.forwardList.remove(this.reverseIndex(index));
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            this.subList(fromIndex, toIndex).clear();
        }

        @Override
        public T set(int index, @Nullable T element) {
            return this.forwardList.set(this.reverseIndex(index), element);
        }

        @Override
        public T get(int index) {
            return this.forwardList.get(this.reverseIndex(index));
        }

        @Override
        public int size() {
            return this.forwardList.size();
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            Objects.checkFromToIndex(fromIndex, toIndex, this.size());
            return Lists.reverse(this.forwardList.subList(this.reversePosition(toIndex), this.reversePosition(fromIndex)));
        }

        @Override
        public Iterator<T> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            int start = this.reversePosition(index);
            final ListIterator<T> forwardIterator = this.forwardList.listIterator(start);
            return new ListIterator<T>(){
                boolean canRemoveOrSet;
                final /* synthetic */ ReverseList this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void add(T e) {
                    forwardIterator.add(e);
                    forwardIterator.previous();
                    this.canRemoveOrSet = false;
                }

                @Override
                public boolean hasNext() {
                    return forwardIterator.hasPrevious();
                }

                @Override
                public boolean hasPrevious() {
                    return forwardIterator.hasNext();
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.canRemoveOrSet = true;
                    return forwardIterator.previous();
                }

                @Override
                public int nextIndex() {
                    return this.this$0.reversePosition(forwardIterator.nextIndex());
                }

                @Override
                public T previous() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.canRemoveOrSet = true;
                    return forwardIterator.next();
                }

                @Override
                public int previousIndex() {
                    return this.nextIndex() - 1;
                }

                @Override
                public void remove() {
                    assert (this.canRemoveOrSet);
                    forwardIterator.remove();
                    this.canRemoveOrSet = false;
                }

                @Override
                public void set(T e) {
                    assert (this.canRemoveOrSet);
                    forwardIterator.set(e);
                }
            };
        }
    }

    private static class RandomAccessReverseList<T>
    extends ReverseList<T>
    implements RandomAccess {
        RandomAccessReverseList(List<T> forwardList) {
            super(forwardList);
        }
    }

    private static class RandomAccessPartition<T>
    extends Partition<T>
    implements RandomAccess {
        RandomAccessPartition(List<T> list, int size) {
            super(list, size);
        }
    }

    private static class Partition<T>
    extends AbstractList<List<T>> {
        final List<T> list;
        final int size;

        Partition(List<T> list, int size) {
            this.list = list;
            this.size = size;
        }

        @Override
        public List<T> get(int index) {
            Objects.checkIndex(index, this.size());
            int start = index * this.size;
            int end = Math.min(start + this.size, this.list.size());
            return this.list.subList(start, end);
        }

        @Override
        public int size() {
            return (int)Math.ceil((double)this.list.size() / (double)this.size);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }
    }
}

