/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common.concurrent;

import io.crate.common.concurrent.Measurement;
import java.util.function.DoubleUnaryOperator;

public class ExpAvgMeasurement
implements Measurement {
    private double value = 0.0;
    private double sum = 0.0;
    private final int window;
    private final int warmupWindow;
    private int count = 0;

    public ExpAvgMeasurement(int window, int warmupWindow) {
        this.window = window;
        this.warmupWindow = warmupWindow;
        this.sum = 0.0;
    }

    @Override
    public double add(double sample) {
        if (this.count < this.warmupWindow) {
            ++this.count;
            this.sum += sample;
            this.value = this.sum / (double)this.count;
        } else {
            double factor = ExpAvgMeasurement.factor(this.window);
            this.value = this.value * (1.0 - factor) + sample * factor;
        }
        return this.value;
    }

    private static double factor(int n) {
        return 2.0 / (double)(n + 1);
    }

    @Override
    public double get() {
        return this.value;
    }

    @Override
    public void reset() {
        this.value = 0.0;
        this.count = 0;
        this.sum = 0.0;
    }

    @Override
    public void update(DoubleUnaryOperator operation) {
        this.value = operation.applyAsDouble(this.value);
    }
}

