/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data;

import io.crate.data.BatchIterator;
import io.crate.data.BatchIterators;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collector;
import org.jetbrains.annotations.Nullable;

public class CollectingRowConsumer<S, R>
implements RowConsumer {
    private final Collector<Row, S, R> collector;
    private final CompletableFuture<R> resultFuture = new CompletableFuture();

    public CollectingRowConsumer(Collector<Row, S, R> collector) {
        this.collector = collector;
    }

    @Override
    public void accept(BatchIterator<Row> iterator, @Nullable Throwable failure) {
        if (failure == null) {
            BatchIterators.collect(iterator, this.collector.supplier().get(), this.collector, this.resultFuture);
        } else {
            if (iterator != null) {
                iterator.close();
            }
            this.resultFuture.completeExceptionally(failure);
        }
    }

    public CompletableFuture<R> completionFuture() {
        return this.resultFuture;
    }
}

