/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data;

import io.crate.data.Bucket;
import io.crate.data.Buckets;
import io.crate.data.Row;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;

public class CollectionBucket
implements Bucket {
    private final Collection<Object[]> rows;
    private final Function<Object[], Row> arrayToSharedRow;

    public CollectionBucket(Collection<Object[]> rows) {
        this.rows = rows;
        this.arrayToSharedRow = Buckets.arrayToSharedRow();
    }

    public CollectionBucket(Collection<Object[]> rows, int numColumns) {
        this.rows = rows;
        this.arrayToSharedRow = Buckets.arrayToSharedRow(numColumns);
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    @Override
    public Iterator<Row> iterator() {
        return this.rows.stream().map(this.arrayToSharedRow).iterator();
    }

    public String toString() {
        return "Bucket{numRows=" + this.rows.size() + "}";
    }
}

