/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data;

import io.crate.common.concurrent.CompletableFutures;
import io.crate.common.exceptions.Exceptions;
import io.crate.data.BatchIterator;
import io.crate.data.InMemoryBatchIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.IntSupplier;
import org.jetbrains.annotations.NotNull;

public final class CompositeBatchIterator {
    public static <T> BatchIterator<T> seqComposite(Collection<? extends BatchIterator<T>> iterators) {
        return CompositeBatchIterator.seqComposite(iterators.toArray(new BatchIterator[0]));
    }

    @SafeVarargs
    public static <T> BatchIterator<T> seqComposite(BatchIterator<T> ... iterators) {
        switch (iterators.length) {
            case 0: {
                return InMemoryBatchIterator.empty(null);
            }
            case 1: {
                return iterators[0];
            }
        }
        Comparator<BatchIterator> comparing = Comparator.comparing(BatchIterator::allLoaded);
        Arrays.sort(iterators, comparing.reversed());
        return new SeqCompositeBI<T>(iterators);
    }

    public static <T> BatchIterator<T> asyncComposite(Executor executor, IntSupplier availableThreads, Collection<? extends BatchIterator<T>> iterators) {
        if (iterators.size() == 1) {
            return iterators.iterator().next();
        }
        return new AsyncCompositeBI(executor, availableThreads, iterators.toArray(new BatchIterator[0]));
    }

    private static class SeqCompositeBI<T>
    extends AbstractCompositeBI<T> {
        SeqCompositeBI(BatchIterator<T>[] iterators) {
            super(iterators);
        }

        @Override
        public boolean moveNext() {
            while (this.idx < this.iterators.length) {
                BatchIterator iterator = this.iterators[this.idx];
                if (iterator.moveNext()) {
                    return true;
                }
                if (!iterator.allLoaded()) {
                    return false;
                }
                ++this.idx;
            }
            this.idx = 0;
            return false;
        }

        @Override
        public CompletionStage<?> loadNextBatch() throws Exception {
            for (BatchIterator iterator : this.iterators) {
                if (iterator.allLoaded()) continue;
                return iterator.loadNextBatch();
            }
            throw new IllegalStateException("BatchIterator already fully loaded");
        }
    }

    private static class AsyncCompositeBI<T>
    extends AbstractCompositeBI<T> {
        private final Executor executor;
        private final IntSupplier availableThreads;

        AsyncCompositeBI(Executor executor, IntSupplier availableThreads, BatchIterator<T>[] iterators) {
            super(iterators);
            this.executor = executor;
            this.availableThreads = availableThreads;
        }

        @Override
        public boolean moveNext() {
            while (this.idx < this.iterators.length) {
                BatchIterator iterator = this.iterators[this.idx];
                if (iterator.moveNext()) {
                    return true;
                }
                ++this.idx;
            }
            this.idx = 0;
            return false;
        }

        private int numIteratorsActive() {
            int activeIts = 0;
            for (BatchIterator it : this.iterators) {
                if (it.allLoaded()) continue;
                ++activeIts;
            }
            return activeIts;
        }

        @Override
        public CompletionStage<?> loadNextBatch() throws Exception {
            if (this.allLoaded()) {
                throw new IllegalStateException("BatchIterator already loaded");
            }
            int activeIts = this.numIteratorsActive();
            int numThreads = Math.max(1, this.availableThreads.getAsInt());
            int usedThreads = Math.min(numThreads, activeIts);
            ArrayList<CompletableFuture> nestedFutures = new ArrayList<CompletableFuture>(usedThreads);
            int t = 0;
            while (t < usedThreads) {
                int thread = t++;
                nestedFutures.add(CompletableFutures.supplyAsync(() -> {
                    ArrayList futures = new ArrayList();
                    for (int i = 0; i < this.iterators.length; ++i) {
                        BatchIterator it = this.iterators[i];
                        if (it.allLoaded() || i % usedThreads != thread) continue;
                        try {
                            futures.add(it.loadNextBatch().toCompletableFuture());
                            continue;
                        }
                        catch (Exception e) {
                            throw Exceptions.toRuntimeException((Throwable)e);
                        }
                    }
                    return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
                }, (Executor)this.executor));
            }
            return CompletableFutures.allAsList(nestedFutures).thenCompose(innerFutures -> CompletableFuture.allOf(innerFutures.toArray(new CompletableFuture[0])));
        }
    }

    private static abstract class AbstractCompositeBI<T>
    implements BatchIterator<T> {
        protected final BatchIterator<T>[] iterators;
        protected int idx = 0;

        AbstractCompositeBI(BatchIterator<T>[] iterators) {
            assert (iterators.length > 0) : "Must have at least 1 iterator";
            this.iterators = iterators;
        }

        @Override
        public T currentElement() {
            return this.iterators[this.idx].currentElement();
        }

        @Override
        public void moveToStart() {
            for (BatchIterator<T> iterator : this.iterators) {
                iterator.moveToStart();
            }
            this.idx = 0;
        }

        @Override
        public void close() {
            for (BatchIterator<T> iterator : this.iterators) {
                iterator.close();
            }
        }

        @Override
        public boolean allLoaded() {
            for (BatchIterator<T> iterator : this.iterators) {
                if (iterator.allLoaded()) continue;
                return false;
            }
            return true;
        }

        public void kill(@NotNull Throwable throwable) {
            for (BatchIterator<T> iterator : this.iterators) {
                iterator.kill(throwable);
            }
        }

        @Override
        public boolean hasLazyResultSet() {
            for (BatchIterator<T> iterator : this.iterators) {
                if (!iterator.hasLazyResultSet()) continue;
                return true;
            }
            return false;
        }
    }
}

