/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import java.util.Objects;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.repositories.s3.S3RepositorySettings;
import org.jetbrains.annotations.Nullable;

final class S3ClientSettings {
    @Nullable
    final AWSCredentials credentials;
    final String endpoint;
    final Protocol protocol;
    final String proxyHost;
    final int proxyPort;
    final String proxyUsername;
    final String proxyPassword;
    final int readTimeoutMillis;
    final int maxRetries;
    final boolean throttleRetries;
    final boolean pathStyleAccess;

    private S3ClientSettings(@Nullable AWSCredentials credentials, String endpoint, Protocol protocol, String proxyHost, int proxyPort, String proxyUsername, String proxyPassword, int readTimeoutMillis, int maxRetries, boolean throttleRetries, boolean pathStyleAccess) {
        this.credentials = credentials;
        this.endpoint = endpoint;
        this.protocol = protocol;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.readTimeoutMillis = readTimeoutMillis;
        this.maxRetries = maxRetries;
        this.throttleRetries = throttleRetries;
        this.pathStyleAccess = pathStyleAccess;
    }

    /*
     * Exception decompiling
     */
    private static AWSCredentials loadCredentials(Settings settings) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static S3ClientSettings getClientSettings(Settings settings) {
        AWSCredentials credentials = S3ClientSettings.loadCredentials(settings);
        return S3ClientSettings.getClientSettings(settings, credentials);
    }

    private static S3ClientSettings getClientSettings(Settings settings, AWSCredentials credentials) {
        try (SecureString proxyUsername = S3ClientSettings.getConfigValue(settings, S3RepositorySettings.PROXY_USERNAME_SETTING);){
            S3ClientSettings s3ClientSettings;
            block12: {
                SecureString proxyPassword = S3ClientSettings.getConfigValue(settings, S3RepositorySettings.PROXY_PASSWORD_SETTING);
                try {
                    s3ClientSettings = new S3ClientSettings(credentials, S3ClientSettings.getConfigValue(settings, S3RepositorySettings.ENDPOINT_SETTING), S3ClientSettings.getConfigValue(settings, S3RepositorySettings.PROTOCOL_SETTING), S3ClientSettings.getConfigValue(settings, S3RepositorySettings.PROXY_HOST_SETTING), S3ClientSettings.getConfigValue(settings, S3RepositorySettings.PROXY_PORT_SETTING), proxyUsername.toString(), proxyPassword.toString(), Math.toIntExact(S3ClientSettings.getConfigValue(settings, S3RepositorySettings.READ_TIMEOUT_SETTING).millis()), S3ClientSettings.getConfigValue(settings, S3RepositorySettings.MAX_RETRIES_SETTING), S3ClientSettings.getConfigValue(settings, S3RepositorySettings.USE_THROTTLE_RETRIES_SETTING), S3ClientSettings.getConfigValue(settings, S3RepositorySettings.USE_PATH_STYLE_ACCESS));
                    if (proxyPassword == null) break block12;
                }
                catch (Throwable throwable) {
                    if (proxyPassword != null) {
                        try {
                            proxyPassword.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                proxyPassword.close();
            }
            return s3ClientSettings;
        }
    }

    private static <T> T getConfigValue(Settings settings, Setting<T> clientSetting) {
        return (T)clientSetting.get(settings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3ClientSettings that = (S3ClientSettings)o;
        return this.proxyPort == that.proxyPort && this.readTimeoutMillis == that.readTimeoutMillis && this.maxRetries == that.maxRetries && this.throttleRetries == that.throttleRetries && this.compareCredentials(this.credentials, that.credentials) && Objects.equals(this.endpoint, that.endpoint) && this.protocol == that.protocol && Objects.equals(this.proxyHost, that.proxyHost) && Objects.equals(this.proxyUsername, that.proxyUsername) && Objects.equals(this.proxyPassword, that.proxyPassword) && this.pathStyleAccess == that.pathStyleAccess;
    }

    public int hashCode() {
        String accessKey = null;
        String secretKey = null;
        if (this.credentials != null) {
            accessKey = this.credentials.getAWSAccessKeyId();
            secretKey = this.credentials.getAWSSecretKey();
        }
        return Objects.hash(accessKey, secretKey, this.endpoint, this.protocol, this.proxyHost, this.proxyPort, this.proxyUsername, this.proxyPassword, this.readTimeoutMillis, this.maxRetries, this.throttleRetries, this.pathStyleAccess);
    }

    private boolean compareCredentials(@Nullable AWSCredentials first, @Nullable AWSCredentials second) {
        if (first != null && second != null) {
            return first.getAWSAccessKeyId().equals(second.getAWSAccessKeyId()) && first.getAWSSecretKey().equals(second.getAWSSecretKey());
        }
        return first == second;
    }
}

