/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.repositories.s3.S3BlobStore;
import org.elasticsearch.repositories.s3.S3RepositorySettings;
import org.elasticsearch.repositories.s3.S3Service;

public class S3Repository
extends BlobStoreRepository {
    private static final Logger LOGGER = LogManager.getLogger(S3Repository.class);
    static final String TYPE = "s3";
    private final S3Service service;
    private final String bucket;
    private final ByteSizeValue bufferSize;
    private final ByteSizeValue chunkSize;
    private final boolean serverSideEncryption;
    private final String storageClass;
    private final String cannedACL;

    public static List<Setting<?>> optionalSettings() {
        return List.of(S3RepositorySettings.ACCESS_KEY_SETTING, S3RepositorySettings.SECRET_KEY_SETTING, S3RepositorySettings.BASE_PATH_SETTING, S3RepositorySettings.BUCKET_SETTING, S3RepositorySettings.BUFFER_SIZE_SETTING, S3RepositorySettings.CANNED_ACL_SETTING, S3RepositorySettings.CHUNK_SIZE_SETTING, COMPRESS_SETTING, S3RepositorySettings.SERVER_SIDE_ENCRYPTION_SETTING, S3RepositorySettings.ENDPOINT_SETTING, S3RepositorySettings.PROTOCOL_SETTING, S3RepositorySettings.MAX_RETRIES_SETTING, S3RepositorySettings.USE_THROTTLE_RETRIES_SETTING, S3RepositorySettings.READONLY_SETTING, S3RepositorySettings.STORAGE_CLASS_SETTING, S3RepositorySettings.USE_PATH_STYLE_ACCESS);
    }

    S3Repository(RepositoryMetadata metadata, NamedWriteableRegistry namedWriteableRegistry, NamedXContentRegistry namedXContentRegistry, S3Service service, ClusterService clusterService, RecoverySettings recoverySettings) {
        super(metadata, namedWriteableRegistry, namedXContentRegistry, clusterService, recoverySettings, S3Repository.buildBasePath(metadata));
        this.service = service;
        this.bucket = (String)S3RepositorySettings.BUCKET_SETTING.get(metadata.settings());
        if (this.bucket == null) {
            throw new RepositoryException(metadata.name(), "No bucket defined for s3 repository");
        }
        this.bufferSize = (ByteSizeValue)S3RepositorySettings.BUFFER_SIZE_SETTING.get(metadata.settings());
        this.chunkSize = (ByteSizeValue)S3RepositorySettings.CHUNK_SIZE_SETTING.get(metadata.settings());
        if (this.chunkSize.getBytes() < this.bufferSize.getBytes()) {
            throw new RepositoryException(metadata.name(), S3RepositorySettings.CHUNK_SIZE_SETTING.getKey() + " (" + String.valueOf(this.chunkSize) + ") can't be lower than " + S3RepositorySettings.BUFFER_SIZE_SETTING.getKey() + " (" + String.valueOf(this.bufferSize) + ").");
        }
        this.serverSideEncryption = (Boolean)S3RepositorySettings.SERVER_SIDE_ENCRYPTION_SETTING.get(metadata.settings());
        this.storageClass = (String)S3RepositorySettings.STORAGE_CLASS_SETTING.get(metadata.settings());
        this.cannedACL = (String)S3RepositorySettings.CANNED_ACL_SETTING.get(metadata.settings());
        LOGGER.debug("using bucket [{}], chunk_size [{}], server_side_encryption [{}], buffer_size [{}], cannedACL [{}], storageClass [{}]", (Object)this.bucket, (Object)this.chunkSize, (Object)this.serverSideEncryption, (Object)this.bufferSize, (Object)this.cannedACL, (Object)this.storageClass);
    }

    private static BlobPath buildBasePath(RepositoryMetadata metadata) {
        String basePath = (String)S3RepositorySettings.BASE_PATH_SETTING.get(metadata.settings());
        if (Strings.hasLength((CharSequence)basePath)) {
            return new BlobPath().add(basePath);
        }
        return BlobPath.cleanPath();
    }

    protected S3BlobStore createBlobStore() {
        return new S3BlobStore(this.service, this.bucket, this.serverSideEncryption, this.bufferSize, this.cannedACL, this.storageClass, this.metadata);
    }

    protected BlobStore getBlobStore() {
        return super.getBlobStore();
    }

    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    protected void doClose() {
        super.doClose();
    }
}

