/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import io.crate.common.unit.TimeValue;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.Locale;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.monitor.jvm.JvmInfo;

class S3RepositorySettings {
    static final Setting<Boolean> READONLY_SETTING = Setting.boolSetting((String)"readonly", (boolean)false, (Setting.Property[])new Setting.Property[0]);
    static final Setting<SecureString> ACCESS_KEY_SETTING = Setting.maskedString((String)"access_key");
    static final Setting<SecureString> SECRET_KEY_SETTING = Setting.maskedString((String)"secret_key");
    private static final ByteSizeValue DEFAULT_BUFFER_SIZE = new ByteSizeValue(Math.max(ByteSizeUnit.MB.toBytes(5L), Math.min(ByteSizeUnit.MB.toBytes(100L), JvmInfo.jvmInfo().getMem().getHeapMax().getBytes() / 20L)), ByteSizeUnit.BYTES);
    static final Setting<String> BUCKET_SETTING = Setting.simpleString((String)"bucket", (Setting.Property[])new Setting.Property[0]);
    static final Setting<Boolean> SERVER_SIDE_ENCRYPTION_SETTING = Setting.boolSetting((String)"server_side_encryption", (boolean)false, (Setting.Property[])new Setting.Property[0]);
    static final ByteSizeValue MAX_FILE_SIZE = new ByteSizeValue(5L, ByteSizeUnit.GB);
    static final ByteSizeValue MIN_PART_SIZE_USING_MULTIPART = new ByteSizeValue(5L, ByteSizeUnit.MB);
    private static final ByteSizeValue MAX_PART_SIZE_USING_MULTIPART = MAX_FILE_SIZE;
    static final ByteSizeValue MAX_FILE_SIZE_USING_MULTIPART = new ByteSizeValue(5L, ByteSizeUnit.TB);
    static final Setting<ByteSizeValue> BUFFER_SIZE_SETTING = Setting.byteSizeSetting((String)"buffer_size", (ByteSizeValue)DEFAULT_BUFFER_SIZE, (ByteSizeValue)MIN_PART_SIZE_USING_MULTIPART, (ByteSizeValue)MAX_PART_SIZE_USING_MULTIPART, (Setting.Property[])new Setting.Property[0]);
    static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting((String)"chunk_size", (ByteSizeValue)new ByteSizeValue(1L, ByteSizeUnit.GB), (ByteSizeValue)new ByteSizeValue(5L, ByteSizeUnit.MB), (ByteSizeValue)new ByteSizeValue(5L, ByteSizeUnit.TB), (Setting.Property[])new Setting.Property[0]);
    static final Setting<String> STORAGE_CLASS_SETTING = Setting.simpleString((String)"storage_class", (Setting.Property[])new Setting.Property[0]);
    static final Setting<String> CANNED_ACL_SETTING = Setting.simpleString((String)"canned_acl", (Setting.Property[])new Setting.Property[0]);
    static final Setting<String> BASE_PATH_SETTING = Setting.simpleString((String)"base_path", (Setting.Property[])new Setting.Property[0]);
    static final Setting<SecureString> SESSION_TOKEN_SETTING = Setting.maskedString((String)"session_token");
    static final Setting<String> ENDPOINT_SETTING = new Setting("endpoint", "", s -> s.toLowerCase(Locale.ROOT), (DataType)DataTypes.STRING, new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<Protocol> PROTOCOL_SETTING = new Setting("protocol", "https", s -> Protocol.valueOf((String)s.toUpperCase(Locale.ROOT)), (DataType)DataTypes.STRING, new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<String> PROXY_HOST_SETTING = Setting.simpleString((String)"proxy_host", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<Integer> PROXY_PORT_SETTING = Setting.intSetting((String)"proxy_port", (int)80, (int)0, (int)65536, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<SecureString> PROXY_USERNAME_SETTING = Setting.maskedString((String)"proxy_username");
    static final Setting<SecureString> PROXY_PASSWORD_SETTING = Setting.maskedString((String)"proxy_password");
    static final Setting<TimeValue> READ_TIMEOUT_SETTING = Setting.timeSetting((String)"read_timeout", (TimeValue)TimeValue.timeValueMillis((long)50000L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<Integer> MAX_RETRIES_SETTING = Setting.intSetting((String)"max_retries", (int)ClientConfiguration.DEFAULT_RETRY_POLICY.getMaxErrorRetry(), (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<Boolean> USE_THROTTLE_RETRIES_SETTING = Setting.boolSetting((String)"use_throttle_retries", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<Boolean> USE_PATH_STYLE_ACCESS = Setting.boolSetting((String)"use_path_style_access", (boolean)false, (Setting.Property[])new Setting.Property[0]);

    S3RepositorySettings() {
    }
}

