/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Objects;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SuppressFBWarnings;
import org.apache.datasketches.kll.KllDirectFloatsSketch;
import org.apache.datasketches.kll.KllFloatsHelper;
import org.apache.datasketches.kll.KllFloatsSketchIterator;
import org.apache.datasketches.kll.KllFloatsSketchSortedView;
import org.apache.datasketches.kll.KllHeapFloatsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantilescommon.FloatsSortedView;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesFloatsAPI;
import org.apache.datasketches.quantilescommon.QuantilesFloatsSketchIterator;

public abstract class KllFloatsSketch
extends KllSketch
implements QuantilesFloatsAPI {
    private KllFloatsSketchSortedView kllFloatsSV = null;
    static final int ITEM_BYTES = 4;

    KllFloatsSketch(KllSketch.SketchStructure sketchStructure) {
        super(KllSketch.SketchType.FLOATS_SKETCH, sketchStructure);
    }

    public static KllFloatsSketch newHeapInstance() {
        return KllFloatsSketch.newHeapInstance(200);
    }

    public static KllFloatsSketch newHeapInstance(int k) {
        return new KllHeapFloatsSketch(k, 8);
    }

    public static KllFloatsSketch newDirectInstance(WritableMemory dstMem, MemoryRequestServer memReqSvr) {
        return KllFloatsSketch.newDirectInstance(200, dstMem, memReqSvr);
    }

    public static KllFloatsSketch newDirectInstance(int k, WritableMemory dstMem, MemoryRequestServer memReqSvr) {
        Objects.requireNonNull(dstMem, "Parameter 'dstMem' must not be null");
        Objects.requireNonNull(memReqSvr, "Parameter 'memReqSvr' must not be null");
        return KllDirectFloatsSketch.newDirectUpdatableInstance(k, 8, dstMem, memReqSvr);
    }

    public static KllFloatsSketch heapify(Memory srcMem) {
        Objects.requireNonNull(srcMem, "Parameter 'srcMem' must not be null");
        return KllHeapFloatsSketch.heapifyImpl(srcMem);
    }

    public static KllFloatsSketch wrap(Memory srcMem) {
        Objects.requireNonNull(srcMem, "Parameter 'srcMem' must not be null");
        KllMemoryValidate memVal = new KllMemoryValidate(srcMem, KllSketch.SketchType.FLOATS_SKETCH, null);
        if (memVal.sketchStructure == KllSketch.SketchStructure.UPDATABLE) {
            DefaultMemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();
            return new KllDirectFloatsSketch(memVal.sketchStructure, (WritableMemory)srcMem, (MemoryRequestServer)memReqSvr, memVal);
        }
        return new KllDirectFloatsSketch.KllDirectCompactFloatsSketch(memVal.sketchStructure, srcMem, memVal);
    }

    public static KllFloatsSketch writableWrap(WritableMemory srcMem, MemoryRequestServer memReqSvr) {
        Objects.requireNonNull(srcMem, "Parameter 'srcMem' must not be null");
        Objects.requireNonNull(memReqSvr, "Parameter 'memReqSvr' must not be null");
        KllMemoryValidate memVal = new KllMemoryValidate((Memory)srcMem, KllSketch.SketchType.FLOATS_SKETCH, null);
        if (memVal.sketchStructure == KllSketch.SketchStructure.UPDATABLE) {
            return new KllDirectFloatsSketch(KllSketch.SketchStructure.UPDATABLE, srcMem, memReqSvr, memVal);
        }
        return new KllDirectFloatsSketch.KllDirectCompactFloatsSketch(memVal.sketchStructure, (Memory)srcMem, memVal);
    }

    @Override
    public double[] getCDF(float[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.kllFloatsSV.getCDF(splitPoints, searchCrit);
    }

    @Override
    public double[] getPMF(float[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.kllFloatsSV.getPMF(splitPoints, searchCrit);
    }

    @Override
    public float getQuantile(double rank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.kllFloatsSV.getQuantile(rank, searchCrit);
    }

    @Override
    public float[] getQuantiles(double[] ranks, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        int len = ranks.length;
        float[] quantiles = new float[len];
        for (int i = 0; i < len; ++i) {
            quantiles[i] = this.kllFloatsSV.getQuantile(ranks[i], searchCrit);
        }
        return quantiles;
    }

    @Override
    public float getQuantileLowerBound(double rank) {
        return this.getQuantile(Math.max(0.0, rank - KllHelper.getNormalizedRankError(this.getMinK(), false)));
    }

    @Override
    public float getQuantileUpperBound(double rank) {
        return this.getQuantile(Math.min(1.0, rank + KllHelper.getNormalizedRankError(this.getMinK(), false)));
    }

    @Override
    public double getRank(float quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.kllFloatsSV.getRank(quantile, searchCrit);
    }

    @Override
    public double getRankLowerBound(double rank) {
        return Math.max(0.0, rank - KllHelper.getNormalizedRankError(this.getMinK(), false));
    }

    @Override
    public double getRankUpperBound(double rank) {
        return Math.min(1.0, rank + KllHelper.getNormalizedRankError(this.getMinK(), false));
    }

    @Override
    public double[] getRanks(float[] quantiles, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        int len = quantiles.length;
        double[] ranks = new double[len];
        for (int i = 0; i < len; ++i) {
            ranks[i] = this.kllFloatsSV.getRank(quantiles[i], searchCrit);
        }
        return ranks;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="OK in this case.")
    public FloatsSortedView getSortedView() {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.kllFloatsSV;
    }

    @Override
    public QuantilesFloatsSketchIterator iterator() {
        return new KllFloatsSketchIterator(this.getFloatItemsArray(), this.getLevelsArray(KllSketch.SketchStructure.UPDATABLE), this.getNumLevels());
    }

    @Override
    public final void merge(KllSketch other) {
        if (this.readOnly || this.sketchStructure != KllSketch.SketchStructure.UPDATABLE) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllFloatsSketch othFltSk = (KllFloatsSketch)other;
        if (othFltSk.isEmpty()) {
            return;
        }
        KllFloatsHelper.mergeFloatImpl(this, othFltSk);
        this.kllFloatsSV = null;
    }

    @Override
    public final void reset() {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int k = this.getK();
        this.setN(0L);
        this.setMinK(k);
        this.setNumLevels(1);
        this.setLevelZeroSorted(false);
        this.setLevelsArray(new int[]{k, k});
        this.setMinItem(Float.NaN);
        this.setMaxItem(Float.NaN);
        this.setFloatItemsArray(new float[k]);
        this.kllFloatsSV = null;
    }

    @Override
    public byte[] toByteArray() {
        return KllHelper.toByteArray(this, false);
    }

    @Override
    public String toString(boolean withSummary, boolean withData) {
        KllFloatsSketch sketch = this;
        if (withData && this.sketchStructure != KllSketch.SketchStructure.UPDATABLE) {
            WritableMemory mem = this.getWritableMemory();
            assert (mem != null);
            sketch = KllFloatsSketch.heapify((Memory)this.getWritableMemory());
        }
        return KllHelper.toStringImpl(sketch, withSummary, withData, this.getSerDe());
    }

    @Override
    public void update(float item) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllFloatsHelper.updateFloat(this, item);
        this.kllFloatsSV = null;
    }

    abstract float[] getFloatItemsArray();

    abstract float[] getFloatRetainedItemsArray();

    abstract float getFloatSingleItem();

    @Override
    abstract byte[] getMinMaxByteArr();

    @Override
    int getMinMaxSizeBytes() {
        return 8;
    }

    @Override
    abstract byte[] getRetainedItemsByteArr();

    @Override
    int getRetainedItemsSizeBytes() {
        return this.getNumRetained() * 4;
    }

    @Override
    ArrayOfItemsSerDe<?> getSerDe() {
        return null;
    }

    @Override
    final byte[] getSingleItemByteArr() {
        byte[] bytes = new byte[4];
        ByteArrayUtil.putFloatLE(bytes, 0, this.getFloatSingleItem());
        return bytes;
    }

    @Override
    int getSingleItemSizeBytes() {
        return 4;
    }

    @Override
    abstract byte[] getTotalItemsByteArr();

    @Override
    int getTotalItemsNumBytes() {
        return this.levelsArr[this.getNumLevels()] * 4;
    }

    private final void refreshSortedView() {
        this.kllFloatsSV = this.kllFloatsSV == null ? new KllFloatsSketchSortedView(this) : this.kllFloatsSV;
    }

    abstract void setFloatItemsArray(float[] var1);

    abstract void setFloatItemsArrayAt(int var1, float var2);

    abstract void setMaxItem(float var1);

    abstract void setMinItem(float var1);
}

