/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.nfa;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.RegexRootNode;
import com.oracle.truffle.regex.charset.CharMatchers;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.buffer.IntRingBuffer;
import com.oracle.truffle.regex.tregex.matchers.CharMatcher;
import com.oracle.truffle.regex.tregex.nfa.PureNFA;
import com.oracle.truffle.regex.tregex.nfa.PureNFAState;
import com.oracle.truffle.regex.tregex.nfa.PureNFATransition;
import com.oracle.truffle.regex.tregex.nfa.TransitionGuard;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorBaseNode;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputOps;
import com.oracle.truffle.regex.tregex.nodes.nfa.TRegexBacktrackerSubExecutorNode;
import com.oracle.truffle.regex.tregex.nodes.nfa.TRegexBacktrackingNFAExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.nfa.TRegexLiteralLookAroundExecutorNode;
import com.oracle.truffle.regex.tregex.parser.CaseFoldData;
import com.oracle.truffle.regex.tregex.parser.MultiCharacterCaseFolding;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.InnerLiteral;
import com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.QuantifiableTerm;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import com.oracle.truffle.regex.tregex.parser.flavors.RegexFlavor;
import java.util.List;
import org.graalvm.collections.Pair;

public final class TRegexBacktrackingNFAExecutorNode
extends TRegexBacktrackerSubExecutorNode {
    private static final int FLAG_WRITES_CAPTURE_GROUPS = 1;
    private static final int FLAG_FORWARD = 2;
    private static final int FLAG_BACKREF_WITH_NULL_TARGET_FAILS = 4;
    private static final int FLAG_MONITOR_CAPTURE_GROUPS_IN_EMPTY_CHECK = 8;
    private static final int FLAG_TRANSITION_MATCHES_STEP_BY_STEP = 16;
    private static final int FLAG_EMPTY_CHECKS_ON_MANDATORY_LOOP_ITERATIONS = 32;
    private static final int FLAG_TRACK_LAST_GROUP = 64;
    private static final int FLAG_RETURNS_FIRST_GROUP = 128;
    private static final int FLAG_MUST_ADVANCE = 256;
    private static final int FLAG_LONE_SURROGATES = 512;
    private static final int FLAG_LOOPBACK_INITIAL_STATE = 1024;
    private static final int FLAG_USE_MERGE_EXPLODE = 2048;
    private static final int FLAG_RECURSIVE_BACK_REFERENCES = 4096;
    private static final int FLAG_BACKREF_IGNORE_CASE_MULTI_CHARACTER_EXPANSION = 8192;
    private final PureNFA nfa;
    private final int numberOfStates;
    private final int nQuantifiers;
    private final int nZeroWidthQuantifiers;
    private final int maxNTransitions;
    private final int flags;
    private final InnerLiteral innerLiteral;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final CharMatcher[] matchers;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Token.Quantifier[] quantifiers;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Token.Quantifier[] zeroWidthQuantifiers;
    private final int[] zeroWidthTermEnclosedCGLow;
    private final int[] zeroWidthQuantifierCGOffsets;
    private final RegexFlavor.EqualsIgnoreCasePredicate equalsIgnoreCase;
    private final CaseFoldData.CaseFoldAlgorithm multiCharacterExpansionCaseFoldAlgorithm;
    @Node.Child
    TruffleString.RegionEqualByteIndexNode regionMatchesNode;
    @Node.Child
    TruffleString.ByteIndexOfStringNode indexOfNode;
    private final CharMatcher loopbackInitialStateMatcher;
    private static final int IP_BEGIN = -1;
    private static final int IP_BACKTRACK = -2;
    private static final int IP_END = -3;

    public TRegexBacktrackingNFAExecutorNode(RegexAST ast, PureNFA nfa, int numberOfStates, int numberOfTransitions, TRegexExecutorBaseNode[] subExecutors, boolean mustAdvance, CompilationBuffer compilationBuffer) {
        super(ast, numberOfTransitions, subExecutors);
        CodePointSet initialCharSet;
        this.numberOfStates = numberOfStates;
        RegexASTSubtreeRootNode subtree = nfa.getASTSubtree(ast);
        this.nfa = nfa;
        this.flags = TRegexBacktrackingNFAExecutorNode.createFlags(ast, nfa, mustAdvance, subtree, numberOfStates, numberOfTransitions);
        this.nQuantifiers = ast.getQuantifierCount();
        this.quantifiers = ast.getQuantifierArray();
        this.nZeroWidthQuantifiers = ast.getZeroWidthQuantifiables().size();
        List<QuantifiableTerm> zeroWidthQuantifiables = ast.getZeroWidthQuantifiables();
        this.zeroWidthQuantifiers = new Token.Quantifier[this.nZeroWidthQuantifiers];
        this.zeroWidthTermEnclosedCGLow = new int[this.nZeroWidthQuantifiers];
        this.zeroWidthQuantifierCGOffsets = new int[this.zeroWidthTermEnclosedCGLow.length + 1];
        int offset = 0;
        for (int i = 0; i < this.nZeroWidthQuantifiers; ++i) {
            QuantifiableTerm quantifiable = zeroWidthQuantifiables.get(i);
            if (quantifiable.isGroup()) {
                Group group = quantifiable.asGroup();
                this.zeroWidthTermEnclosedCGLow[i] = group.getCaptureGroupsLow();
                offset += 2 * (group.getCaptureGroupsHigh() - group.getCaptureGroupsLow());
            }
            this.zeroWidthQuantifierCGOffsets[i + 1] = offset;
            this.zeroWidthQuantifiers[quantifiable.getQuantifier().getZeroWidthIndex()] = quantifiable.getQuantifier();
        }
        this.innerLiteral = nfa.isRoot() && ast.getProperties().hasInnerLiteral() ? ast.extractInnerLiteral() : null;
        this.equalsIgnoreCase = ast.getOptions().getFlavor().getEqualsIgnoreCasePredicate(ast);
        this.multiCharacterExpansionCaseFoldAlgorithm = this.isBackreferenceIgnoreCaseMultiCharExpansion() && ast.getProperties().hasBackReferences() ? ast.getOptions().getFlavor().getCaseFoldAlgorithm(ast) : null;
        this.loopbackInitialStateMatcher = this.isLoopbackInitialState() && this.innerLiteral == null ? ((initialCharSet = nfa.getMergedInitialStateCharSet(ast, compilationBuffer)) == null ? null : CharMatchers.createMatcher(initialCharSet, compilationBuffer)) : null;
        nfa.materializeGroupBoundaries();
        this.matchers = new CharMatcher[nfa.getNumberOfStates()];
        int maxTransitions = 0;
        for (int i = 0; i < this.matchers.length; ++i) {
            PureNFAState s = nfa.getState(i);
            if (s.isCharacterClass()) {
                this.matchers[i] = CharMatchers.createMatcher(s.getCharSet(), compilationBuffer);
            }
            maxTransitions = Math.max(maxTransitions, ((PureNFATransition[])s.getSuccessors()).length);
            s.initIsDeterministic(compilationBuffer);
        }
        for (TRegexExecutorBaseNode subExecutor : subExecutors) {
            if (!(subExecutor instanceof TRegexBacktrackingNFAExecutorNode)) continue;
            maxTransitions = Math.max(maxTransitions, ((TRegexBacktrackingNFAExecutorNode)subExecutor).maxNTransitions);
        }
        this.maxNTransitions = maxTransitions;
    }

    private TRegexBacktrackingNFAExecutorNode(TRegexBacktrackingNFAExecutorNode copy) {
        super(copy);
        this.nfa = copy.nfa;
        this.numberOfStates = copy.numberOfStates;
        this.quantifiers = copy.quantifiers;
        this.nQuantifiers = copy.nQuantifiers;
        this.zeroWidthQuantifiers = copy.zeroWidthQuantifiers;
        this.nZeroWidthQuantifiers = copy.nZeroWidthQuantifiers;
        this.maxNTransitions = copy.maxNTransitions;
        this.flags = copy.flags;
        this.innerLiteral = copy.innerLiteral;
        this.matchers = copy.matchers;
        this.zeroWidthTermEnclosedCGLow = copy.zeroWidthTermEnclosedCGLow;
        this.zeroWidthQuantifierCGOffsets = copy.zeroWidthQuantifierCGOffsets;
        this.equalsIgnoreCase = copy.equalsIgnoreCase;
        this.loopbackInitialStateMatcher = copy.loopbackInitialStateMatcher;
        this.multiCharacterExpansionCaseFoldAlgorithm = copy.multiCharacterExpansionCaseFoldAlgorithm;
    }

    @Override
    public TRegexBacktrackerSubExecutorNode shallowCopy() {
        return new TRegexBacktrackingNFAExecutorNode(this);
    }

    @Override
    public int getNumberOfStates() {
        return this.numberOfStates;
    }

    private static int createFlags(RegexAST ast, PureNFA nfa, boolean mustAdvance, RegexASTSubtreeRootNode subtree, int nStates, int nTransitions) {
        int flags = 0;
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 1, subtree.hasCaptureGroups());
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 2, !(subtree instanceof LookBehindAssertion));
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 4, ast.getOptions().getFlavor().backreferencesToUnmatchedGroupsFail());
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 8, ast.getOptions().getFlavor().emptyChecksMonitorCaptureGroups());
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 16, ast.getOptions().getFlavor().matchesTransitionsStepByStep());
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 32, ast.getOptions().getFlavor().emptyChecksOnMandatoryLoopIterations());
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 64, ast.getOptions().getFlavor().usesLastGroupResultField());
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 128, !TRegexBacktrackingNFAExecutorNode.isFlagSet(flags, 2) && ast.getOptions().getFlavor().lookBehindsRunLeftToRight());
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 256, mustAdvance);
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 512, ast.getProperties().hasLoneSurrogates());
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 1024, nfa.isRoot() && !ast.getFlags().isSticky() && !ast.getRoot().startsWithCaret());
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 2048, nStates <= ast.getOptions().getMaxBackTrackerCompileSize() && nTransitions <= ast.getOptions().getMaxBackTrackerCompileSize());
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 4096, ast.getProperties().hasRecursiveBackReferences());
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 8192, ast.getOptions().getFlavor().backreferenceIgnoreCaseMultiCharExpansion() && ast.getProperties().hasBackReferences());
        return flags;
    }

    @Override
    public boolean writesCaptureGroups() {
        return this.isFlagSet(1);
    }

    @Override
    public String getName() {
        return "bt";
    }

    @Override
    public boolean isForward() {
        return this.isFlagSet(2);
    }

    public boolean isBackrefWithNullTargetFails() {
        return this.isFlagSet(4);
    }

    public boolean isMonitorCaptureGroupsInEmptyCheck() {
        return this.isFlagSet(8);
    }

    public boolean isTransitionMatchesStepByStep() {
        return this.isFlagSet(16);
    }

    public boolean isEmptyChecksOnMandatoryLoopIterations() {
        return this.isFlagSet(32);
    }

    public boolean isTrackLastGroup() {
        return this.isFlagSet(64);
    }

    public boolean isMustAdvance() {
        return this.isFlagSet(256);
    }

    public boolean isLoneSurrogates() {
        return this.isFlagSet(512);
    }

    public boolean isLoopbackInitialState() {
        return this.isFlagSet(1024);
    }

    public boolean isUseMergeExplode() {
        return this.isFlagSet(2048);
    }

    public boolean isRecursiveBackreferences() {
        return this.isFlagSet(4096);
    }

    public boolean isBackreferenceIgnoreCaseMultiCharExpansion() {
        return this.isFlagSet(8192);
    }

    private boolean isFlagSet(int flag) {
        return TRegexBacktrackingNFAExecutorNode.isFlagSet(this.flags, flag);
    }

    private Token.Quantifier getQuantifier(long guard) {
        CompilerAsserts.partialEvaluationConstant((long)guard);
        int quantifierIndex = TransitionGuard.getQuantifierIndex(guard);
        CompilerAsserts.partialEvaluationConstant((int)quantifierIndex);
        return this.quantifiers[quantifierIndex];
    }

    private Token.Quantifier getZeroWidthQuantifier(long guard) {
        CompilerAsserts.partialEvaluationConstant((Object)((Object)this));
        CompilerAsserts.partialEvaluationConstant((long)guard);
        int zeroWidthQuantifierIndex = TransitionGuard.getZeroWidthQuantifierIndex(guard);
        CompilerAsserts.partialEvaluationConstant((Object)this.zeroWidthQuantifiers);
        CompilerAsserts.partialEvaluationConstant((int)zeroWidthQuantifierIndex);
        Token.Quantifier zeroWidthQuantifier = this.zeroWidthQuantifiers[zeroWidthQuantifierIndex];
        CompilerAsserts.partialEvaluationConstant((Object)zeroWidthQuantifier);
        return zeroWidthQuantifier;
    }

    @Override
    public TRegexExecutorLocals createLocals(TruffleString input, int fromIndex, int maxIndex, int regionFrom, int regionTo, int index) {
        return TRegexBacktrackingNFAExecutorLocals.create(input, fromIndex, maxIndex, regionFrom, regionTo, index, this.getNumberOfCaptureGroups(), this.nQuantifiers, this.nZeroWidthQuantifiers, this.zeroWidthTermEnclosedCGLow, this.zeroWidthQuantifierCGOffsets, this.isTransitionMatchesStepByStep(), this.maxNTransitions, this.isTrackLastGroup(), this.returnsFirstGroup(), this.isRecursiveBackreferences(), this.isBackreferenceIgnoreCaseMultiCharExpansion());
    }

    @Override
    public Object execute(VirtualFrame frame, TRegexExecutorLocals abstractLocals, TruffleString.CodeRange codeRange) {
        TRegexBacktrackingNFAExecutorLocals locals = (TRegexBacktrackingNFAExecutorLocals)abstractLocals;
        if (this.innerLiteral != null) {
            locals.setIndex(locals.getFromIndex());
            int innerLiteralIndex = this.findInnerLiteral(locals);
            if (CompilerDirectives.injectBranchProbability((double)0.010000000000000009, (innerLiteralIndex < 0 ? 1 : 0) != 0)) {
                return null;
            }
            locals.setLastInnerLiteralIndex(innerLiteralIndex);
            if (this.innerLiteral.getMaxPrefixSize() < 0) {
                locals.setIndex(locals.getFromIndex());
            } else {
                locals.setIndex(innerLiteralIndex);
                this.rewindUpTo(locals, locals.getFromIndex(), this.innerLiteral.getMaxPrefixSize(), codeRange);
            }
        }
        if (this.isLoopbackInitialState()) {
            locals.setLastInitialStateIndex(locals.getIndex());
        }
        if (this.isUseMergeExplode()) {
            this.runMergeExplode(frame, locals, codeRange);
        } else {
            this.runSlowPath(frame.materialize(), locals, codeRange);
        }
        return locals.popResult();
    }

    @CompilerDirectives.TruffleBoundary
    private void runSlowPath(MaterializedFrame frame, TRegexBacktrackingNFAExecutorLocals locals, TruffleString.CodeRange codeRange) {
        this.runMergeExplode((VirtualFrame)frame, locals, codeRange);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.MERGE_EXPLODE)
    private void runMergeExplode(VirtualFrame frame, TRegexBacktrackingNFAExecutorLocals locals, TruffleString.CodeRange codeRange) {
        block18: {
            int nextIp;
            int ip = -1;
            block0: while (true) {
                locals.incLoopCount(this);
                if (CompilerDirectives.inInterpreter()) {
                    RegexRootNode.checkThreadInterrupted();
                }
                CompilerAsserts.partialEvaluationConstant((int)ip);
                if (ip == -1) {
                    if (this.nfa.getAnchoredInitialState() != this.nfa.getUnAnchoredInitialState() && this.inputAtBegin(locals)) {
                        ip = this.nfa.getAnchoredInitialState().getId();
                        continue;
                    }
                    ip = this.nfa.getUnAnchoredInitialState().getId();
                    continue;
                }
                if (ip == -2) {
                    if (CompilerDirectives.injectBranchProbability((double)0.010000000000000009, (boolean)locals.canPopResult())) break block18;
                    if (!locals.canPop()) {
                        if (!this.isLoopbackInitialState()) break block18;
                        assert (this.isForward());
                        locals.setIndex(locals.getLastInitialStateIndex());
                        if (CompilerDirectives.injectBranchProbability((double)0.010000000000000009, (!this.inputHasNext(locals) ? 1 : 0) != 0)) break block18;
                        this.inputSkip(locals, codeRange);
                        if (this.innerLiteral != null) {
                            if (locals.getLastInitialStateIndex() == locals.getLastInnerLiteralIndex()) {
                                int innerLiteralIndex = this.findInnerLiteral(locals);
                                if (CompilerDirectives.injectBranchProbability((double)0.010000000000000009, (innerLiteralIndex < 0 ? 1 : 0) != 0)) break block18;
                                if (this.innerLiteral.getMaxPrefixSize() < 0) {
                                    locals.setIndex(locals.getLastInnerLiteralIndex());
                                    locals.setLastInnerLiteralIndex(innerLiteralIndex);
                                } else {
                                    locals.setLastInnerLiteralIndex(innerLiteralIndex);
                                    locals.setIndex(innerLiteralIndex);
                                    this.rewindUpTo(locals, locals.getFromIndex(), this.innerLiteral.getMaxPrefixSize(), codeRange);
                                }
                            }
                        } else if (this.loopbackInitialStateMatcher != null) {
                            assert (this.isForward());
                            while (CompilerDirectives.injectBranchProbability((double)0.99, (boolean)this.inputHasNext(locals)) && !CompilerDirectives.injectBranchProbability((double)0.010000000000000009, (boolean)this.loopbackInitialStateMatcher.match(this.inputReadAndDecode(locals, codeRange)))) {
                                this.inputAdvance(locals);
                            }
                        }
                        locals.setLastInitialStateIndex(locals.getIndex());
                        locals.resetToInitialState();
                        ip = this.nfa.getUnAnchoredInitialState().getId();
                        continue;
                    }
                    int nextIp2 = locals.pop();
                    for (int i = 0; i < this.nfa.getNumberOfStates(); ++i) {
                        int stateId = this.nfa.getState(i).getId();
                        CompilerAsserts.partialEvaluationConstant((int)stateId);
                        if (stateId != nextIp2) continue;
                        ip = stateId;
                        continue block0;
                    }
                    break block18;
                }
                if (ip == -3) break block18;
                PureNFAState curState = this.nfa.getState(ip);
                CompilerAsserts.partialEvaluationConstant((Object)curState);
                PureNFATransition[] successors = (PureNFATransition[])curState.getSuccessors();
                CompilerAsserts.partialEvaluationConstant((Object)successors);
                CompilerAsserts.partialEvaluationConstant((int)successors.length);
                nextIp = this.runState(frame, locals, codeRange, curState);
                for (int i = 0; i < successors.length; ++i) {
                    int targetIp = successors[i].getTarget().getId();
                    if (targetIp != nextIp) continue;
                    CompilerAsserts.partialEvaluationConstant((int)targetIp);
                    ip = targetIp;
                    continue block0;
                }
                if (nextIp != -2) break;
                ip = -2;
            }
            assert (nextIp == -3);
        }
    }

    @ExplodeLoop
    private int runState(VirtualFrame frame, TRegexBacktrackingNFAExecutorLocals locals, TruffleString.CodeRange codeRange, PureNFAState curState) {
        long bs;
        int iBS;
        CompilerAsserts.partialEvaluationConstant((Object)curState);
        if (CompilerDirectives.injectBranchProbability((double)0.010000000000000009, (boolean)this.isAcceptableFinalState(curState, locals))) {
            locals.setResult();
            locals.pushResult();
            return -3;
        }
        if (curState.isSubMatcher() && !this.canInlineLookAroundIntoTransition(curState)) {
            TRegexBacktrackingNFAExecutorLocals subLocals = locals.createSubNFALocals(this.subExecutorReturnsFirstGroup(curState));
            int[] subMatchResult = this.runSubMatcher(frame, subLocals, codeRange, curState);
            if (CompilerDirectives.injectBranchProbability((double)0.010000000000000009, (boolean)TRegexBacktrackingNFAExecutorNode.subMatchFailed(curState, subMatchResult))) {
                return -2;
            }
            if (!curState.isSubMatcherNegated() && this.getSubExecutor(curState).writesCaptureGroups()) {
                locals.overwriteCaptureGroups(subMatchResult);
            }
            if (!curState.isLookAround()) {
                locals.saveIndex(subLocals.getIndex());
                locals.restoreIndex();
            }
        }
        if (curState.isBackReference() && !this.canInlineBackReferenceIntoTransition(curState)) {
            int backrefResult = this.matchBackReferenceGeneric(locals, curState, codeRange);
            if (CompilerDirectives.injectBranchProbability((double)0.010000000000000009, (backrefResult < 0 ? 1 : 0) != 0)) {
                return -2;
            }
            locals.setIndex(backrefResult);
        }
        PureNFATransition[] successors = (PureNFATransition[])curState.getSuccessors();
        CompilerAsserts.partialEvaluationConstant((Object)successors);
        CompilerAsserts.partialEvaluationConstant((int)successors.length);
        boolean atEnd = this.inputAtEnd(locals);
        int c = atEnd ? 0 : this.inputReadAndDecode(locals, codeRange);
        int index = locals.getIndex();
        if (curState.isDeterministic()) {
            if (this.isTransitionMatchesStepByStep()) {
                int[] currentFrame = locals.getStackFrameBuffer();
                locals.readFrame(currentFrame);
                for (int i = 0; i < successors.length; ++i) {
                    PureNFATransition transition = successors[i];
                    CompilerAsserts.partialEvaluationConstant((Object)transition);
                    if (this.tryUpdateState(frame, locals, codeRange, transition, index, atEnd, c)) {
                        locals.restoreIndex();
                        return transition.getTarget().getId();
                    }
                    locals.writeFrame(currentFrame);
                }
                return -2;
            }
            for (int i = 0; i < successors.length; ++i) {
                PureNFATransition transition = successors[i];
                CompilerAsserts.partialEvaluationConstant((Object)transition);
                if (!this.transitionMatches(frame, locals, codeRange, transition, index, atEnd, c)) continue;
                this.updateState(locals, transition, index);
                locals.restoreIndex();
                return transition.getTarget().getId();
            }
            return -2;
        }
        if (this.isTransitionMatchesStepByStep()) {
            boolean hasMatchingTransition = false;
            boolean transitionToFinalStateWins = false;
            int[] currentFrame = locals.getStackFrameBuffer();
            locals.readFrame(currentFrame);
            for (int i = successors.length - 1; i >= 0; --i) {
                PureNFATransition transition = successors[i];
                CompilerAsserts.partialEvaluationConstant((Object)transition);
                if (this.tryUpdateState(frame, locals, codeRange, transition, index, atEnd, c)) {
                    hasMatchingTransition = true;
                    PureNFAState target = transition.getTarget();
                    CompilerAsserts.partialEvaluationConstant((Object)target);
                    if (this.isAcceptableFinalState(target, locals)) {
                        locals.setResult();
                        locals.pushResult();
                        transitionToFinalStateWins = true;
                        locals.writeFrame(currentFrame);
                        continue;
                    }
                    locals.setPc(target.getId());
                    transitionToFinalStateWins = false;
                    locals.pushFrame(currentFrame);
                    continue;
                }
                locals.writeFrame(currentFrame);
            }
            if (transitionToFinalStateWins) {
                return -3;
            }
            if (hasMatchingTransition) {
                locals.pop();
                return locals.getPc();
            }
            return -2;
        }
        long[] transitionBitSet = locals.getTransitionBitSet();
        int bitSetWords = (successors.length - 1 >> 6) + 1;
        CompilerAsserts.partialEvaluationConstant((int)bitSetWords);
        int lastMatch = 0;
        int lastFinal = 0;
        int nMatched = -1;
        for (iBS = 0; iBS < bitSetWords; ++iBS) {
            CompilerAsserts.partialEvaluationConstant((int)iBS);
            bs = 0L;
            long bit = 1L;
            int iStart = successors.length - (iBS << 6) - 1;
            int iEnd = Math.max(-1, iStart - 64);
            CompilerAsserts.partialEvaluationConstant((int)iStart);
            CompilerAsserts.partialEvaluationConstant((int)iEnd);
            for (int i = iStart; i > iEnd; --i) {
                PureNFATransition transition = successors[i];
                CompilerAsserts.partialEvaluationConstant((Object)transition);
                if (this.transitionMatches(frame, locals, codeRange, transition, index, atEnd, c)) {
                    bs |= bit;
                    lastMatch = i;
                    if (this.isAcceptableFinalState(transition.getTarget(), locals)) {
                        locals.setResult();
                        lastFinal = i;
                        --nMatched;
                    }
                }
                bit <<= 1;
            }
            transitionBitSet[iBS] = bs;
        }
        for (iBS = 0; iBS < bitSetWords; ++iBS) {
            nMatched += Long.bitCount(transitionBitSet[iBS]);
        }
        if (CompilerDirectives.injectBranchProbability((double)0.75, (nMatched > 0 ? 1 : 0) != 0)) {
            locals.dupFrame(nMatched);
        }
        for (iBS = 0; iBS < bitSetWords; ++iBS) {
            CompilerAsserts.partialEvaluationConstant((int)iBS);
            bs = transitionBitSet[iBS];
            int iStart = successors.length - (iBS << 6) - 1;
            int iEnd = Math.max(-1, iStart - 64);
            CompilerAsserts.partialEvaluationConstant((int)iStart);
            CompilerAsserts.partialEvaluationConstant((int)iEnd);
            for (int i = iStart; i > iEnd; --i) {
                PureNFATransition transition = successors[i];
                CompilerAsserts.partialEvaluationConstant((Object)transition);
                PureNFAState target = transition.getTarget();
                CompilerAsserts.partialEvaluationConstant((Object)target);
                if ((bs & 1L) != 0L) {
                    if (this.isAcceptableFinalState(target, locals)) {
                        if (i == lastFinal) {
                            locals.pushResult(transition, index);
                        }
                        if (i == lastMatch) {
                            return -3;
                        }
                    } else {
                        this.updateState(locals, transition, index);
                        if (i == lastMatch) {
                            locals.restoreIndex();
                            return target.getId();
                        }
                        locals.setPc(target.getId());
                        locals.push();
                    }
                }
                bs >>>= 1;
            }
        }
        return -2;
    }

    private boolean isAcceptableFinalState(PureNFAState state, TRegexBacktrackingNFAExecutorLocals locals) {
        return state.isFinalState() && (!this.isMustAdvance() || locals.getIndex() != locals.getFromIndex());
    }

    public boolean returnsFirstGroup() {
        return this.isFlagSet(128);
    }

    private TRegexExecutorBaseNode getSubExecutor(PureNFAState subMatcherState) {
        return this.subExecutors[subMatcherState.getSubtreeId()];
    }

    protected boolean lookAroundExecutorIsLiteral(PureNFAState s) {
        return this.getSubExecutor(s).unwrap() instanceof TRegexLiteralLookAroundExecutorNode;
    }

    private boolean subExecutorReturnsFirstGroup(PureNFAState s) {
        TRegexExecutorNode executor = this.getSubExecutor(s).unwrap();
        if (executor instanceof TRegexBacktrackingNFAExecutorNode) {
            return ((TRegexBacktrackingNFAExecutorNode)executor).returnsFirstGroup();
        }
        return false;
    }

    private boolean canInlineLookAroundIntoTransition(PureNFAState s) {
        return s.isLookAround() && this.lookAroundExecutorIsLiteral(s) && (s.isSubMatcherNegated() || !this.getSubExecutor(s).writesCaptureGroups());
    }

    private boolean checkSubMatcherInline(VirtualFrame frame, TRegexBacktrackingNFAExecutorLocals locals, TruffleString.CodeRange codeRange, PureNFATransition transition, PureNFAState target) {
        if (this.lookAroundExecutorIsLiteral(target)) {
            int saveIndex = locals.getIndex();
            int saveNextIndex = locals.getNextIndex();
            boolean result = (Boolean)this.getSubExecutor(target).execute(frame, locals, codeRange);
            locals.setIndex(saveIndex);
            locals.setNextIndex(saveNextIndex);
            return result;
        }
        return !TRegexBacktrackingNFAExecutorNode.subMatchFailed(target, this.runSubMatcher(frame, locals.createSubNFALocals(transition, this.subExecutorReturnsFirstGroup(target)), codeRange, target));
    }

    protected int[] runSubMatcher(VirtualFrame frame, TRegexBacktrackingNFAExecutorLocals subLocals, TruffleString.CodeRange codeRange, PureNFAState subMatcherState) {
        return (int[])this.getSubExecutor(subMatcherState).execute(frame, subLocals, codeRange);
    }

    protected static boolean subMatchFailed(PureNFAState curState, Object subMatchResult) {
        return subMatchResult == null != curState.isSubMatcherNegated();
    }

    @ExplodeLoop
    protected boolean transitionMatches(VirtualFrame frame, TRegexBacktrackingNFAExecutorLocals locals, TruffleString.CodeRange codeRange, PureNFATransition transition, int index, boolean atEnd, int c) {
        PureNFAState target = transition.getTarget();
        CompilerAsserts.partialEvaluationConstant((Object)target);
        if (transition.hasCaretGuard() && index != locals.getRegionFrom()) {
            return false;
        }
        if (transition.hasDollarGuard() && index < locals.getRegionTo()) {
            return false;
        }
        long[] guards = transition.getGuards();
        CompilerAsserts.partialEvaluationConstant((Object)guards);
        block15: for (int i = 0; i < guards.length; ++i) {
            CompilerAsserts.partialEvaluationConstant((int)i);
            long guard = guards[i];
            CompilerAsserts.partialEvaluationConstant((long)guard);
            TransitionGuard.Kind kind = TransitionGuard.getKind(guard);
            CompilerAsserts.partialEvaluationConstant((Object)((Object)kind));
            switch (kind) {
                case loop: {
                    if (locals.getQuantifierCount(TransitionGuard.getQuantifierIndex(guard)) != this.getQuantifier(guard).getMax()) continue block15;
                    return false;
                }
                case exit: {
                    if (locals.getQuantifierCount(TransitionGuard.getQuantifierIndex(guard)) >= this.getQuantifier(guard).getMin()) continue block15;
                    return false;
                }
                case exitZeroWidth: {
                    Token.Quantifier q = this.getZeroWidthQuantifier(guard);
                    CompilerAsserts.partialEvaluationConstant((Object)q);
                    if (locals.getZeroWidthQuantifierGuardIndex(TransitionGuard.getZeroWidthQuantifierIndex(guard)) != index || this.isMonitorCaptureGroupsInEmptyCheck() && !locals.isResultUnmodifiedByZeroWidthQuantifier(TransitionGuard.getZeroWidthQuantifierIndex(guard)) || !this.isEmptyChecksOnMandatoryLoopIterations() && q.hasIndex() && locals.getQuantifierCount(q.getIndex()) <= q.getMin()) continue block15;
                    return false;
                }
                case escapeZeroWidth: {
                    if (locals.getZeroWidthQuantifierGuardIndex(TransitionGuard.getZeroWidthQuantifierIndex(guard)) == index && (!this.isMonitorCaptureGroupsInEmptyCheck() || locals.isResultUnmodifiedByZeroWidthQuantifier(TransitionGuard.getZeroWidthQuantifierIndex(guard)))) continue block15;
                    return false;
                }
                case checkGroupMatched: {
                    if (TRegexBacktrackingNFAExecutorNode.getBackRefBoundary(locals, transition, Group.groupNumberToBoundaryIndexStart(TransitionGuard.getGroupNumber(guard)), index) != -1 && TRegexBacktrackingNFAExecutorNode.getBackRefBoundary(locals, transition, Group.groupNumberToBoundaryIndexEnd(TransitionGuard.getGroupNumber(guard)), index) != -1) continue block15;
                    return false;
                }
                case checkGroupNotMatched: {
                    if (TRegexBacktrackingNFAExecutorNode.getBackRefBoundary(locals, transition, Group.groupNumberToBoundaryIndexStart(TransitionGuard.getGroupNumber(guard)), index) == -1 || TRegexBacktrackingNFAExecutorNode.getBackRefBoundary(locals, transition, Group.groupNumberToBoundaryIndexEnd(TransitionGuard.getGroupNumber(guard)), index) == -1) continue block15;
                    return false;
                }
            }
        }
        switch (target.getKind()) {
            case 0: {
                assert (!target.isInitialState());
                return target.isAnchoredFinalState() ? atEnd : true;
            }
            case 1: {
                return !atEnd && this.matchers[target.getId()].match(c);
            }
            case 2: {
                if (this.canInlineLookAroundIntoTransition(target)) {
                    return this.checkSubMatcherInline(frame, locals, codeRange, transition, target);
                }
                return true;
            }
            case 3: {
                if (this.canInlineBackReferenceIntoTransition(target)) {
                    return this.matchBackReferenceSimple(locals, target, transition, index);
                }
                return true;
            }
            case 4: {
                return true;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    protected static int getBackRefBoundary(TRegexBacktrackingNFAExecutorLocals locals, PureNFATransition transition, int cgIndex, int index) {
        return transition.getGroupBoundaries().getUpdateIndices().get(cgIndex) ? index : (transition.getGroupBoundaries().getClearIndices().get(cgIndex) ? -1 : locals.getCaptureGroupBoundary(cgIndex));
    }

    @ExplodeLoop
    protected void updateState(TRegexBacktrackingNFAExecutorLocals locals, PureNFATransition transition, int index) {
        CompilerAsserts.partialEvaluationConstant((Object)transition);
        assert (!this.isRecursiveBackreferences());
        locals.apply(transition, index);
        block6: for (long guard : transition.getGuards()) {
            CompilerAsserts.partialEvaluationConstant((long)guard);
            switch (TransitionGuard.getKind(guard)) {
                case loop: 
                case loopInc: {
                    locals.incQuantifierCount(TransitionGuard.getQuantifierIndex(guard));
                    continue block6;
                }
                case exit: 
                case exitReset: {
                    locals.resetQuantifierCount(TransitionGuard.getQuantifierIndex(guard));
                    continue block6;
                }
                case enterZeroWidth: {
                    locals.setZeroWidthQuantifierGuardIndex(TransitionGuard.getZeroWidthQuantifierIndex(guard));
                    locals.setZeroWidthQuantifierResults(TransitionGuard.getZeroWidthQuantifierIndex(guard));
                    continue block6;
                }
                case exitZeroWidth: {
                    boolean advancePastOptionalIterations;
                    Token.Quantifier q = this.getZeroWidthQuantifier(guard);
                    CompilerAsserts.partialEvaluationConstant((Object)q);
                    boolean emptyCheckFailed = locals.getZeroWidthQuantifierGuardIndex(TransitionGuard.getZeroWidthQuantifierIndex(guard)) == index && (!this.isMonitorCaptureGroupsInEmptyCheck() || locals.isResultUnmodifiedByZeroWidthQuantifier(TransitionGuard.getZeroWidthQuantifierIndex(guard)));
                    boolean bl = advancePastOptionalIterations = !this.isEmptyChecksOnMandatoryLoopIterations() && q.hasIndex() && locals.getQuantifierCount(q.getIndex()) < q.getMin();
                    if (!emptyCheckFailed || !advancePastOptionalIterations || transition.hasCaretGuard() || transition.hasDollarGuard()) continue block6;
                    locals.setQuantifierCount(q.getIndex(), q.getMin() - 1);
                    continue block6;
                }
            }
        }
        locals.saveIndex(this.getNewIndex(locals, transition.getTarget(), index));
    }

    @ExplodeLoop
    protected boolean tryUpdateState(VirtualFrame frame, TRegexBacktrackingNFAExecutorLocals locals, TruffleString.CodeRange codeRange, PureNFATransition transition, int index, boolean atEnd, int c) {
        CompilerAsserts.partialEvaluationConstant((Object)transition);
        PureNFAState target = transition.getTarget();
        CompilerAsserts.partialEvaluationConstant((Object)target);
        if (transition.hasCaretGuard() && index != locals.getRegionFrom()) {
            return false;
        }
        if (transition.hasDollarGuard() && index < locals.getRegionTo()) {
            return false;
        }
        switch (target.getKind()) {
            case 0: {
                assert (!target.isInitialState());
                if (!target.isAnchoredFinalState() || atEnd) break;
                return false;
            }
            case 1: {
                if (!atEnd && this.matchers[target.getId()].match(c)) break;
                return false;
            }
            case 2: {
                if (!this.canInlineLookAroundIntoTransition(target) || this.checkSubMatcherInline(frame, locals, codeRange, transition, target)) break;
                return false;
            }
            case 3: {
                if (!this.canInlineBackReferenceIntoTransition(target) || this.matchBackReferenceSimple(locals, target, transition, index)) break;
                return false;
            }
            case 4: {
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
        block20: for (long guard : transition.getGuards()) {
            switch (TransitionGuard.getKind(guard)) {
                case loopInc: {
                    locals.incQuantifierCount(TransitionGuard.getQuantifierIndex(guard));
                    continue block20;
                }
                case loop: {
                    if (locals.getQuantifierCount(TransitionGuard.getQuantifierIndex(guard)) == this.getQuantifier(guard).getMax()) {
                        return false;
                    }
                    locals.incQuantifierCount(TransitionGuard.getQuantifierIndex(guard));
                    continue block20;
                }
                case exit: {
                    if (locals.getQuantifierCount(TransitionGuard.getQuantifierIndex(guard)) < this.getQuantifier(guard).getMin()) {
                        return false;
                    }
                    locals.resetQuantifierCount(TransitionGuard.getQuantifierIndex(guard));
                    continue block20;
                }
                case exitReset: {
                    locals.resetQuantifierCount(TransitionGuard.getQuantifierIndex(guard));
                    continue block20;
                }
                case updateCG: {
                    locals.setCaptureGroupBoundary(TransitionGuard.getGroupBoundaryIndex(guard), index);
                    if (!this.isTrackLastGroup() || TransitionGuard.getGroupBoundaryIndex(guard) % 2 == 0 || TransitionGuard.getGroupBoundaryIndex(guard) <= 1) continue block20;
                    locals.setLastGroup(TransitionGuard.getGroupBoundaryIndex(guard) / 2);
                    continue block20;
                }
                case updateRecursiveBackrefPointer: {
                    locals.saveRecursiveBackrefGroupStart(TransitionGuard.getGroupNumber(guard));
                    continue block20;
                }
                case enterZeroWidth: {
                    locals.setZeroWidthQuantifierGuardIndex(TransitionGuard.getZeroWidthQuantifierIndex(guard));
                    locals.setZeroWidthQuantifierResults(TransitionGuard.getZeroWidthQuantifierIndex(guard));
                    continue block20;
                }
                case exitZeroWidth: {
                    if (locals.getZeroWidthQuantifierGuardIndex(TransitionGuard.getZeroWidthQuantifierIndex(guard)) != index || this.isMonitorCaptureGroupsInEmptyCheck() && !locals.isResultUnmodifiedByZeroWidthQuantifier(TransitionGuard.getZeroWidthQuantifierIndex(guard))) continue block20;
                    return false;
                }
                case escapeZeroWidth: {
                    if (locals.getZeroWidthQuantifierGuardIndex(TransitionGuard.getZeroWidthQuantifierIndex(guard)) == index && (!this.isMonitorCaptureGroupsInEmptyCheck() || locals.isResultUnmodifiedByZeroWidthQuantifier(TransitionGuard.getZeroWidthQuantifierIndex(guard)))) continue block20;
                    return false;
                }
                case checkGroupMatched: {
                    if (locals.getCaptureGroupStart(TransitionGuard.getGroupNumber(guard)) != -1 && locals.getCaptureGroupEnd(TransitionGuard.getGroupNumber(guard)) != -1) continue block20;
                    return false;
                }
                case checkGroupNotMatched: {
                    if (locals.getCaptureGroupStart(TransitionGuard.getGroupNumber(guard)) == -1 || locals.getCaptureGroupEnd(TransitionGuard.getGroupNumber(guard)) == -1) continue block20;
                    return false;
                }
            }
        }
        locals.saveIndex(this.getNewIndex(locals, target, index));
        return true;
    }

    private Pair<Integer, Integer> getBackRefBounds(TRegexBacktrackingNFAExecutorLocals locals, PureNFAState backReference) {
        for (int backRefNumber : backReference.getBackRefNumbers()) {
            int start = this.isRecursiveBackreferences() && backReference.isRecursiveReference() ? locals.getRecursiveCaptureGroupStart(backRefNumber) : locals.getCaptureGroupStart(backRefNumber);
            int end = locals.getCaptureGroupEnd(backRefNumber);
            if (start < 0 || end < 0) continue;
            return Pair.create((Object)start, (Object)end);
        }
        return Pair.create((Object)-1, (Object)-1);
    }

    private Pair<Integer, Integer> getBackRefBounds(TRegexBacktrackingNFAExecutorLocals locals, PureNFAState backReference, PureNFATransition transition, int index) {
        for (int backRefNumber : backReference.getBackRefNumbers()) {
            int start = this.isRecursiveBackreferences() && backReference.isRecursiveReference() ? locals.getRecursiveCaptureGroupStart(backRefNumber) : TRegexBacktrackingNFAExecutorNode.getBackRefBoundary(locals, transition, Group.groupNumberToBoundaryIndexStart(backRefNumber), index);
            int end = TRegexBacktrackingNFAExecutorNode.getBackRefBoundary(locals, transition, Group.groupNumberToBoundaryIndexEnd(backRefNumber), index);
            if (start < 0 || end < 0) continue;
            return Pair.create((Object)start, (Object)end);
        }
        return Pair.create((Object)-1, (Object)-1);
    }

    private int getNewIndex(TRegexBacktrackingNFAExecutorLocals locals, PureNFAState target, int index) {
        CompilerAsserts.partialEvaluationConstant((int)target.getKind());
        switch (target.getKind()) {
            case 0: 
            case 2: 
            case 4: {
                return index;
            }
            case 1: {
                return locals.getNextIndex();
            }
            case 3: {
                if (this.canInlineBackReferenceIntoTransition(target)) {
                    Pair<Integer, Integer> backRefBounds = this.getBackRefBounds(locals, target);
                    int start = (Integer)backRefBounds.getLeft();
                    int end = (Integer)backRefBounds.getRight();
                    if (start < 0 || end < 0) {
                        return index;
                    }
                    int length = end - start;
                    return this.isForward() ? index + length : index - length;
                }
                return index;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private boolean canInlineBackReferenceIntoTransition(PureNFAState backRef) {
        assert (backRef.isBackReference());
        return !backRef.isIgnoreCaseReference() && !this.isLoneSurrogates() && !this.isRecursiveBackreferences();
    }

    private boolean matchBackReferenceSimple(TRegexBacktrackingNFAExecutorLocals locals, PureNFAState backReference, PureNFATransition transition, int index) {
        assert (backReference.isBackReference());
        assert (this.canInlineBackReferenceIntoTransition(backReference));
        Pair<Integer, Integer> backRefBounds = this.getBackRefBounds(locals, backReference, transition, index);
        int backrefStart = (Integer)backRefBounds.getLeft();
        int backrefEnd = (Integer)backRefBounds.getRight();
        if (backrefStart < 0 || backrefEnd < 0) {
            return !this.isBackrefWithNullTargetFails();
        }
        int backrefLength = backrefEnd - backrefStart;
        if (backrefLength == 0) {
            return true;
        }
        if (this.isForward() ? index + backrefLength > locals.getRegionTo() : index - backrefLength < locals.getRegionFrom()) {
            return false;
        }
        int stride = this.getEncoding().getStride();
        return this.getRegionMatchesNode().execute((AbstractTruffleString)locals.getInput(), backrefStart << stride, (AbstractTruffleString)locals.getInput(), (this.isForward() ? index : index - backrefLength) << stride, backrefLength << stride, this.getEncoding().getTStringEncoding());
    }

    private int matchBackReferenceGeneric(TRegexBacktrackingNFAExecutorLocals locals, PureNFAState backReference, TruffleString.CodeRange codeRange) {
        assert (backReference.isBackReference());
        assert (!this.canInlineBackReferenceIntoTransition(backReference));
        Pair<Integer, Integer> backRefBounds = this.getBackRefBounds(locals, backReference);
        int backrefStart = (Integer)backRefBounds.getLeft();
        int backrefEnd = (Integer)backRefBounds.getRight();
        if (backrefStart < 0 || backrefEnd < 0) {
            return this.isBackrefWithNullTargetFails() ? -1 : locals.getIndex();
        }
        if (this.isBackreferenceIgnoreCaseMultiCharExpansion() && backReference.isIgnoreCaseReference()) {
            return this.matchBackreferenceGenericMultiCharExpansion(locals, codeRange, backrefStart, backrefEnd);
        }
        return this.matchBackreferenceGenericSingleChars(locals, backReference, codeRange, backrefStart, backrefEnd);
    }

    private int matchBackreferenceGenericSingleChars(TRegexBacktrackingNFAExecutorLocals locals, PureNFAState backReference, TruffleString.CodeRange codeRange, int backrefStart, int backrefEnd) {
        int saveNextIndex = locals.getNextIndex();
        int iBR = this.isForward() ? backrefStart : backrefEnd;
        int i = locals.getIndex();
        while (CompilerDirectives.injectBranchProbability((double)0.99, (boolean)this.inputBoundsCheck(iBR, backrefStart, backrefEnd))) {
            if (CompilerDirectives.injectBranchProbability((double)0.010000000000000009, (!this.inputBoundsCheck(i, locals.getRegionFrom(), locals.getRegionTo()) ? 1 : 0) != 0)) {
                locals.setNextIndex(saveNextIndex);
                return -1;
            }
            int codePointBR = this.inputReadAndDecode(locals, iBR, codeRange);
            iBR = locals.getNextIndex();
            int codePointI = this.inputReadAndDecode(locals, i, codeRange);
            i = locals.getNextIndex();
            if (!CompilerDirectives.injectBranchProbability((double)0.010000000000000009, (!(!backReference.isIgnoreCaseReference() ? codePointBR == codePointI : this.equalsIgnoreCase(codePointBR, codePointI, backReference.isIgnoreCaseReferenceAlternativeMode())) ? 1 : 0) != 0)) continue;
            locals.setNextIndex(saveNextIndex);
            return -1;
        }
        locals.setNextIndex(saveNextIndex);
        return i;
    }

    @CompilerDirectives.TruffleBoundary
    private int matchBackreferenceGenericMultiCharExpansion(TRegexBacktrackingNFAExecutorLocals locals, TruffleString.CodeRange codeRange, int backrefStart, int backrefEnd) {
        int i;
        int saveNextIndex;
        IntRingBuffer bufB;
        IntRingBuffer bufA;
        block5: {
            bufA = locals.getBackrefMultiCharExpansionBufferA();
            bufB = locals.getBackrefMultiCharExpansionBufferB();
            bufA.clear();
            bufB.clear();
            saveNextIndex = locals.getNextIndex();
            int iBR = this.isForward() ? backrefStart : backrefEnd;
            i = locals.getIndex();
            block0: while (true) {
                if (bufA.isEmpty()) {
                    if (!this.inputBoundsCheck(iBR, backrefStart, backrefEnd)) break block5;
                    int codePointBR = this.inputReadAndDecode(locals, iBR, codeRange);
                    iBR = locals.getNextIndex();
                    this.matchBackreferenceGenericMultiCharExpansionAddFolded(bufA, codePointBR);
                }
                if (bufB.isEmpty()) {
                    if (!this.inputBoundsCheck(i, locals.getRegionFrom(), locals.getRegionTo())) break block5;
                    int codePointI = this.inputReadAndDecode(locals, i, codeRange);
                    i = locals.getNextIndex();
                    this.matchBackreferenceGenericMultiCharExpansionAddFolded(bufB, codePointI);
                }
                do {
                    if (bufA.isEmpty() || bufB.isEmpty()) continue block0;
                } while (bufA.removeFirst() == bufB.removeFirst());
                break;
            }
            locals.setNextIndex(saveNextIndex);
            return -1;
        }
        locals.setNextIndex(saveNextIndex);
        if (bufA.isEmpty() && bufB.isEmpty()) {
            return i;
        }
        return -1;
    }

    private void matchBackreferenceGenericMultiCharExpansionAddFolded(IntRingBuffer buf, int codePoint) {
        int[] folded = MultiCharacterCaseFolding.caseFold(this.multiCharacterExpansionCaseFoldAlgorithm, codePoint);
        if (folded == null) {
            buf.add(codePoint);
        } else {
            buf.addAll(folded);
        }
    }

    private TruffleString.RegionEqualByteIndexNode getRegionMatchesNode() {
        if (this.regionMatchesNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.regionMatchesNode = (TruffleString.RegionEqualByteIndexNode)this.insert((Node)TruffleString.RegionEqualByteIndexNode.create());
        }
        return this.regionMatchesNode;
    }

    private TruffleString.ByteIndexOfStringNode getIndexOfNode() {
        if (this.indexOfNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.indexOfNode = (TruffleString.ByteIndexOfStringNode)this.insert((Node)TruffleString.ByteIndexOfStringNode.create());
        }
        return this.indexOfNode;
    }

    private int findInnerLiteral(TRegexBacktrackingNFAExecutorLocals locals) {
        return InputOps.indexOf(locals.getInput(), locals.getIndex(), locals.getMaxIndex(), this.innerLiteral, this.getEncoding(), this.getIndexOfNode());
    }

    private boolean inputBoundsCheck(int i, int min, int max) {
        return this.isForward() ? i < max : i > min;
    }

    @CompilerDirectives.TruffleBoundary
    private boolean equalsIgnoreCase(int a, int b, boolean alternativeMode) {
        return this.equalsIgnoreCase.test(a, b, alternativeMode);
    }

    private static int setFlag(int flags, int flag, boolean value) {
        if (value) {
            return flags | flag;
        }
        return flags & ~flag;
    }

    private static boolean isFlagSet(int flags, int flag) {
        return (flags & flag) != 0;
    }
}

