/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.flavors.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.AbstractRegexObject;
import com.oracle.truffle.regex.RegexFlags;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.Constants;
import com.oracle.truffle.regex.errors.JavaErrorMessages;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.RegexASTBuilder;
import com.oracle.truffle.regex.tregex.parser.RegexParser;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTRootNode;
import com.oracle.truffle.regex.tregex.parser.flavors.MatchingMode;
import com.oracle.truffle.regex.tregex.parser.flavors.java.JavaFlags;
import com.oracle.truffle.regex.tregex.parser.flavors.java.JavaFlavor;
import com.oracle.truffle.regex.tregex.parser.flavors.java.JavaRegexLexer;
import com.oracle.truffle.regex.tregex.string.Encodings;

public final class JavaRegexParser
implements RegexParser {
    private final RegexSource source;
    private final RegexASTBuilder astBuilder;
    private final JavaRegexLexer lexer;

    private static RegexFlags makeTRegexFlags(boolean sticky) {
        return RegexFlags.builder().unicode(true).sticky(sticky).build();
    }

    @CompilerDirectives.TruffleBoundary
    public JavaRegexParser(RegexSource source, RegexASTBuilder astBuilder, CompilationBuffer compilationBuffer) throws RegexSyntaxException {
        this.source = source;
        this.astBuilder = astBuilder;
        this.lexer = new JavaRegexLexer(source, JavaFlags.parseFlags(source.getFlags()), compilationBuffer);
    }

    public static RegexParser createParser(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer) throws RegexSyntaxException {
        return new JavaRegexParser(source, new RegexASTBuilder(language, source, JavaRegexParser.makeTRegexFlags(source.getOptions().getMatchingMode() != MatchingMode.search), true, compilationBuffer), compilationBuffer);
    }

    @Override
    public RegexAST parse() {
        this.astBuilder.pushRootGroup();
        if (this.lexer.source.getOptions().getMatchingMode() == MatchingMode.fullmatch) {
            this.astBuilder.pushGroup();
        }
        Token token = null;
        while (this.lexer.hasNext()) {
            Token last = token;
            token = this.lexer.next();
            switch (token.kind) {
                case A: {
                    this.addCaret();
                    break;
                }
                case Z: {
                    this.pushGroup();
                    this.lineTerminators();
                    this.nextSequence();
                    this.popGroup();
                    this.addDollar();
                    break;
                }
                case z: {
                    this.addDollar();
                    break;
                }
                case caret: {
                    this.caret();
                    break;
                }
                case dollar: {
                    this.dollar();
                    break;
                }
                case wordBoundary: {
                    if (this.lexer.getLocalFlags().isUnicodeCharacterClass()) {
                        this.buildWordBoundaryAssertion(this.lexer.unicode.word);
                        break;
                    }
                    this.buildWordBoundaryAssertion(Constants.WORD_CHARS);
                    break;
                }
                case nonWordBoundary: {
                    if (this.lexer.getLocalFlags().isUnicodeCharacterClass()) {
                        this.buildWordNonBoundaryAssertion(this.lexer.unicode.word, this.lexer.unicode.nonWord);
                        break;
                    }
                    this.buildWordNonBoundaryAssertion(Constants.WORD_CHARS, Constants.NON_WORD_CHARS);
                    break;
                }
                case backReference: {
                    this.astBuilder.addBackReference((Token.BackReference)token, this.getFlags().isCaseInsensitive(), this.getFlags().isUnicodeCase() || this.getFlags().isUnicodeCharacterClass());
                    break;
                }
                case quantifier: {
                    Token.Quantifier quantifier = (Token.Quantifier)token;
                    if (last instanceof Token.Quantifier && quantifier.isSingleChar()) {
                        throw this.syntaxErrorHere(JavaErrorMessages.danglingMetaCharacter(quantifier));
                    }
                    if (this.astBuilder.getCurTerm() != null) {
                        if (quantifier.isPossessive()) {
                            throw new UnsupportedRegexException("possessive quantifiers are not supported");
                        }
                        this.addQuantifier((Token.Quantifier)token);
                        break;
                    }
                    if (!quantifier.isSingleChar()) break;
                    throw this.syntaxErrorHere(JavaErrorMessages.danglingMetaCharacter(quantifier));
                }
                case alternation: {
                    this.astBuilder.nextSequence();
                    break;
                }
                case inlineFlags: {
                    if (!((Token.InlineFlags)token).isGlobal()) {
                        this.astBuilder.pushGroup(token);
                        this.astBuilder.getCurGroup().setLocalFlags(true);
                        this.lexer.pushLocalFlags();
                    }
                    this.lexer.setCurrentFlags((JavaFlags)((Token.InlineFlags)token).getFlags());
                    break;
                }
                case captureGroupBegin: {
                    this.lexer.pushLocalFlags();
                    this.astBuilder.pushCaptureGroup(token);
                    break;
                }
                case nonCaptureGroupBegin: {
                    this.lexer.pushLocalFlags();
                    this.astBuilder.pushGroup(token);
                    break;
                }
                case lookAheadAssertionBegin: {
                    this.lexer.pushLocalFlags();
                    this.astBuilder.pushLookAheadAssertion(token, ((Token.LookAheadAssertionBegin)token).isNegated());
                    break;
                }
                case lookBehindAssertionBegin: {
                    this.lexer.pushLocalFlags();
                    this.astBuilder.pushLookBehindAssertion(token, ((Token.LookBehindAssertionBegin)token).isNegated());
                    break;
                }
                case groupEnd: {
                    if (this.astBuilder.getCurGroup().getParent() instanceof RegexASTRootNode) {
                        throw this.syntaxErrorHere("Unmatched ')'");
                    }
                    this.lexer.popLocalFlags();
                    this.astBuilder.popGroup(token);
                    break;
                }
                case charClass: {
                    this.astBuilder.addCharClass((Token.CharacterClass)token);
                    break;
                }
                case classSet: {
                    this.astBuilder.addClassSet((Token.ClassSet)token, this.getFlags().isCaseInsensitive() ? JavaFlavor.getCaseFoldingAlgorithm(this.getFlags().isUnicodeCase() || this.getFlags().isUnicodeCharacterClass()) : null);
                    break;
                }
                case literalString: {
                    this.literalString((Token.LiteralString)token);
                    break;
                }
                case linebreak: {
                    this.pushGroup();
                    this.addCharClass(CodePointSet.create(13));
                    this.addCharClass(CodePointSet.create(10));
                    this.nextSequence();
                    this.addCharClass(CodePointSet.createNoDedup(10, 13, 133, 133, 8232, 8233));
                    this.popGroup();
                }
            }
        }
        if (this.lexer.source.getOptions().getMatchingMode() == MatchingMode.fullmatch) {
            this.astBuilder.popGroup();
            this.astBuilder.addDollar();
        }
        if (!this.astBuilder.curGroupIsRoot()) {
            throw this.syntaxErrorHere("Unclosed group");
        }
        return this.astBuilder.popRootGroup();
    }

    @Override
    public JavaFlags getFlags() {
        return this.lexer.getLocalFlags();
    }

    @Override
    public AbstractRegexObject getNamedCaptureGroups() {
        return AbstractRegexObject.createNamedCaptureGroupMapInt(this.lexer.getNamedCaptureGroups());
    }

    private RegexSyntaxException syntaxErrorHere(String message) {
        return RegexSyntaxException.createPattern(this.source, message, this.lexer.getLastTokenPosition());
    }

    private void literalString(Token.LiteralString token) {
        int codePoint;
        for (int i = token.getStart(); i < token.getEnd(); i += codePoint > 65535 ? 2 : 1) {
            codePoint = this.source.getPattern().codePointAt(i);
            this.astBuilder.addCharClass(CodePointSet.create(codePoint), true);
        }
    }

    private void buildWordBoundaryAssertion(CodePointSet wordChars) {
        CodePointSet nsm = this.lexer.unicode.getProperty("Mn", false);
        CodePointSet notWordNorNsm = wordChars.union(nsm).createInverse(Encodings.UTF_16);
        this.pushGroup();
        this.pushLookBehindAssertion();
        this.pushGroup();
        this.addCaret();
        this.nextSequence();
        this.addCharClass(notWordNorNsm);
        this.popGroup();
        this.addCharClass(nsm);
        this.addQuantifier(Token.createQuantifier(0, -1, true, false, true));
        this.popGroup();
        this.pushLookAheadAssertion();
        this.addCharClass(wordChars);
        this.popGroup();
        this.nextSequence();
        this.pushLookBehindAssertion();
        this.addCharClass(wordChars);
        this.addCharClass(nsm);
        this.addQuantifier(Token.createQuantifier(0, -1, true, false, true));
        this.popGroup();
        this.pushGroup();
        this.pushLookAheadAssertion();
        this.addCharClass(notWordNorNsm);
        this.popGroup();
        this.nextSequence();
        this.addDollar();
        this.popGroup();
        this.popGroup();
    }

    private void buildWordNonBoundaryAssertion(CodePointSet wordChars, CodePointSet nonWordChars) {
        this.pushGroup();
        this.pushGroup();
        this.addCaret();
        this.nextSequence();
        this.pushLookBehindAssertion();
        this.addCharClass(nonWordChars);
        this.popGroup();
        this.popGroup();
        this.pushGroup();
        this.pushLookAheadAssertion();
        this.addCharClass(nonWordChars);
        this.popGroup();
        this.nextSequence();
        this.addDollar();
        this.popGroup();
        this.nextSequence();
        this.pushLookBehindAssertion();
        this.addCharClass(wordChars);
        this.popGroup();
        this.pushLookAheadAssertion();
        this.addCharClass(wordChars);
        this.popGroup();
        this.popGroup();
    }

    private void dollar() {
        if (this.lexer.getLocalFlags().isMultiline()) {
            this.pushGroup();
            this.addDollar();
            this.nextSequence();
            this.pushLookAheadAssertion();
            this.lineTerminators();
            this.popGroup();
            this.popGroup();
        } else {
            this.pushGroup();
            this.addDollar();
            this.nextSequence();
            this.pushLookAheadAssertion();
            this.pushGroup();
            this.lineTerminators();
            this.popGroup();
            this.addDollar();
            this.popGroup();
            this.popGroup();
        }
    }

    private void caret() {
        if (this.lexer.getLocalFlags().isMultiline()) {
            this.pushGroup();
            this.addCaret();
            this.nextSequence();
            if (this.getFlags().isUnixLines()) {
                this.pushLookBehindAssertion();
                this.addCharClass(CodePointSet.create(10));
                this.popGroup();
            } else {
                this.pushLookBehindAssertion();
                this.addCharClass(CodePointSet.create(13));
                this.addCharClass(CodePointSet.create(10));
                this.popGroup();
                this.nextSequence();
                this.pushLookBehindAssertion();
                this.addCharClass(CodePointSet.createNoDedup(10, 10, 133, 133, 8232, 8233));
                this.popGroup();
                this.nextSequence();
                this.pushLookBehindAssertion();
                this.addCharClass(CodePointSet.create(13));
                this.popGroup();
                this.pushLookAheadAssertion();
                this.addCharClass(CodePointSet.createInverse(CodePointSet.create(10), Encodings.UTF_8));
                this.popGroup();
            }
            this.popGroup();
            this.pushLookAheadAssertion();
            this.addCharClass(Constants.DOT_ALL);
            this.popGroup();
        } else {
            this.addCaret();
        }
    }

    private void lineTerminators() {
        if (this.getFlags().isUnixLines()) {
            this.addCharClass(CodePointSet.create(10));
        } else {
            this.addCharClass(CodePointSet.create(13));
            this.addCharClass(CodePointSet.create(10));
            this.nextSequence();
            this.addCharClass(CodePointSet.createNoDedup(10, 10, 13, 13, 133, 133, 8232, 8233));
        }
    }

    private void pushGroup() {
        this.astBuilder.pushGroup();
    }

    private void pushLookAheadAssertion() {
        this.astBuilder.pushLookAheadAssertion(false);
    }

    private void pushLookBehindAssertion() {
        this.astBuilder.pushLookBehindAssertion(false);
    }

    private void popGroup() {
        this.astBuilder.popGroup();
    }

    private void nextSequence() {
        this.astBuilder.nextSequence();
    }

    private void addCharClass(CodePointSet charSet) {
        this.astBuilder.addCharClass(charSet);
    }

    private void addCaret() {
        this.astBuilder.addCaret();
    }

    private void addDollar() {
        this.astBuilder.addDollar();
    }

    private void addQuantifier(Token.Quantifier quantifier) {
        this.astBuilder.addQuantifier(quantifier);
    }
}

