/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import com.carrotsearch.hppc.IntArrayList;
import io.crate.analyze.AnalyzedCheck;
import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.analyze.DDLStatement;
import io.crate.analyze.SymbolEvaluator;
import io.crate.analyze.TableElementsAnalyzer;
import io.crate.data.Row;
import io.crate.execution.ddl.tables.AddColumnRequest;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public record AnalyzedAlterTableAddColumn(DocTableInfo table, Map<ColumnIdent, TableElementsAnalyzer.RefBuilder> columns, Map<String, AnalyzedCheck> checks) implements DDLStatement
{
    @Override
    public <C, R> R accept(AnalyzedStatementVisitor<C, R> visitor, C context) {
        return visitor.visitAlterTableAddColumn(this, context);
    }

    @Override
    public void visitSymbols(Consumer<? super Symbol> consumer) {
    }

    public AddColumnRequest bind(NodeContext nodeCtx, CoordinatorTxnCtx txnCtx, Row params, SubQueryResults subQueryResults) {
        SubQueryAndParamBinder bindParameter = new SubQueryAndParamBinder(params, subQueryResults);
        Function<Symbol, Object> toValue = new SymbolEvaluator(txnCtx, nodeCtx, subQueryResults).bind(params);
        ArrayList<Reference> newColumns = new ArrayList<Reference>(this.columns.size());
        LinkedHashSet<Reference> primaryKeys = new LinkedHashSet<Reference>();
        for (TableElementsAnalyzer.RefBuilder refBuilder : this.columns.values()) {
            Reference reference = refBuilder.build(this.columns, this.table.ident(), bindParameter, toValue);
            if (refBuilder.isPrimaryKey()) {
                primaryKeys.add(reference);
                if (refBuilder.pkConstraintName() != null) {
                    throw new IllegalArgumentException("Cannot alter the name of PRIMARY KEY constraint");
                }
            }
            newColumns.add(reference);
        }
        LinkedHashMap<String, String> checkConstraints = new LinkedHashMap<String, String>();
        for (Map.Entry<String, AnalyzedCheck> entry : this.checks.entrySet()) {
            String constraintName = entry.getKey();
            AnalyzedCheck check = entry.getValue();
            checkConstraints.put(constraintName, check.expression());
        }
        IntArrayList intArrayList = new IntArrayList(primaryKeys.size());
        for (Reference pk : primaryKeys) {
            int idx = Reference.indexOf(newColumns, pk.column());
            intArrayList.add(idx);
        }
        return new AddColumnRequest(this.table.ident(), newColumns, checkConstraints, intArrayList);
    }
}

