/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AlterTableAddColumnAnalyzer;
import io.crate.analyze.AlterTableAnalyzer;
import io.crate.analyze.AlterTableDropColumnAnalyzer;
import io.crate.analyze.AlterTableRenameColumnAnalyzer;
import io.crate.analyze.AlterTableRerouteAnalyzer;
import io.crate.analyze.Analysis;
import io.crate.analyze.AnalyzedAlterServer;
import io.crate.analyze.AnalyzedAnalyze;
import io.crate.analyze.AnalyzedBegin;
import io.crate.analyze.AnalyzedClose;
import io.crate.analyze.AnalyzedCommit;
import io.crate.analyze.AnalyzedCreateServer;
import io.crate.analyze.AnalyzedCreateUserMapping;
import io.crate.analyze.AnalyzedDeclare;
import io.crate.analyze.AnalyzedDiscard;
import io.crate.analyze.AnalyzedDropForeignTable;
import io.crate.analyze.AnalyzedDropRole;
import io.crate.analyze.AnalyzedDropServer;
import io.crate.analyze.AnalyzedDropTable;
import io.crate.analyze.AnalyzedDropUserMapping;
import io.crate.analyze.AnalyzedFetch;
import io.crate.analyze.AnalyzedGCDanglingArtifacts;
import io.crate.analyze.AnalyzedRerouteRetryFailed;
import io.crate.analyze.AnalyzedSetSessionAuthorizationStatement;
import io.crate.analyze.AnalyzedSetTransaction;
import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.CopyAnalyzer;
import io.crate.analyze.CreateAnalyzerStatementAnalyzer;
import io.crate.analyze.CreateBlobTableAnalyzer;
import io.crate.analyze.CreateFunctionAnalyzer;
import io.crate.analyze.CreateRepositoryAnalyzer;
import io.crate.analyze.CreateSnapshotAnalyzer;
import io.crate.analyze.CreateTableAsAnalyzer;
import io.crate.analyze.CreateTableStatementAnalyzer;
import io.crate.analyze.DeallocateAnalyzer;
import io.crate.analyze.DecommissionNodeAnalyzer;
import io.crate.analyze.DeleteAnalyzer;
import io.crate.analyze.DropAnalyzerStatementAnalyzer;
import io.crate.analyze.DropCheckConstraintAnalyzer;
import io.crate.analyze.DropFunctionAnalyzer;
import io.crate.analyze.DropRepositoryAnalyzer;
import io.crate.analyze.DropSnapshotAnalyzer;
import io.crate.analyze.DropTableAnalyzer;
import io.crate.analyze.ExplainStatementAnalyzer;
import io.crate.analyze.InsertAnalyzer;
import io.crate.analyze.KillAnalyzer;
import io.crate.analyze.OptimizeTableAnalyzer;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.PrivilegesAnalyzer;
import io.crate.analyze.RefreshTableAnalyzer;
import io.crate.analyze.ResetStatementAnalyzer;
import io.crate.analyze.RestoreSnapshotAnalyzer;
import io.crate.analyze.RoleAnalyzer;
import io.crate.analyze.SetStatementAnalyzer;
import io.crate.analyze.ShowStatementAnalyzer;
import io.crate.analyze.SwapTableAnalyzer;
import io.crate.analyze.UpdateAnalyzer;
import io.crate.analyze.ViewAnalyzer;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.FieldProvider;
import io.crate.analyze.relations.RelationAnalyzer;
import io.crate.common.collections.Lists;
import io.crate.execution.ddl.RepositoryService;
import io.crate.expression.symbol.Symbol;
import io.crate.fdw.FdwAnalyzer;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.FulltextAnalyzerResolver;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.metadata.settings.session.SessionSettingRegistry;
import io.crate.replication.logical.LogicalReplicationService;
import io.crate.replication.logical.analyze.LogicalReplicationAnalyzer;
import io.crate.role.Role;
import io.crate.role.Roles;
import io.crate.session.Cursor;
import io.crate.session.Cursors;
import io.crate.sql.tree.AlterClusterRerouteRetryFailed;
import io.crate.sql.tree.AlterPublication;
import io.crate.sql.tree.AlterRoleReset;
import io.crate.sql.tree.AlterRoleSet;
import io.crate.sql.tree.AlterServer;
import io.crate.sql.tree.AlterSubscription;
import io.crate.sql.tree.AlterTable;
import io.crate.sql.tree.AlterTableAddColumn;
import io.crate.sql.tree.AlterTableDropColumn;
import io.crate.sql.tree.AlterTableOpenClose;
import io.crate.sql.tree.AlterTableRenameColumn;
import io.crate.sql.tree.AlterTableRenameTable;
import io.crate.sql.tree.AlterTableReroute;
import io.crate.sql.tree.AnalyzeStatement;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.BeginStatement;
import io.crate.sql.tree.Close;
import io.crate.sql.tree.CommitStatement;
import io.crate.sql.tree.CopyFrom;
import io.crate.sql.tree.CopyTo;
import io.crate.sql.tree.CreateAnalyzer;
import io.crate.sql.tree.CreateBlobTable;
import io.crate.sql.tree.CreateForeignTable;
import io.crate.sql.tree.CreateFunction;
import io.crate.sql.tree.CreatePublication;
import io.crate.sql.tree.CreateRepository;
import io.crate.sql.tree.CreateRole;
import io.crate.sql.tree.CreateServer;
import io.crate.sql.tree.CreateSnapshot;
import io.crate.sql.tree.CreateSubscription;
import io.crate.sql.tree.CreateTable;
import io.crate.sql.tree.CreateTableAs;
import io.crate.sql.tree.CreateUserMapping;
import io.crate.sql.tree.CreateView;
import io.crate.sql.tree.DeallocateStatement;
import io.crate.sql.tree.Declare;
import io.crate.sql.tree.DecommissionNodeStatement;
import io.crate.sql.tree.Delete;
import io.crate.sql.tree.DenyPrivilege;
import io.crate.sql.tree.DiscardStatement;
import io.crate.sql.tree.DropAnalyzer;
import io.crate.sql.tree.DropBlobTable;
import io.crate.sql.tree.DropCheckConstraint;
import io.crate.sql.tree.DropForeignTable;
import io.crate.sql.tree.DropFunction;
import io.crate.sql.tree.DropPublication;
import io.crate.sql.tree.DropRepository;
import io.crate.sql.tree.DropRole;
import io.crate.sql.tree.DropServer;
import io.crate.sql.tree.DropSnapshot;
import io.crate.sql.tree.DropSubscription;
import io.crate.sql.tree.DropTable;
import io.crate.sql.tree.DropUserMapping;
import io.crate.sql.tree.DropView;
import io.crate.sql.tree.Explain;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.Fetch;
import io.crate.sql.tree.GCDanglingArtifacts;
import io.crate.sql.tree.GrantPrivilege;
import io.crate.sql.tree.Insert;
import io.crate.sql.tree.KillStatement;
import io.crate.sql.tree.OptimizeStatement;
import io.crate.sql.tree.Query;
import io.crate.sql.tree.RefreshStatement;
import io.crate.sql.tree.ResetStatement;
import io.crate.sql.tree.RestoreSnapshot;
import io.crate.sql.tree.RevokePrivilege;
import io.crate.sql.tree.SetSessionAuthorizationStatement;
import io.crate.sql.tree.SetStatement;
import io.crate.sql.tree.SetTransactionStatement;
import io.crate.sql.tree.ShowColumns;
import io.crate.sql.tree.ShowCreateTable;
import io.crate.sql.tree.ShowSchemas;
import io.crate.sql.tree.ShowSessionParameter;
import io.crate.sql.tree.ShowTables;
import io.crate.sql.tree.ShowTransaction;
import io.crate.sql.tree.Statement;
import io.crate.sql.tree.SwapTable;
import io.crate.sql.tree.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.index.analysis.AnalysisRegistry;

@Singleton
public class Analyzer {
    private final AnalyzerDispatcher dispatcher = new AnalyzerDispatcher();
    private final RelationAnalyzer relationAnalyzer;
    private final DropTableAnalyzer dropTableAnalyzer;
    private final DropCheckConstraintAnalyzer dropCheckConstraintAnalyzer;
    private final CreateTableStatementAnalyzer createTableStatementAnalyzer;
    private final CreateTableAsAnalyzer createTableAsAnalyzer;
    private final ExplainStatementAnalyzer explainStatementAnalyzer;
    private final ShowStatementAnalyzer showStatementAnalyzer;
    private final CreateBlobTableAnalyzer createBlobTableAnalyzer;
    private final CreateAnalyzerStatementAnalyzer createAnalyzerStatementAnalyzer;
    private final DropAnalyzerStatementAnalyzer dropAnalyzerStatementAnalyzer;
    private final Roles roles;
    private final RefreshTableAnalyzer refreshTableAnalyzer;
    private final OptimizeTableAnalyzer optimizeTableAnalyzer;
    private final AlterTableAnalyzer alterTableAnalyzer;
    private final AlterTableAddColumnAnalyzer alterTableAddColumnAnalyzer;
    private final AlterTableDropColumnAnalyzer alterTableDropColumnAnalyzer;
    private final AlterTableRenameColumnAnalyzer alterTableRenameColumnAnalyzer;
    private final InsertAnalyzer insertAnalyzer;
    private final CopyAnalyzer copyAnalyzer;
    private final UpdateAnalyzer updateAnalyzer;
    private final DeleteAnalyzer deleteAnalyzer;
    private final DropRepositoryAnalyzer dropRepositoryAnalyzer;
    private final CreateRepositoryAnalyzer createRepositoryAnalyzer;
    private final DropSnapshotAnalyzer dropSnapshotAnalyzer;
    private final CreateSnapshotAnalyzer createSnapshotAnalyzer;
    private final RestoreSnapshotAnalyzer restoreSnapshotAnalyzer;
    private final CreateFunctionAnalyzer createFunctionAnalyzer;
    private final DropFunctionAnalyzer dropFunctionAnalyzer;
    private final PrivilegesAnalyzer privilegesAnalyzer;
    private final AlterTableRerouteAnalyzer alterTableRerouteAnalyzer;
    private final RoleAnalyzer roleAnalyzer;
    private final ViewAnalyzer viewAnalyzer;
    private final SwapTableAnalyzer swapTableAnalyzer;
    private final DecommissionNodeAnalyzer decommissionNodeAnalyzer;
    private final KillAnalyzer killAnalyzer;
    private final SetStatementAnalyzer setStatementAnalyzer;
    private final ResetStatementAnalyzer resetStatementAnalyzer;
    private final LogicalReplicationAnalyzer logicalReplicationAnalyzer;
    private final NodeContext nodeCtx;

    public Analyzer(NodeContext nodeCtx, RelationAnalyzer relationAnalyzer, ClusterService clusterService, AnalysisRegistry analysisRegistry, RepositoryService repositoryService, Roles roles, SessionSettingRegistry sessionSettingRegistry, LogicalReplicationService logicalReplicationService) {
        this.nodeCtx = nodeCtx;
        Schemas schemas = nodeCtx.schemas();
        this.relationAnalyzer = relationAnalyzer;
        this.dropTableAnalyzer = new DropTableAnalyzer(clusterService, schemas);
        this.dropCheckConstraintAnalyzer = new DropCheckConstraintAnalyzer(schemas);
        this.roles = roles;
        this.createTableStatementAnalyzer = new CreateTableStatementAnalyzer(nodeCtx);
        this.alterTableAnalyzer = new AlterTableAnalyzer(schemas, nodeCtx);
        this.alterTableAddColumnAnalyzer = new AlterTableAddColumnAnalyzer(schemas, nodeCtx);
        this.alterTableDropColumnAnalyzer = new AlterTableDropColumnAnalyzer(schemas, nodeCtx);
        this.alterTableRenameColumnAnalyzer = new AlterTableRenameColumnAnalyzer(schemas, nodeCtx);
        this.swapTableAnalyzer = new SwapTableAnalyzer(nodeCtx, schemas);
        this.viewAnalyzer = new ViewAnalyzer(relationAnalyzer, schemas);
        this.explainStatementAnalyzer = new ExplainStatementAnalyzer(this);
        this.showStatementAnalyzer = new ShowStatementAnalyzer(this, schemas, sessionSettingRegistry);
        this.updateAnalyzer = new UpdateAnalyzer(nodeCtx, relationAnalyzer);
        this.deleteAnalyzer = new DeleteAnalyzer(nodeCtx, relationAnalyzer);
        this.insertAnalyzer = new InsertAnalyzer(nodeCtx, schemas, relationAnalyzer);
        this.createTableAsAnalyzer = new CreateTableAsAnalyzer(this.createTableStatementAnalyzer, this.insertAnalyzer, relationAnalyzer);
        this.optimizeTableAnalyzer = new OptimizeTableAnalyzer(schemas, nodeCtx);
        this.createRepositoryAnalyzer = new CreateRepositoryAnalyzer(repositoryService, nodeCtx);
        this.dropRepositoryAnalyzer = new DropRepositoryAnalyzer(repositoryService);
        this.createSnapshotAnalyzer = new CreateSnapshotAnalyzer(repositoryService, nodeCtx);
        this.dropSnapshotAnalyzer = new DropSnapshotAnalyzer(repositoryService);
        this.roleAnalyzer = new RoleAnalyzer(nodeCtx);
        this.createBlobTableAnalyzer = new CreateBlobTableAnalyzer(schemas, nodeCtx);
        this.createFunctionAnalyzer = new CreateFunctionAnalyzer(nodeCtx);
        this.dropFunctionAnalyzer = new DropFunctionAnalyzer();
        this.refreshTableAnalyzer = new RefreshTableAnalyzer(nodeCtx, schemas);
        this.restoreSnapshotAnalyzer = new RestoreSnapshotAnalyzer(repositoryService, nodeCtx);
        FulltextAnalyzerResolver fulltextAnalyzerResolver = new FulltextAnalyzerResolver(clusterService, analysisRegistry);
        this.createAnalyzerStatementAnalyzer = new CreateAnalyzerStatementAnalyzer(fulltextAnalyzerResolver, nodeCtx);
        this.dropAnalyzerStatementAnalyzer = new DropAnalyzerStatementAnalyzer(fulltextAnalyzerResolver);
        this.decommissionNodeAnalyzer = new DecommissionNodeAnalyzer(nodeCtx);
        this.killAnalyzer = new KillAnalyzer(nodeCtx);
        this.alterTableRerouteAnalyzer = new AlterTableRerouteAnalyzer(nodeCtx, schemas);
        this.privilegesAnalyzer = new PrivilegesAnalyzer(schemas);
        this.copyAnalyzer = new CopyAnalyzer(schemas, nodeCtx);
        this.setStatementAnalyzer = new SetStatementAnalyzer(nodeCtx);
        this.resetStatementAnalyzer = new ResetStatementAnalyzer(nodeCtx);
        this.logicalReplicationAnalyzer = new LogicalReplicationAnalyzer(schemas, logicalReplicationService, nodeCtx);
    }

    public AnalyzedStatement analyze(Statement statement, CoordinatorSessionSettings sessionSettings, ParamTypeHints paramTypeHints, Cursors cursors) {
        AnalyzedStatement analyzedStatement = (AnalyzedStatement)statement.accept((AstVisitor)this.dispatcher, (Object)new Analysis(new CoordinatorTxnCtx(sessionSettings), paramTypeHints, cursors));
        this.roles.getAccessControl(sessionSettings.authenticatedUser(), sessionSettings.sessionUser()).ensureMayExecute(analyzedStatement);
        return analyzedStatement;
    }

    AnalyzedStatement analyzedStatement(Statement statement, Analysis analysis) {
        AnalyzedStatement analyzedStatement = (AnalyzedStatement)statement.accept((AstVisitor)this.dispatcher, (Object)analysis);
        assert (analyzedStatement != null) : "analyzed statement must not be null";
        return analyzedStatement;
    }

    private class AnalyzerDispatcher
    extends AstVisitor<AnalyzedStatement, Analysis> {
        private AnalyzerDispatcher() {
        }

        public AnalyzedStatement visitAlterClusterDecommissionNode(DecommissionNodeStatement<?> node, Analysis context) {
            return Analyzer.this.decommissionNodeAnalyzer.analyze(node, context.transactionContext(), context.paramTypeHints());
        }

        public AnalyzedStatement visitAlterClusterRerouteRetryFailed(AlterClusterRerouteRetryFailed node, Analysis context) {
            return new AnalyzedRerouteRetryFailed();
        }

        public AnalyzedStatement visitAlterTable(AlterTable<?> node, Analysis context) {
            return Analyzer.this.alterTableAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        public AnalyzedStatement visitDropCheckConstraint(DropCheckConstraint<?> node, Analysis context) {
            return Analyzer.this.dropCheckConstraintAnalyzer.analyze(node.table(), node.name(), context.transactionContext());
        }

        public AnalyzedStatement visitAlterTableAddColumnStatement(AlterTableAddColumn<?> node, Analysis context) {
            return Analyzer.this.alterTableAddColumnAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        public AnalyzedStatement visitAlterTableDropColumnStatement(AlterTableDropColumn<?> node, Analysis context) {
            return Analyzer.this.alterTableDropColumnAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        public AnalyzedStatement visitAlterTableRenameColumnStatement(AlterTableRenameColumn<?> node, Analysis context) {
            return Analyzer.this.alterTableRenameColumnAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        public AnalyzedStatement visitAlterTableOpenClose(AlterTableOpenClose<?> node, Analysis context) {
            return Analyzer.this.alterTableAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        public AnalyzedStatement visitAlterTableRenameTable(AlterTableRenameTable<?> node, Analysis context) {
            return Analyzer.this.alterTableAnalyzer.analyze(node, context.sessionSettings());
        }

        public AnalyzedStatement visitAlterTableReroute(AlterTableReroute<?> node, Analysis context) {
            return Analyzer.this.alterTableRerouteAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        public AnalyzedStatement visitAlterRoleSet(AlterRoleSet<?> node, Analysis context) {
            return Analyzer.this.roleAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        public AnalyzedStatement visitAlterRoleReset(AlterRoleReset node, Analysis context) {
            return Analyzer.this.roleAnalyzer.analyze(node);
        }

        public AnalyzedStatement visitAnalyze(AnalyzeStatement analyzeStatement, Analysis analysis) {
            return new AnalyzedAnalyze();
        }

        public AnalyzedStatement visitBegin(BeginStatement node, Analysis context) {
            return new AnalyzedBegin();
        }

        public AnalyzedStatement visitCommit(CommitStatement node, Analysis context) {
            return new AnalyzedCommit();
        }

        public AnalyzedStatement visitCopyFrom(CopyFrom<?> node, Analysis context) {
            return Analyzer.this.copyAnalyzer.analyzeCopyFrom(node, context.paramTypeHints(), context.transactionContext());
        }

        public AnalyzedStatement visitCopyTo(CopyTo<?> node, Analysis context) {
            return Analyzer.this.copyAnalyzer.analyzeCopyTo(node, context.paramTypeHints(), context.transactionContext());
        }

        public AnalyzedStatement visitCreateAnalyzer(CreateAnalyzer<?> node, Analysis context) {
            return Analyzer.this.createAnalyzerStatementAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        public AnalyzedStatement visitCreateBlobTable(CreateBlobTable<?> node, Analysis context) {
            return Analyzer.this.createBlobTableAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        public AnalyzedStatement visitCreateFunction(CreateFunction<?> node, Analysis context) {
            return Analyzer.this.createFunctionAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext(), context.sessionSettings().searchPath());
        }

        public AnalyzedStatement visitCreateRepository(CreateRepository<?> node, Analysis context) {
            return Analyzer.this.createRepositoryAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        public AnalyzedStatement visitCreateSnapshot(CreateSnapshot<?> node, Analysis context) {
            return Analyzer.this.createSnapshotAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        public AnalyzedStatement visitCreateTable(CreateTable<?> node, Analysis analysis) {
            return Analyzer.this.createTableStatementAnalyzer.analyze(node, analysis.paramTypeHints(), analysis.transactionContext());
        }

        public AnalyzedStatement visitCreateTableAs(CreateTableAs<?> node, Analysis analysis) {
            return Analyzer.this.createTableAsAnalyzer.analyze(node, analysis.paramTypeHints(), analysis.transactionContext());
        }

        public AnalyzedStatement visitCreateRole(CreateRole node, Analysis context) {
            return Analyzer.this.roleAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        public AnalyzedStatement visitCreateView(CreateView node, Analysis context) {
            return Analyzer.this.viewAnalyzer.analyze(node, context.transactionContext());
        }

        public AnalyzedStatement visitDeallocateStatement(DeallocateStatement node, Analysis context) {
            return DeallocateAnalyzer.analyze(node);
        }

        public AnalyzedStatement visitDiscard(DiscardStatement discardStatement, Analysis context) {
            return new AnalyzedDiscard(discardStatement.target());
        }

        public AnalyzedStatement visitDelete(Delete node, Analysis analysis) {
            return Analyzer.this.deleteAnalyzer.analyze(node, analysis.paramTypeHints(), analysis.transactionContext());
        }

        public AnalyzedStatement visitDenyPrivilege(DenyPrivilege node, Analysis context) {
            return Analyzer.this.privilegesAnalyzer.analyzeDeny(node, context.sessionSettings().sessionUser(), context.sessionSettings().searchPath());
        }

        public AnalyzedStatement visitDropAnalyzer(DropAnalyzer node, Analysis context) {
            return Analyzer.this.dropAnalyzerStatementAnalyzer.analyze(node.name());
        }

        public AnalyzedStatement visitDropBlobTable(DropBlobTable<?> node, Analysis context) {
            return Analyzer.this.dropTableAnalyzer.analyze(node, context.sessionSettings());
        }

        public AnalyzedStatement visitDropFunction(DropFunction node, Analysis context) {
            return Analyzer.this.dropFunctionAnalyzer.analyze(node, context.sessionSettings().searchPath());
        }

        public AnalyzedStatement visitDropRepository(DropRepository node, Analysis context) {
            return Analyzer.this.dropRepositoryAnalyzer.analyze(node);
        }

        public AnalyzedStatement visitDropSnapshot(DropSnapshot node, Analysis context) {
            return Analyzer.this.dropSnapshotAnalyzer.analyze(node);
        }

        public AnalyzedDropTable<?> visitDropTable(DropTable<?> node, Analysis context) {
            return Analyzer.this.dropTableAnalyzer.analyze(node, context.sessionSettings());
        }

        public AnalyzedStatement visitDropRole(DropRole node, Analysis context) {
            return new AnalyzedDropRole(node.name(), node.ifExists());
        }

        public AnalyzedStatement visitDropView(DropView node, Analysis context) {
            return Analyzer.this.viewAnalyzer.analyze(node, context.transactionContext());
        }

        protected AnalyzedStatement visitExplain(Explain node, Analysis context) {
            return Analyzer.this.explainStatementAnalyzer.analyze(node, context);
        }

        public AnalyzedStatement visitGCDanglingArtifacts(GCDanglingArtifacts gcDanglingArtifacts, Analysis context) {
            return AnalyzedGCDanglingArtifacts.INSTANCE;
        }

        public AnalyzedStatement visitGrantPrivilege(GrantPrivilege node, Analysis context) {
            return Analyzer.this.privilegesAnalyzer.analyzeGrant(node, context.sessionSettings().sessionUser(), context.sessionSettings().searchPath());
        }

        public AnalyzedStatement visitInsert(Insert<?> node, Analysis analysis) {
            return Analyzer.this.insertAnalyzer.analyze(node, analysis.paramTypeHints(), analysis.transactionContext());
        }

        public AnalyzedStatement visitKillStatement(KillStatement<?> node, Analysis context) {
            return Analyzer.this.killAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        public AnalyzedStatement visitOptimizeStatement(OptimizeStatement<?> node, Analysis context) {
            return Analyzer.this.optimizeTableAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        protected AnalyzedStatement visitQuery(Query node, Analysis context) {
            return Analyzer.this.relationAnalyzer.analyze(node, context.transactionContext(), context.paramTypeHints());
        }

        public AnalyzedStatement visitRefreshStatement(RefreshStatement<?> node, Analysis context) {
            return Analyzer.this.refreshTableAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        public AnalyzedStatement visitResetStatement(ResetStatement<?> node, Analysis context) {
            return Analyzer.this.resetStatementAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        public AnalyzedStatement visitRestoreSnapshot(RestoreSnapshot<?> node, Analysis context) {
            return Analyzer.this.restoreSnapshotAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        public AnalyzedStatement visitRevokePrivilege(RevokePrivilege node, Analysis context) {
            return Analyzer.this.privilegesAnalyzer.analyzeRevoke(node, context.sessionSettings().sessionUser(), context.sessionSettings().searchPath());
        }

        public AnalyzedStatement visitSetStatement(SetStatement<?> node, Analysis context) {
            return Analyzer.this.setStatementAnalyzer.analyze(node, context.paramTypeHints(), context.transactionContext());
        }

        public AnalyzedStatement visitSetSessionAuthorizationStatement(SetSessionAuthorizationStatement node, Analysis context) {
            return new AnalyzedSetSessionAuthorizationStatement(node.user(), node.scope());
        }

        public AnalyzedStatement visitSetTransaction(SetTransactionStatement setTransaction, Analysis analysis) {
            return new AnalyzedSetTransaction(setTransaction.transactionModes());
        }

        protected AnalyzedStatement visitShowColumns(ShowColumns node, Analysis context) {
            CoordinatorTxnCtx coordinatorTxnCtx = context.transactionContext();
            Query query = Analyzer.this.showStatementAnalyzer.rewriteShowColumns(node, coordinatorTxnCtx.sessionSettings().searchPath().currentSchema());
            return Analyzer.this.relationAnalyzer.analyze(query, coordinatorTxnCtx, context.paramTypeHints());
        }

        public AnalyzedStatement visitShowCreateTable(ShowCreateTable<?> node, Analysis context) {
            return Analyzer.this.showStatementAnalyzer.analyzeShowCreateTable(node.table(), context);
        }

        protected AnalyzedStatement visitShowSchemas(ShowSchemas node, Analysis context) {
            Query query = Analyzer.this.showStatementAnalyzer.rewriteShowSchemas(node);
            return Analyzer.this.relationAnalyzer.analyze(query, context.transactionContext(), context.paramTypeHints());
        }

        public AnalyzedStatement visitShowSessionParameter(ShowSessionParameter node, Analysis context) {
            Analyzer.this.showStatementAnalyzer.validateSessionSetting(node.parameter());
            Query query = Analyzer.this.showStatementAnalyzer.rewriteShowSessionParameter(node);
            return Analyzer.this.relationAnalyzer.analyze(query, context.transactionContext(), context.paramTypeHints());
        }

        protected AnalyzedStatement visitShowTables(ShowTables node, Analysis context) {
            Query query = Analyzer.this.showStatementAnalyzer.rewriteShowTables(node);
            return Analyzer.this.relationAnalyzer.analyze(query, context.transactionContext(), context.paramTypeHints());
        }

        public AnalyzedStatement visitShowTransaction(ShowTransaction showTransaction, Analysis context) {
            return Analyzer.this.showStatementAnalyzer.analyzeShowTransaction(context);
        }

        public AnalyzedStatement visitSwapTable(SwapTable<?> node, Analysis analysis) {
            return Analyzer.this.swapTableAnalyzer.analyze(node, analysis.transactionContext(), analysis.paramTypeHints());
        }

        public AnalyzedStatement visitUpdate(Update node, Analysis analysis) {
            return Analyzer.this.updateAnalyzer.analyze(node, analysis.paramTypeHints(), analysis.transactionContext());
        }

        public AnalyzedStatement visitCreatePublication(CreatePublication createPublication, Analysis context) {
            return Analyzer.this.logicalReplicationAnalyzer.analyze(createPublication, context.transactionContext());
        }

        public AnalyzedStatement visitDropPublication(DropPublication dropPublication, Analysis context) {
            return Analyzer.this.logicalReplicationAnalyzer.analyze(dropPublication, context.sessionSettings());
        }

        public AnalyzedStatement visitAlterPublication(AlterPublication alterPublication, Analysis context) {
            return Analyzer.this.logicalReplicationAnalyzer.analyze(alterPublication, context.sessionSettings());
        }

        public AnalyzedStatement visitCreateSubscription(CreateSubscription<?> createSubscription, Analysis context) {
            return Analyzer.this.logicalReplicationAnalyzer.analyze(createSubscription, context.paramTypeHints(), context.transactionContext());
        }

        public AnalyzedStatement visitDropSubscription(DropSubscription dropSubscription, Analysis context) {
            return Analyzer.this.logicalReplicationAnalyzer.analyze(dropSubscription, context.sessionSettings());
        }

        public AnalyzedStatement visitAlterSubscription(AlterSubscription alterSubscription, Analysis context) {
            return Analyzer.this.logicalReplicationAnalyzer.analyze(alterSubscription, context.sessionSettings());
        }

        public AnalyzedStatement visitDeclare(Declare declare, Analysis context) {
            if (declare.binary()) {
                throw new UnsupportedOperationException("BINARY mode in DECLARE is not supported");
            }
            AnalyzedStatement query = (AnalyzedStatement)declare.query().accept((AstVisitor)this, (Object)context);
            return new AnalyzedDeclare(declare, query);
        }

        public AnalyzedStatement visitClose(Close close, Analysis context) {
            return new AnalyzedClose(close);
        }

        public AnalyzedStatement visitFetch(Fetch fetch, Analysis context) {
            Cursor cursor = context.cursors().get(fetch.cursorName());
            return new AnalyzedFetch(fetch, cursor);
        }

        public AnalyzedStatement visitCreateServer(CreateServer createServer, Analysis context) {
            ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(context.transactionContext(), Analyzer.this.nodeCtx, context.paramTypeHints(), FieldProvider.UNSUPPORTED, null);
            ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext(context.sessionSettings());
            HashMap<String, Symbol> options = HashMap.newHashMap(createServer.options().size());
            for (Map.Entry entry : createServer.options().entrySet()) {
                String name = (String)entry.getKey();
                Expression value = (Expression)entry.getValue();
                options.put(name, expressionAnalyzer.convert(value, exprCtx));
            }
            return new AnalyzedCreateServer(createServer.name(), createServer.fdw(), createServer.ifNotExists(), options);
        }

        public AnalyzedStatement visitAlterServer(AlterServer<?> alterServer, Analysis context) {
            AlterServer<?> alterServerExpr = alterServer;
            ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(context.transactionContext(), Analyzer.this.nodeCtx, context.paramTypeHints(), FieldProvider.UNSUPPORTED, null);
            ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext(context.sessionSettings());
            ArrayList<AlterServer.Option<Symbol>> options = new ArrayList<AlterServer.Option<Symbol>>();
            for (AlterServer.Option option : alterServerExpr.options()) {
                Symbol symbol = option.value() == null ? null : expressionAnalyzer.convert((Expression)option.value(), exprCtx);
                options.add((AlterServer.Option<Symbol>)new AlterServer.Option(option.operation(), option.key(), (Object)symbol));
            }
            return new AnalyzedAlterServer(alterServerExpr.name(), options);
        }

        public AnalyzedStatement visitCreateForeignTable(CreateForeignTable createForeignTable, Analysis context) {
            return FdwAnalyzer.analyze(context, Analyzer.this.nodeCtx, createForeignTable);
        }

        public AnalyzedStatement visitCreateUserMapping(CreateUserMapping createUserMapping, Analysis context) {
            String userName = createUserMapping.userName() == null ? context.sessionSettings().userName() : createUserMapping.userName();
            Role user = Analyzer.this.roles.getUser(userName);
            ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(context.transactionContext(), Analyzer.this.nodeCtx, context.paramTypeHints(), FieldProvider.UNSUPPORTED, null);
            ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext(context.sessionSettings());
            HashMap<String, Symbol> options = HashMap.newHashMap(createUserMapping.options().size());
            for (Map.Entry entry : createUserMapping.options().entrySet()) {
                String name = (String)entry.getKey();
                Expression value = (Expression)entry.getValue();
                options.put(name, expressionAnalyzer.convert(value, exprCtx));
            }
            return new AnalyzedCreateUserMapping(createUserMapping.ifNotExists(), user, createUserMapping.server(), options);
        }

        public AnalyzedStatement visitDropServer(DropServer dropServer, Analysis context) {
            return new AnalyzedDropServer(dropServer.names(), dropServer.ifExists(), dropServer.cascadeMode());
        }

        public AnalyzedStatement visitDropForeignTable(DropForeignTable dropForeignTable, Analysis context) {
            String defaultSchema = context.sessionSettings().currentSchema();
            return new AnalyzedDropForeignTable(Lists.map((Collection)dropForeignTable.names(), x -> RelationName.of(x, defaultSchema)), dropForeignTable.ifExists(), dropForeignTable.cascadeMode());
        }

        public AnalyzedStatement visitDropUserMapping(DropUserMapping dropUserMapping, Analysis context) {
            String userName = dropUserMapping.userName();
            String resolvedUserName = userName == null ? context.sessionSettings().userName() : userName;
            Role user = Analyzer.this.roles.findUser(resolvedUserName);
            return new AnalyzedDropUserMapping(user, dropUserMapping.ifExists(), dropUserMapping.server());
        }
    }
}

