/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.common.collections.Maps;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.DocTableInfo;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;

public final class ConstraintsValidator {
    public static void validate(Object value, Reference targetColumn, Collection<ColumnIdent> notNullColumns) {
        assert (targetColumn != null) : "targetColumn is required to be able to validate it";
        if (value == null && !targetColumn.isNullable()) {
            throw new IllegalArgumentException("\"" + String.valueOf(targetColumn.column()) + "\" must not be null");
        }
        ConstraintsValidator.validateNotNullOnChildren(value, targetColumn, notNullColumns);
    }

    private static void validateNotNullOnChildren(Object value, Reference targetColumn, Collection<ColumnIdent> notNullColumns) {
        if (targetColumn.valueType().id() == 12) {
            Map valueMap = (Map)value;
            for (ColumnIdent columnIdent : notNullColumns) {
                if (!columnIdent.isChildOf(targetColumn.column())) continue;
                Map map = valueMap;
                for (String path : columnIdent.path()) {
                    Object nested = Maps.get((Map)map, (String)path);
                    if (nested == null) {
                        throw new IllegalArgumentException("\"" + String.valueOf(columnIdent) + "\" must not be null");
                    }
                    if (!(nested instanceof Map)) continue;
                    map = (Map)nested;
                }
            }
        }
    }

    public static void validateConstraintsForNotUsedColumns(Collection<ColumnIdent> notUsedNonGeneratedColumns, DocTableInfo tableInfo) {
        for (ColumnIdent column : notUsedNonGeneratedColumns) {
            if (tableInfo.getReference(column).isNullable()) continue;
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot insert null value for column '%s'", column));
        }
    }
}

