/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.CopyStatementSettings;
import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.VisibleForTesting;

public class CopyFromParserProperties
implements Writeable {
    public static final CopyFromParserProperties DEFAULT = CopyFromParserProperties.of(Settings.EMPTY);
    private final boolean emptyStringAsNull;
    private final char columnSeparator;
    private final boolean fileHeader;
    private final long skipNumLines;

    public static CopyFromParserProperties of(Settings settings) {
        return new CopyFromParserProperties(CopyStatementSettings.EMPTY_STRING_AS_NULL.get(settings), CopyStatementSettings.INPUT_HEADER_SETTINGS.get(settings), CopyStatementSettings.CSV_COLUMN_SEPARATOR.get(settings).charValue(), CopyStatementSettings.SKIP_NUM_LINES.get(settings));
    }

    @VisibleForTesting
    public CopyFromParserProperties(boolean emptyStringAsNull, boolean fileHeader, char columnSeparator, long skipNumLines) {
        this.emptyStringAsNull = emptyStringAsNull;
        this.fileHeader = fileHeader;
        this.columnSeparator = columnSeparator;
        this.skipNumLines = skipNumLines;
    }

    public CopyFromParserProperties(StreamInput in) throws IOException {
        this.emptyStringAsNull = in.readBoolean();
        this.fileHeader = in.getVersion().onOrAfter(Version.V_4_8_0) ? in.readBoolean() : true;
        this.columnSeparator = (char)in.readByte();
        this.skipNumLines = in.getVersion().onOrAfter(Version.V_5_2_0) ? in.readLong() : 0L;
    }

    public boolean emptyStringAsNull() {
        return this.emptyStringAsNull;
    }

    public boolean fileHeader() {
        return this.fileHeader;
    }

    public char columnSeparator() {
        return this.columnSeparator;
    }

    public long skipNumLines() {
        return this.skipNumLines;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.emptyStringAsNull);
        if (out.getVersion().onOrAfter(Version.V_4_8_0)) {
            out.writeBoolean(this.fileHeader);
        }
        out.writeByte((byte)this.columnSeparator);
        if (out.getVersion().onOrAfter(Version.V_5_2_0)) {
            out.writeLong(this.skipNumLines);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CopyFromParserProperties that = (CopyFromParserProperties)o;
        return this.emptyStringAsNull == that.emptyStringAsNull && this.fileHeader == that.fileHeader && this.columnSeparator == that.columnSeparator && this.skipNumLines == that.skipNumLines;
    }

    public int hashCode() {
        return Objects.hash(this.emptyStringAsNull, this.fileHeader, Character.valueOf(this.columnSeparator), this.skipNumLines);
    }

    public String toString() {
        return "CopyFromParserProperties{emptyStringAsNull=" + this.emptyStringAsNull + ", fileHeader=" + this.fileHeader + ", columnSeparator=" + this.columnSeparator + ", skipNumLines=" + this.skipNumLines + "}";
    }
}

