/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelationVisitor;
import io.crate.exceptions.AmbiguousColumnException;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.table.Operation;
import io.crate.profile.ProfilingContext;
import io.crate.sql.tree.Explain;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExplainAnalyzedStatement
implements AnalyzedRelation {
    final AnalyzedStatement statement;
    private final ProfilingContext context;
    private final List<Symbol> outputs;
    private final RelationName relationName = new RelationName(null, "explain");
    private final EnumSet<Explain.Option> options;
    private static final String PLAN_COLUMN_NAME = "QUERY PLAN";
    private static final String STEP_COLUMN_NAME = "STEP";

    ExplainAnalyzedStatement(AnalyzedStatement statement, @Nullable ProfilingContext context, EnumSet<Explain.Option> options) {
        this.statement = statement;
        this.context = context;
        this.outputs = new ArrayList<Symbol>();
        this.options = options;
        if (options.contains(Explain.Option.VERBOSE)) {
            ScopedSymbol stepField = new ScopedSymbol(this.relationName, ColumnIdent.of(STEP_COLUMN_NAME), DataTypes.STRING);
            this.outputs.add(stepField);
        }
        ScopedSymbol queryPlanField = new ScopedSymbol(this.relationName, ColumnIdent.of(PLAN_COLUMN_NAME), context == null ? DataTypes.STRING : DataTypes.UNTYPED_OBJECT);
        this.outputs.add(queryPlanField);
    }

    public boolean showCosts() {
        return this.options.contains(Explain.Option.COSTS);
    }

    public boolean verbose() {
        return this.options.contains(Explain.Option.VERBOSE);
    }

    @Override
    public <C, R> R accept(AnalyzedStatementVisitor<C, R> analyzedStatementVisitor, C context) {
        return analyzedStatementVisitor.visitExplainStatement(this, context);
    }

    public AnalyzedStatement statement() {
        return this.statement;
    }

    @Nullable
    public ProfilingContext context() {
        return this.context;
    }

    @Override
    public <C, R> R accept(AnalyzedRelationVisitor<C, R> visitor, C context) {
        return visitor.visitExplain(this, context);
    }

    @Override
    public Symbol getField(ColumnIdent column, Operation operation, boolean errorOnUnknownObjectKey) throws AmbiguousColumnException, ColumnUnknownException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot use getField on " + this.getClass().getSimpleName());
    }

    @Override
    public RelationName relationName() {
        return this.relationName;
    }

    @Override
    @NotNull
    public List<Symbol> outputs() {
        return this.outputs;
    }
}

