/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelationVisitor;
import io.crate.common.collections.Lists;
import io.crate.exceptions.AmbiguousColumnException;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.JoinType;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JoinRelation
implements AnalyzedRelation {
    private final AnalyzedRelation left;
    private final AnalyzedRelation right;
    private final List<Symbol> outputs;
    private final JoinType joinType;
    private final Symbol joinCondition;
    private static final String UNSUPPORTED_OPERATION = "Joins do not support this operation";

    public JoinRelation(AnalyzedRelation left, AnalyzedRelation right, JoinType joinType, @Nullable Symbol joinCondition) {
        this.outputs = Lists.concat(left.outputs(), right.outputs());
        this.left = left;
        this.right = right;
        this.joinType = joinType;
        this.joinCondition = joinCondition;
    }

    public AnalyzedRelation left() {
        return this.left;
    }

    public AnalyzedRelation right() {
        return this.right;
    }

    public JoinType joinType() {
        return this.joinType;
    }

    @Nullable
    public Symbol joinCondition() {
        return this.joinCondition;
    }

    @Override
    public <C, R> R accept(AnalyzedRelationVisitor<C, R> visitor, C context) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    @Override
    @Nullable
    public Symbol getField(ColumnIdent column, Operation operation, boolean errorOnUnknownObjectKey) throws AmbiguousColumnException, ColumnUnknownException, UnsupportedOperationException {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    @Override
    public void visitSymbols(Consumer<? super Symbol> consumer) {
        for (Symbol output : this.outputs) {
            consumer.accept(output);
        }
        this.left.visitSymbols(consumer);
        this.right.visitSymbols(consumer);
        consumer.accept(this.joinCondition);
    }

    @Override
    public RelationName relationName() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    @Override
    @NotNull
    public List<Symbol> outputs() {
        return this.outputs;
    }
}

