/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.expression.symbol.ParameterSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.sql.tree.ParameterExpression;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class ParamTypeHints
implements Function<ParameterExpression, Symbol> {
    public static final ParamTypeHints EMPTY = new ParamTypeHints(Collections.emptyList());
    private final List<DataType<?>> types;

    public ParamTypeHints(List<DataType<?>> types) {
        this.types = types;
    }

    public DataType<?> getType(int index) {
        if (index + 1 > this.types.size()) {
            return DataTypes.UNDEFINED;
        }
        return this.types.get(index);
    }

    @Override
    @Nullable
    public Symbol apply(@Nullable ParameterExpression input) {
        if (input == null) {
            return null;
        }
        return new ParameterSymbol(input.index(), this.getType(input.index()));
    }

    public String toString() {
        return "ParamTypeHints{" + String.valueOf(this.types) + "}";
    }
}

