/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.QueriedSelectRelation;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelationVisitor;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.analyze.relations.TableFunctionRelation;
import io.crate.analyze.relations.TableRelation;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.doc.DocTableInfo;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.SequencedSet;

public final class RelationNames {
    private static final TableIdentRelationVisitor RELATION_TABLE_IDENT_EXTRACTOR = new TableIdentRelationVisitor();

    public static SequencedSet<RelationName> getDeep(Iterable<? extends Symbol> symbols) {
        LinkedHashSet<RelationName> relationNames = new LinkedHashSet<RelationName>();
        for (Symbol symbol : symbols) {
            relationNames.addAll(RelationNames.get(symbol, true));
        }
        return relationNames;
    }

    public static SequencedSet<RelationName> getDeep(Symbol symbol) {
        return RelationNames.get(symbol, true);
    }

    public static SequencedSet<RelationName> getShallow(Symbol symbol) {
        return RelationNames.get(symbol, false);
    }

    private static SequencedSet<RelationName> get(Symbol symbol, boolean deep) {
        LinkedHashSet<RelationName> relationNames = new LinkedHashSet<RelationName>();
        symbol.any(node -> {
            Symbol symbol = node;
            Objects.requireNonNull(symbol);
            Symbol selector0$temp = symbol;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Reference.class, ScopedSymbol.class, SelectSymbol.class}, (Symbol)selector0$temp, index$1)) {
                case 0: {
                    Reference ref = (Reference)selector0$temp;
                    relationNames.add(ref.ident().tableIdent());
                    break;
                }
                case 1: {
                    ScopedSymbol scoped = (ScopedSymbol)selector0$temp;
                    relationNames.add(scoped.relation());
                    break;
                }
                case 2: {
                    SelectSymbol selectSymbol = (SelectSymbol)selector0$temp;
                    if (!deep) break;
                    selectSymbol.relation().accept(RELATION_TABLE_IDENT_EXTRACTOR, relationNames);
                    break;
                }
            }
            return false;
        });
        return relationNames;
    }

    private static class TableIdentRelationVisitor
    extends AnalyzedRelationVisitor<Collection<RelationName>, Void> {
        private TableIdentRelationVisitor() {
        }

        @Override
        protected Void visitAnalyzedRelation(AnalyzedRelation relation, Collection<RelationName> context) {
            throw new IllegalStateException(String.format(Locale.ENGLISH, "AnalyzedRelation '%s' not supported", relation.getClass()));
        }

        @Override
        public Void visitTableRelation(TableRelation tableRelation, Collection<RelationName> context) {
            context.add(tableRelation.tableInfo().ident());
            return null;
        }

        @Override
        public Void visitDocTableRelation(DocTableRelation relation, Collection<RelationName> context) {
            context.add(((DocTableInfo)relation.tableInfo()).ident());
            return null;
        }

        @Override
        public Void visitTableFunctionRelation(TableFunctionRelation tableFunctionRelation, Collection<RelationName> context) {
            return null;
        }

        @Override
        public Void visitQueriedSelectRelation(QueriedSelectRelation relation, Collection<RelationName> context) {
            for (AnalyzedRelation analyzedRelation : relation.from()) {
                analyzedRelation.accept(this, context);
            }
            return null;
        }
    }
}

