/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.operator.Operators;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.MatchPredicate;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.metadata.TransactionContext;
import io.crate.types.DataTypes;
import java.util.ArrayList;

public final class ScalarsAndRefsToTrue
extends SymbolVisitor<Context, Symbol> {
    private static final ScalarsAndRefsToTrue INSTANCE = new ScalarsAndRefsToTrue();

    private ScalarsAndRefsToTrue() {
    }

    public static Symbol rewrite(EvaluatingNormalizer normalizer, TransactionContext txnCtx, Symbol symbol) {
        return symbol.accept(INSTANCE, new Context(normalizer, txnCtx));
    }

    @Override
    public Symbol visitFunction(Function symbol, Context ctx) {
        String functionName = symbol.name();
        if (functionName.equals("op_isnull")) {
            ctx.isNullPredicate = true;
        }
        ArrayList<Symbol> newArgs = new ArrayList<Symbol>(symbol.arguments().size());
        boolean allLiterals = true;
        boolean hasNullArg = false;
        for (Symbol arg : symbol.arguments()) {
            Symbol processedArg = arg.accept(this, ctx);
            newArgs.add(processedArg);
            if (!processedArg.symbolType().isValueSymbol()) {
                allLiterals = false;
            }
            if (processedArg.valueType().id() != DataTypes.UNDEFINED.id()) continue;
            hasNullArg = true;
        }
        if (allLiterals && !Operators.LOGICAL_OPERATORS.contains(functionName) && !"op_isnull".equals(functionName)) {
            return hasNullArg ? Literal.NULL : Literal.BOOLEAN_TRUE;
        }
        if (functionName.equals("op_not")) {
            Symbol arg = (Symbol)newArgs.get(0);
            assert (arg instanceof Literal) : "argument of NOT should have been normalized to literal";
            return arg;
        }
        return ctx.normalizer.normalize(new Function(symbol.signature(), newArgs, symbol.valueType()), ctx.txnCtx);
    }

    @Override
    public Symbol visitMatchPredicate(MatchPredicate matchPredicate, Context ctx) {
        return Literal.BOOLEAN_TRUE;
    }

    @Override
    protected Symbol visitSymbol(Symbol symbol, Context ctx) {
        if (ctx.isNullPredicate || symbol.valueType().id() == DataTypes.UNDEFINED.id()) {
            return Literal.NULL;
        }
        return Literal.BOOLEAN_TRUE;
    }

    @Override
    public Symbol visitLiteral(Literal<?> symbol, Context ctx) {
        return symbol;
    }

    public static class Context {
        private final EvaluatingNormalizer normalizer;
        private final TransactionContext txnCtx;
        private boolean isNullPredicate;

        private Context(EvaluatingNormalizer normalizer, TransactionContext txnCtx) {
            this.normalizer = normalizer;
            this.txnCtx = txnCtx;
            this.isNullPredicate = false;
        }
    }
}

