/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.TableParameters;
import io.crate.metadata.settings.NumberOfReplicas;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.sql.tree.GenericProperties;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;

public final class TableProperties {
    private static final String INVALID_MESSAGE = "Invalid property \"%s\" passed to [ALTER | CREATE] TABLE statement";

    private TableProperties() {
    }

    public static void analyze(Settings.Builder settingsBuilder, TableParameters tableParameters, GenericProperties<Object> properties) {
        Map<String, Setting<?>> settingMap = tableParameters.supportedSettings();
        TableProperties.settingsFromProperties(settingsBuilder, properties, settingMap);
    }

    private static void settingsFromProperties(Settings.Builder builder, GenericProperties<Object> properties, Map<String, Setting<?>> supportedSettings) {
        for (Map.Entry entry : properties) {
            String settingName = (String)entry.getKey();
            Setting<?> setting = TableProperties.getSupportedSetting(supportedSettings, settingName);
            if (setting == null) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, INVALID_MESSAGE, entry.getKey()));
            }
            Object value = entry.getValue();
            if (value == null) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot set NULL to property %s.", entry.getKey()));
            }
            TableProperties.apply(builder, setting, entry.getValue());
        }
    }

    public static void analyzeResetProperties(Settings.Builder settingsBuilder, TableParameters tableParameters, List<String> properties) {
        Map<String, Setting<?>> supportedSettings = tableParameters.supportedSettings();
        for (String name : properties) {
            Setting<?> setting = TableProperties.getSupportedSetting(supportedSettings, name);
            if (setting == null) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, INVALID_MESSAGE, name));
            }
            TableProperties.reset(settingsBuilder, setting);
        }
    }

    static void apply(Settings.Builder builder, Setting<?> setting, Object value) {
        if (setting instanceof Setting.AffixSetting) {
            throw new IllegalArgumentException("Cannot change a dynamic group setting, only concrete settings allowed.");
        }
        Object resolvedValue = setting.get(Settings.builder().put(builder.build()).put(setting.getKey(), value).build());
        if (resolvedValue instanceof Settings) {
            Settings settings = (Settings)resolvedValue;
            builder.put(settings);
        } else {
            builder.putStringOrList(setting.getKey(), resolvedValue);
        }
    }

    static void reset(Settings.Builder builder, Setting<?> setting) {
        if (setting instanceof Setting.AffixSetting) {
            throw new IllegalArgumentException("Cannot change a dynamic group setting, only concrete settings allowed.");
        }
        builder.putNull(setting.getKey());
        if (setting instanceof NumberOfReplicas) {
            NumberOfReplicas numberOfReplicas = (NumberOfReplicas)setting;
            builder.put(numberOfReplicas.getDefault(Settings.EMPTY));
        } else if (setting.equals(TableParameters.COLUMN_POLICY)) {
            builder.put(setting.getKey(), (Enum<?>)ColumnPolicy.STRICT);
        }
    }

    @Nullable
    private static Setting<?> getSupportedSetting(Map<String, Setting<?>> supportedSettings, String settingName) {
        String groupKey;
        Setting<Object> setting = supportedSettings.get(settingName);
        if (setting == null && (groupKey = TableProperties.getPossibleGroup(settingName)) != null && (setting = supportedSettings.get(groupKey)) instanceof Setting.AffixSetting) {
            Setting.AffixSetting affixSetting = (Setting.AffixSetting)setting;
            setting = affixSetting.getConcreteSetting("index." + settingName);
            return setting;
        }
        return setting;
    }

    @Nullable
    private static String getPossibleGroup(String key) {
        int idx = key.lastIndexOf(46);
        if (idx > 0) {
            return key.substring(0, idx);
        }
        return null;
    }
}

