/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.relations.AbstractTableRelation;
import io.crate.analyze.relations.AnalyzedRelationVisitor;
import io.crate.common.collections.Lists;
import io.crate.exceptions.AmbiguousColumnException;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.exceptions.ColumnValidationException;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.doc.SysColumns;
import io.crate.metadata.table.Operation;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class DocTableRelation
extends AbstractTableRelation<DocTableInfo> {
    public DocTableRelation(DocTableInfo tableInfo) {
        super(tableInfo, List.copyOf(tableInfo.columns()), Lists.concat(SysColumns.forTable(tableInfo.ident()), tableInfo.indexColumns()));
    }

    @Override
    public <C, R> R accept(AnalyzedRelationVisitor<C, R> visitor, C context) {
        return visitor.visitDocTableRelation(this, context);
    }

    @Override
    @Nullable
    public Reference getField(ColumnIdent path) {
        return this.getField(path, Operation.READ, true);
    }

    @Override
    public Reference getField(ColumnIdent column, Operation operation, boolean errorOnUnknownObjectKey) throws AmbiguousColumnException, ColumnUnknownException, UnsupportedOperationException {
        Reference reference;
        if (operation == Operation.UPDATE) {
            this.ensureColumnCanBeUpdated(column);
        }
        if ((reference = ((DocTableInfo)this.tableInfo).getReadReference(column)) == null && (reference = ((DocTableInfo)this.tableInfo).indexColumn(column)) == null) {
            reference = ((DocTableInfo)this.tableInfo).getDynamic(column, operation == Operation.INSERT || operation == Operation.UPDATE, errorOnUnknownObjectKey);
        }
        return reference;
    }

    @VisibleForTesting
    void ensureColumnCanBeUpdated(ColumnIdent ci) {
        if (ci.isSystemColumn()) {
            throw new ColumnValidationException(ci.toString(), ((DocTableInfo)this.tableInfo).ident(), "Updating a system column is not supported");
        }
        for (ColumnIdent pkIdent : ((DocTableInfo)this.tableInfo).primaryKey()) {
            this.ensureNotUpdated(ci, pkIdent, "Updating a primary key is not supported");
        }
        if (((DocTableInfo)this.tableInfo).clusteredBy() != null) {
            this.ensureNotUpdated(ci, ((DocTableInfo)this.tableInfo).clusteredBy(), "Updating a clustered-by column is not supported");
        }
        List<GeneratedReference> generatedReferences = ((DocTableInfo)this.tableInfo).generatedColumns();
        for (Reference partitionRef : ((DocTableInfo)this.tableInfo).partitionedByColumns()) {
            int idx;
            this.ensureNotUpdated(ci, partitionRef.column(), "Updating a partitioned-by column is not supported");
            if (!(partitionRef instanceof GeneratedReference) || (idx = generatedReferences.indexOf(partitionRef)) < 0) continue;
            GeneratedReference generatedReference = generatedReferences.get(idx);
            for (Reference reference : generatedReference.referencedReferences()) {
                this.ensureNotUpdated(ci, reference.column(), "Updating a column which is referenced in a partitioned by generated column expression is not supported");
            }
        }
    }

    private void ensureNotUpdated(ColumnIdent columnUpdated, ColumnIdent protectedColumnIdent, String errorMessage) {
        if (columnUpdated.equals(protectedColumnIdent) || protectedColumnIdent.isChildOf(columnUpdated)) {
            throw new ColumnValidationException(columnUpdated.toString(), ((DocTableInfo)this.tableInfo).ident(), errorMessage);
        }
    }
}

