/*
 * Decompiled with CFR 0.152.
 */
package io.crate.blob.v2;

import io.crate.blob.v2.BlobIndex;
import io.crate.blob.v2.BlobShard;
import io.crate.blob.v2.BlobsDisabledException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.jetbrains.annotations.Nullable;

public class BlobIndicesService
implements IndexEventListener {
    private static final Logger LOGGER = LogManager.getLogger(BlobIndicesService.class);
    public static final Setting<Boolean> SETTING_INDEX_BLOBS_ENABLED = Setting.boolSetting("index.blobs.enabled", false, Setting.Property.IndexScope);
    public static final Setting<String> SETTING_INDEX_BLOBS_PATH = Setting.simpleString("index.blobs.path", Setting.Property.IndexScope);
    public static final Setting<String> SETTING_BLOBS_PATH = Setting.simpleString("blobs.path", Setting.Property.NodeScope);
    private final ClusterService clusterService;
    final Map<String, BlobIndex> indices = new ConcurrentHashMap<String, BlobIndex>();
    @Nullable
    private final Path globalBlobPath;

    public BlobIndicesService(Settings settings, ClusterService clusterService) {
        this.clusterService = clusterService;
        this.globalBlobPath = BlobIndicesService.getGlobalBlobPath(settings);
    }

    @Nullable
    public static Path getGlobalBlobPath(Settings settings) {
        String customGlobalBlobPathSetting = SETTING_BLOBS_PATH.get(settings);
        if (Strings.isNullOrEmpty(customGlobalBlobPathSetting)) {
            return null;
        }
        Path globalBlobPath = PathUtils.get(customGlobalBlobPathSetting, new String[0]);
        BlobIndicesService.ensureExistsAndWritable(globalBlobPath);
        return globalBlobPath;
    }

    @Override
    public void afterIndexCreated(IndexService indexService) {
        String indexName = indexService.index().getName();
        if (BlobIndex.isBlobIndex(indexName)) {
            BlobIndex oldBlobIndex = this.indices.put(indexName, new BlobIndex(LOGGER, this.globalBlobPath));
            assert (oldBlobIndex == null) : "There must not be an index present if a new index is created";
        }
    }

    @Override
    public void afterIndexRemoved(Index index, IndexSettings indexSettings, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
        String indexName = index.getName();
        if (BlobIndex.isBlobIndex(indexName)) {
            BlobIndex blobIndex = this.indices.remove(indexName);
            assert (blobIndex != null) : "BlobIndex not found on afterIndexDeleted";
        }
    }

    @Override
    public void afterIndexShardCreated(IndexShard indexShard) {
        String index = indexShard.shardId().getIndexName();
        if (BlobIndex.isBlobIndex(index)) {
            BlobIndex blobIndex = this.indices.get(index);
            assert (blobIndex != null) : "blobIndex must exists if a shard is created in it";
            blobIndex.createShard(indexShard);
        }
    }

    @Override
    public void indexShardStateChanged(IndexShard indexShard, @Nullable IndexShardState previousState, IndexShardState currentState, @Nullable String reason) {
        String index;
        if (currentState == IndexShardState.POST_RECOVERY && BlobIndex.isBlobIndex(index = indexShard.shardId().getIndexName())) {
            BlobIndex blobIndex = this.indices.get(index);
            blobIndex.initializeShard(indexShard);
        }
    }

    @Override
    public void afterIndexShardDeleted(ShardId shardId, Settings indexSettings) {
        BlobIndex blobIndex;
        String index = shardId.getIndexName();
        if (BlobIndex.isBlobIndex(index) && (blobIndex = this.indices.get(index)) != null) {
            blobIndex.removeShard(shardId);
        }
    }

    @Nullable
    public BlobShard blobShard(ShardId shardId) {
        BlobIndex blobIndex = this.indices.get(shardId.getIndexName());
        if (blobIndex == null) {
            return null;
        }
        return blobIndex.getShard(shardId.id());
    }

    public BlobShard blobShardSafe(ShardId shardId) {
        String index = shardId.getIndexName();
        if (BlobIndex.isBlobIndex(index)) {
            BlobShard blobShard = this.blobShard(shardId);
            if (blobShard == null) {
                throw new ShardNotFoundException(shardId);
            }
            return blobShard;
        }
        throw new BlobsDisabledException(shardId.getIndex());
    }

    public BlobShard localBlobShard(String index, String digest) {
        return this.blobShardSafe(this.localShardId(index, digest));
    }

    private ShardId localShardId(String index, String digest) {
        ShardIterator si = this.clusterService.operationRouting().getShards(this.clusterService.state(), index, null, digest, "_only_local");
        return si.shardId();
    }

    static boolean ensureExistsAndWritable(Path blobsPath) {
        if (Files.exists(blobsPath, new LinkOption[0])) {
            if (!Files.isDirectory(blobsPath, new LinkOption[0])) {
                throw new SettingsException(String.format(Locale.ENGLISH, "blobs path '%s' is a file, must be a directory", blobsPath));
            }
            if (!Files.isWritable(blobsPath)) {
                throw new SettingsException(String.format(Locale.ENGLISH, "blobs path '%s' is not writable", blobsPath));
            }
        } else {
            try {
                Files.createDirectories(blobsPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new SettingsException(String.format(Locale.ENGLISH, "blobs path '%s' could not be created", blobsPath));
            }
        }
        return true;
    }
}

