/*
 * Decompiled with CFR 0.152.
 */
package io.crate.cluster.decommission;

import io.crate.cluster.decommission.DecommissionRequest;
import io.crate.cluster.gracefulstop.DecommissioningService;
import io.crate.execution.support.NodeActionRequestHandler;
import io.crate.execution.support.NodeRequest;
import io.crate.execution.support.Transports;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportDecommissionNodeAction
extends TransportAction<NodeRequest<DecommissionRequest>, AcknowledgedResponse> {
    private final DecommissioningService decommissioningService;
    private final Transports transports;

    @Inject
    public TransportDecommissionNodeAction(TransportService transportService, DecommissioningService decommissioningService, Transports transports) {
        super("internal:crate:sql/decommission/node");
        this.decommissioningService = decommissioningService;
        this.transports = transports;
        transportService.registerRequestHandler("internal:crate:sql/decommission/node", "management", DecommissionRequest::new, new NodeActionRequestHandler(this::nodeOperation));
    }

    @Override
    public void doExecute(NodeRequest<DecommissionRequest> request, ActionListener<AcknowledgedResponse> listener) {
        this.transports.sendRequest("internal:crate:sql/decommission/node", request.nodeId(), request.innerRequest(), listener, new ActionListenerResponseHandler<AcknowledgedResponse>(listener, AcknowledgedResponse::new));
    }

    private CompletableFuture<AcknowledgedResponse> nodeOperation(DecommissionRequest request) {
        try {
            return this.decommissioningService.decommission().thenApply(aVoid -> new AcknowledgedResponse(true));
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }
}

