/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

import io.crate.exceptions.TableScopeException;
import io.crate.metadata.RelationName;
import io.crate.rest.action.HttpErrorStatus;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class OperationOnInaccessibleRelationException
extends ElasticsearchException
implements TableScopeException {
    private final RelationName relationName;

    public OperationOnInaccessibleRelationException(RelationName relationName, String msg) {
        super(msg, new Object[0]);
        this.relationName = relationName;
    }

    public OperationOnInaccessibleRelationException(StreamInput in) throws IOException {
        super(in);
        this.relationName = new RelationName(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.relationName.writeTo(out);
    }

    public Collection<RelationName> getTableIdents() {
        return Collections.singletonList(this.relationName);
    }

    @Override
    public HttpErrorStatus httpErrorStatus() {
        return HttpErrorStatus.RELATION_OPERATION_NOT_SUPPORTED;
    }
}

