/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution;

import io.crate.breaker.ConcurrentRamAccounting;
import io.crate.data.CollectingRowConsumer;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.data.breaker.BlockBasedRamAccounting;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.FirstColumnConsumers;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.SubQueryResults;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public final class MultiPhaseExecutor {
    private MultiPhaseExecutor() {
    }

    public static CompletableFuture<SubQueryResults> execute(Map<LogicalPlan, SelectSymbol> dependencies, DependencyCarrier executor, PlannerContext plannerContext, Row params) {
        ConcurrentRamAccounting ramAccounting = ConcurrentRamAccounting.forCircuitBreaker("multi-phase", executor.circuitBreaker("query"), plannerContext.transactionContext().sessionSettings().memoryLimitInBytes());
        ArrayList<CompletionStage> dependencyFutures = new ArrayList<CompletionStage>(dependencies.size());
        IdentityHashMap valueBySubQuery = new IdentityHashMap();
        for (Map.Entry<LogicalPlan, SelectSymbol> entry : dependencies.entrySet()) {
            LogicalPlan depPlan = entry.getKey();
            depPlan = plannerContext.optimize().apply(depPlan, plannerContext);
            SelectSymbol selectSymbol = entry.getValue();
            CollectingRowConsumer<?, ?> rowConsumer = MultiPhaseExecutor.getConsumer(selectSymbol, ramAccounting);
            depPlan.execute(executor, PlannerContext.forSubPlan(plannerContext), (RowConsumer)rowConsumer, params, SubQueryResults.EMPTY);
            dependencyFutures.add(rowConsumer.completionFuture().thenAccept(val -> {
                IdentityHashMap identityHashMap = valueBySubQuery;
                synchronized (identityHashMap) {
                    valueBySubQuery.put(selectSymbol, val);
                }
            }));
        }
        return ((CompletableFuture)CompletableFuture.allOf(dependencyFutures.toArray(new CompletableFuture[0])).thenApply(void_ -> new SubQueryResults(valueBySubQuery))).whenComplete((subQueryResults, throwable) -> ramAccounting.release());
    }

    public static CollectingRowConsumer<?, ?> getConsumer(SelectSymbol selectSymbol, RamAccounting ramAccounting) {
        return new CollectingRowConsumer(FirstColumnConsumers.getCollector(selectSymbol.getResultType(), selectSymbol.innerType(), (RamAccounting)new BlockBasedRamAccounting(arg_0 -> ((RamAccounting)ramAccounting).addBytes(arg_0), 0x200000)));
    }
}

