/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.index;

import io.crate.execution.ddl.AbstractDDLTransportAction;
import io.crate.execution.ddl.index.SwapAndDropIndexRequest;
import io.crate.metadata.cluster.SwapAndDropIndexExecutor;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportSwapAndDropIndexNameAction
extends AbstractDDLTransportAction<SwapAndDropIndexRequest, AcknowledgedResponse> {
    private static final String ACTION_NAME = "internal:crate:sql/index/swap_and_drop_index";
    private final SwapAndDropIndexExecutor executor;

    @Inject
    public TransportSwapAndDropIndexNameAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, AllocationService allocationService) {
        super(ACTION_NAME, transportService, clusterService, threadPool, SwapAndDropIndexRequest::new, AcknowledgedResponse::new, AcknowledgedResponse::new, "swap-and-drop-index");
        this.executor = new SwapAndDropIndexExecutor(allocationService);
    }

    @Override
    public ClusterStateTaskExecutor<SwapAndDropIndexRequest> clusterStateTaskExecutor(SwapAndDropIndexRequest request) {
        return this.executor;
    }

    @Override
    protected ClusterBlockException checkBlock(SwapAndDropIndexRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, new String[]{request.source(), request.target()});
    }
}

