/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.util.List;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.index.Index;
import org.jetbrains.annotations.Nullable;

public record AlterTableTarget(RelationName table, Index[] indices, List<String> partitionValues, @Nullable IndexTemplateMetadata templateMetadata) {
    public static AlterTableTarget of(ClusterState state, RelationName table, List<String> partitionValues) {
        Metadata metadata = state.metadata();
        if (partitionValues.isEmpty()) {
            Index[] indices = IndexNameExpressionResolver.concreteIndices(metadata, IndicesOptions.LENIENT_EXPAND_OPEN, table.indexNameOrAlias());
            String templateName = PartitionName.templateName(table.schema(), table.name());
            IndexTemplateMetadata indexTemplateMetadata = metadata.templates().get(templateName);
            return new AlterTableTarget(table, indices, partitionValues, indexTemplateMetadata);
        }
        String indexName = new PartitionName(table, partitionValues).asIndexName();
        Index[] indices = IndexNameExpressionResolver.concreteIndices(metadata, IndicesOptions.LENIENT_EXPAND_OPEN, indexName);
        return new AlterTableTarget(table, indices, partitionValues, null);
    }

    public boolean targetsIndividualPartition() {
        return !this.partitionValues.isEmpty();
    }

    public boolean isEmpty() {
        return this.indices.length == 0 && this.templateMetadata == null;
    }
}

