/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import com.carrotsearch.hppc.IntArrayList;
import io.crate.common.unit.TimeValue;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateTableRequest
extends MasterNodeRequest<CreateTableRequest>
implements AckedRequest {
    private final RelationName relationName;
    private final List<Reference> columns;
    @Nullable
    private final String pkConstraintName;
    private final IntArrayList pKeyIndices;
    private final Map<String, String> checkConstraints;
    private final Settings settings;
    @Nullable
    private final ColumnIdent routingColumn;
    private final ColumnPolicy tableColumnPolicy;
    private final List<ColumnIdent> partitionedBy;

    public CreateTableRequest(RelationName relationName, @Nullable String pkConstraintName, List<Reference> columns, IntArrayList pKeyIndices, Map<String, String> checkConstraints, Settings settings, @Nullable ColumnIdent routingColumn, ColumnPolicy tableColumnPolicy, List<ColumnIdent> partitionedBy) {
        this.relationName = relationName;
        this.pkConstraintName = pkConstraintName;
        this.columns = columns;
        this.pKeyIndices = pKeyIndices;
        this.checkConstraints = checkConstraints;
        this.settings = settings;
        this.routingColumn = routingColumn;
        this.tableColumnPolicy = tableColumnPolicy;
        this.partitionedBy = partitionedBy;
    }

    @NotNull
    public RelationName getTableName() {
        return this.relationName;
    }

    @Nullable
    public String pkConstraintName() {
        return this.pkConstraintName;
    }

    @Override
    public TimeValue ackTimeout() {
        return AcknowledgedRequest.DEFAULT_ACK_TIMEOUT;
    }

    public CreateTableRequest(StreamInput in) throws IOException {
        super(in);
        this.pkConstraintName = in.getVersion().onOrAfter(Version.V_5_6_0) ? in.readOptionalString() : null;
        this.relationName = new RelationName(in);
        this.checkConstraints = in.readMap(LinkedHashMap::new, StreamInput::readString, StreamInput::readString);
        this.columns = in.readList(Reference::fromStream);
        int numPKIndices = in.readVInt();
        this.pKeyIndices = new IntArrayList(numPKIndices);
        for (int i = 0; i < numPKIndices; ++i) {
            this.pKeyIndices.add(in.readVInt());
        }
        this.settings = Settings.readSettingsFromStream(in);
        boolean after510 = in.getVersion().onOrAfter(Version.V_5_10_0);
        this.routingColumn = after510 ? in.readOptionalWriteable(ColumnIdent::of) : ColumnIdent.fromPath(in.readOptionalString());
        this.tableColumnPolicy = (ColumnPolicy)ColumnPolicy.VALUES.get(in.readVInt());
        if (after510) {
            this.partitionedBy = in.readList(ColumnIdent::of);
        } else {
            List<List> partitionedBy = in.readList(StreamInput::readStringList);
            this.partitionedBy = new ArrayList<ColumnIdent>(partitionedBy.size());
            for (List column : partitionedBy) {
                this.partitionedBy.add(ColumnIdent.fromPath((String)column.get(0)));
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_5_6_0)) {
            out.writeOptionalString(this.pkConstraintName);
        }
        this.relationName.writeTo(out);
        out.writeMap(this.checkConstraints, StreamOutput::writeString, StreamOutput::writeString);
        out.writeCollection(this.columns, Reference::toStream);
        out.writeVInt(this.pKeyIndices.size());
        for (int i = 0; i < this.pKeyIndices.size(); ++i) {
            out.writeVInt(this.pKeyIndices.get(i));
        }
        Settings.writeSettingsToStream(out, this.settings);
        boolean after510 = out.getVersion().onOrAfter(Version.V_5_10_0);
        if (after510) {
            out.writeOptionalWriteable(this.routingColumn);
        } else {
            out.writeOptionalString(this.routingColumn == null ? null : this.routingColumn.fqn());
        }
        out.writeVInt(this.tableColumnPolicy.ordinal());
        if (after510) {
            out.writeList(this.partitionedBy);
        } else {
            out.writeVInt(this.partitionedBy.size());
            for (ColumnIdent column : this.partitionedBy) {
                int refIdx = Reference.indexOf(this.columns, column);
                Reference reference = this.columns.get(refIdx);
                out.writeVInt(2);
                out.writeString(column.fqn());
                out.writeString(DataTypes.esMappingNameFrom(reference.valueType().id()));
            }
        }
    }

    @NotNull
    public Settings settings() {
        return this.settings;
    }

    @Nullable
    public ColumnIdent routingColumn() {
        return this.routingColumn;
    }

    @NotNull
    public ColumnPolicy tableColumnPolicy() {
        return this.tableColumnPolicy;
    }

    @NotNull
    public List<ColumnIdent> partitionedBy() {
        return this.partitionedBy;
    }

    @NotNull
    public Map<String, String> checkConstraints() {
        return this.checkConstraints;
    }

    @NotNull
    public List<Reference> references() {
        return this.columns;
    }

    @NotNull
    public IntArrayList pKeyIndices() {
        return this.pKeyIndices;
    }
}

