/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import com.carrotsearch.hppc.IntArrayList;
import io.crate.common.collections.Lists;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.IndexReference;
import io.crate.metadata.Reference;
import io.crate.metadata.table.TableInfo;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.ObjectType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import org.elasticsearch.cluster.metadata.Metadata;
import org.jetbrains.annotations.Nullable;

public final class MappingUtil {
    public static final String DROPPED_COLUMN_NAME_PREFIX = "_dropped_";

    private MappingUtil() {
    }

    public static Map<String, Object> createMapping(AllocPosition allocPosition, @Nullable String pkConstraintName, List<Reference> columns, IntArrayList pKeyIndices, Map<String, String> checkConstraints, List<ColumnIdent> partitionedBy, @Nullable ColumnPolicy tableColumnPolicy, @Nullable ColumnIdent routingColumn) {
        HashMap<ColumnIdent, List<Reference>> tree = Reference.buildTree(columns);
        Map<String, Map<String, Object>> propertiesMap = MappingUtil.toProperties(allocPosition, null, tree);
        assert (propertiesMap != null) : "ADD COLUMN mapping can not be null";
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        HashMap<String, Object> meta = new HashMap<String, Object>();
        if (pkConstraintName != null) {
            meta.put("pk_constraint_name", pkConstraintName);
        }
        MappingUtil.mergeConstraints(meta, columns, pKeyIndices, checkConstraints);
        if (routingColumn != null) {
            meta.put("routing", routingColumn.fqn());
        }
        if (tableColumnPolicy != null) {
            mapping.put("dynamic", tableColumnPolicy.toMappingValue());
        }
        HashMap indices = new HashMap();
        for (Reference column : columns) {
            IndexReference indexRef;
            if (!(column instanceof IndexReference) || (indexRef = (IndexReference)column).columns().isEmpty()) continue;
            indices.put(column.storageIdent(), Map.of());
        }
        if (!indices.isEmpty()) {
            meta.put("indices", indices);
        }
        if (!partitionedBy.isEmpty()) {
            List pColumns = Lists.map(partitionedBy, pColumn -> {
                int refIdx = Reference.indexOf(columns, pColumn);
                Reference pRef = (Reference)columns.get(refIdx);
                return MappingUtil.toPartitionMapping(pRef);
            });
            meta.put("partitioned_by", pColumns);
        }
        mapping.put("_meta", meta);
        mapping.put("properties", propertiesMap);
        return mapping;
    }

    private static List<String> toPartitionMapping(Reference ref) {
        String fqn = ref.column().fqn();
        String typeMappingName = DataTypes.esMappingNameFrom(ref.valueType().id());
        return List.of(fqn, typeMappingName);
    }

    public static Map<String, Map<String, Object>> toProperties(AllocPosition allocPosition, HashMap<ColumnIdent, List<Reference>> tree) {
        return MappingUtil.toProperties(allocPosition, null, tree);
    }

    @Nullable
    private static Map<String, Map<String, Object>> toProperties(AllocPosition position, @Nullable ColumnIdent currentNode, HashMap<ColumnIdent, List<Reference>> tree) {
        List<Reference> children = tree.get(currentNode);
        if (children == null) {
            return null;
        }
        LinkedHashMap<String, Map<String, Object>> allColumnsMap = new LinkedHashMap<String, Map<String, Object>>();
        for (Reference child : children) {
            allColumnsMap.put(MappingUtil.mappingKey(child), MappingUtil.addColumnProperties(position, child, tree));
        }
        return allColumnsMap;
    }

    private static String mappingKey(Reference reference) {
        if (reference.isDropped()) {
            assert (reference.oid() != Metadata.COLUMN_OID_UNASSIGNED) : "Only columns with assigned OID-s can be dropped";
            return DROPPED_COLUMN_NAME_PREFIX + reference.oid();
        }
        return reference.column().leafName();
    }

    private static Map<String, Object> addColumnProperties(AllocPosition position, Reference reference, HashMap<ColumnIdent, List<Reference>> tree) {
        Map<String, Object> leafProperties;
        Map<String, Object> properties = leafProperties = reference.toMapping(position.position(reference.column()));
        DataType<Object> valueType = reference.valueType();
        while (valueType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)valueType;
            HashMap<String, Object> arrayMapping = new HashMap<String, Object>();
            arrayMapping.put("type", "array");
            arrayMapping.put("inner", properties);
            valueType = arrayType.innerType();
            properties = arrayMapping;
        }
        if (valueType instanceof ObjectType) {
            ObjectType objectType = (ObjectType)valueType;
            MappingUtil.objectMapping(position, leafProperties, objectType, reference.column(), tree);
        }
        return properties;
    }

    private static void objectMapping(AllocPosition position, Map<String, Object> propertiesMap, ObjectType objectType, ColumnIdent columnIdent, HashMap<ColumnIdent, List<Reference>> tree) {
        propertiesMap.put("dynamic", objectType.columnPolicy().toMappingValue());
        Map<String, Map<String, Object>> nestedObjectMap = MappingUtil.toProperties(position, columnIdent, tree);
        if (nestedObjectMap != null) {
            propertiesMap.put("properties", nestedObjectMap);
        }
    }

    public static void mergeConstraints(Map<String, Object> meta, List<Reference> references, IntArrayList pKeyIndices, Map<String, String> checkConstraints) {
        List<GeneratedReference> newGenExpressions;
        if (!checkConstraints.isEmpty()) {
            LinkedHashMap<String, String> existingCheckConstraints = (LinkedHashMap<String, String>)meta.get("check_constraints");
            if (existingCheckConstraints == null) {
                existingCheckConstraints = new LinkedHashMap<String, String>();
                meta.put("check_constraints", existingCheckConstraints);
            }
            for (Map.Entry<String, String> entry : checkConstraints.entrySet()) {
                String name = entry.getKey();
                String expression = entry.getValue();
                existingCheckConstraints.put(name, expression);
            }
        }
        ArrayList<ColumnIdent> pkColumns = new ArrayList<ColumnIdent>();
        if (!pKeyIndices.isEmpty()) {
            ArrayList<String> primaryKeys = (ArrayList<String>)meta.get("primary_keys");
            if (primaryKeys == null) {
                primaryKeys = new ArrayList<String>();
                meta.put("primary_keys", primaryKeys);
            }
            for (int i = 0; i < pKeyIndices.size(); ++i) {
                Reference pkRef = references.get(pKeyIndices.get(i));
                pkColumns.add(pkRef.column());
                primaryKeys.add(pkRef.column().fqn());
            }
        }
        ArrayList<String> newNotNulls = new ArrayList<String>();
        for (int i = 0; i < references.size(); ++i) {
            Reference ref2 = references.get(i);
            if (ref2.isNullable() || pkColumns.contains(ref2.column())) continue;
            newNotNulls.add(ref2.column().fqn());
        }
        if (!newNotNulls.isEmpty()) {
            ArrayList<String> notNulls;
            Map constraints = (Map)meta.get("constraints");
            ArrayList<String> arrayList = notNulls = constraints != null ? (ArrayList<String>)constraints.get("not_null") : null;
            if (notNulls == null) {
                notNulls = new ArrayList<String>();
                HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
                map.put("not_null", notNulls);
                meta.put("constraints", map);
            }
            notNulls.addAll(newNotNulls);
        }
        if (!(newGenExpressions = references.stream().filter(ref -> ref instanceof GeneratedReference && !ref.isDropped()).map(ref -> (GeneratedReference)ref).toList()).isEmpty()) {
            HashMap<String, String> generatedColumns = (HashMap<String, String>)meta.get("generated_columns");
            if (generatedColumns == null) {
                generatedColumns = new HashMap<String, String>();
                meta.put("generated_columns", generatedColumns);
            }
            for (GeneratedReference genRef : newGenExpressions) {
                generatedColumns.put(genRef.column().fqn(), genRef.formattedGeneratedExpression());
            }
        }
    }

    public static class AllocPosition {
        private final ToIntFunction<ColumnIdent> getExistingPosition;
        private int nextPosition;

        public static AllocPosition forTable(TableInfo table) {
            return new AllocPosition(table.maxPosition(), column -> {
                Reference reference = table.getReference((ColumnIdent)column);
                if (reference == null) {
                    for (Reference droppedColumn : table.droppedColumns()) {
                        if (!droppedColumn.column().equals(column)) continue;
                        return droppedColumn.position();
                    }
                    return -1;
                }
                return reference.position();
            });
        }

        public static AllocPosition forNewTable() {
            return new AllocPosition(0, column -> -1);
        }

        private AllocPosition(int maxPosition, ToIntFunction<ColumnIdent> getExistingPosition) {
            this.getExistingPosition = getExistingPosition;
            this.nextPosition = maxPosition + 1;
        }

        public int position(ColumnIdent column) {
            int position = this.getExistingPosition.applyAsInt(column);
            if (position < 0) {
                return this.nextPosition++;
            }
            return position;
        }
    }
}

