/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import java.io.IOException;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.NotNull;

public class RenameColumnRequest
extends AcknowledgedRequest<RenameColumnRequest> {
    private final RelationName relationName;
    private final Reference refToRename;
    private final ColumnIdent newName;

    public RenameColumnRequest(@NotNull RelationName relationName, @NotNull Reference refToRename, @NotNull ColumnIdent newName) {
        this.relationName = relationName;
        this.refToRename = refToRename;
        this.newName = newName;
    }

    public RenameColumnRequest(StreamInput in) throws IOException {
        super(in);
        this.relationName = new RelationName(in);
        this.refToRename = (Reference)Symbol.fromStream(in);
        this.newName = ColumnIdent.of(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.relationName.writeTo(out);
        Symbol.toStream(this.refToRename, out);
        this.newName.writeTo(out);
    }

    public RelationName relationName() {
        return this.relationName;
    }

    public Reference refToRename() {
        return this.refToRename;
    }

    public ColumnIdent newName() {
        return this.newName;
    }
}

