/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.execution.ddl.tables.CreateBlobTableRequest;
import io.crate.execution.ddl.tables.CreateTableResponse;
import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportCreateBlobTableAction
extends TransportMasterNodeAction<CreateBlobTableRequest, CreateTableResponse> {
    public static final Action ACTION = new Action();
    private final MetadataCreateIndexService createIndexService;

    @Inject
    public TransportCreateBlobTableAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataCreateIndexService createIndexService) {
        super(ACTION.name(), transportService, clusterService, threadPool, CreateBlobTableRequest::new);
        this.createIndexService = createIndexService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected CreateTableResponse read(StreamInput in) throws IOException {
        return new CreateTableResponse(in);
    }

    @Override
    protected void masterOperation(CreateBlobTableRequest request, ClusterState state, ActionListener<CreateTableResponse> listener) throws Exception {
        this.createIndexService.addBlobTable(request, listener);
    }

    @Override
    protected ClusterBlockException checkBlock(CreateBlobTableRequest request, ClusterState state) {
        String indexName = request.name().indexNameOrAlias();
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, indexName);
    }

    public static class Action
    extends ActionType<CreateTableResponse> {
        public static final String NAME = "internal:crate:sql/tables/blob/create";

        public Action() {
            super(NAME);
        }
    }
}

