/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.execution.ddl.AbstractDDLTransportAction;
import io.crate.execution.ddl.tables.OpenTableRequest;
import io.crate.execution.ddl.tables.TransportCloseTable;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateService;
import io.crate.metadata.cluster.OpenTableClusterStateTaskExecutor;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataIndexUpgradeService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportOpenTableAction
extends AbstractDDLTransportAction<OpenTableRequest, AcknowledgedResponse> {
    private static final IndicesOptions STRICT_INDICES_OPTIONS = IndicesOptions.fromOptions(false, false, false, false);
    private static final String ACTION_NAME = "internal:crate:sql/table_or_partition/open_close";
    private final OpenTableClusterStateTaskExecutor openExecutor;

    @Inject
    public TransportOpenTableAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, AllocationService allocationService, DDLClusterStateService ddlClusterStateService, MetadataIndexUpgradeService metadataIndexUpgradeService, IndicesService indexServices) {
        super(ACTION_NAME, transportService, clusterService, threadPool, OpenTableRequest::new, AcknowledgedResponse::new, AcknowledgedResponse::new, "open-table-or-partition");
        this.openExecutor = new OpenTableClusterStateTaskExecutor(allocationService, ddlClusterStateService, metadataIndexUpgradeService, indexServices);
    }

    @Override
    public ClusterStateTaskExecutor<OpenTableRequest> clusterStateTaskExecutor(OpenTableRequest request) {
        return this.openExecutor;
    }

    @Override
    protected ClusterBlockException checkBlock(OpenTableRequest request, ClusterState state) {
        String[] indexNames;
        RelationName relation = request.relation();
        if (TransportCloseTable.isEmptyPartitionedTable(relation, state)) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }
        if (request.partitionValues().isEmpty()) {
            indexNames = IndexNameExpressionResolver.concreteIndexNames(state.metadata(), STRICT_INDICES_OPTIONS, relation.indexNameOrAlias());
        } else {
            PartitionName partition = new PartitionName(relation, request.partitionValues());
            indexNames = IndexNameExpressionResolver.concreteIndexNames(state.metadata(), STRICT_INDICES_OPTIONS, partition.asIndexName());
        }
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, indexNames);
    }
}

