/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.execution.dml.IndexDocumentBuilder;
import io.crate.execution.dml.ValueIndexer;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.SysColumns;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.jetbrains.annotations.NotNull;
import org.locationtech.spatial4j.shape.Point;

public class GeoPointIndexer
implements ValueIndexer<Point> {
    private final Reference ref;
    private final String name;

    public GeoPointIndexer(Reference ref) {
        this.ref = ref;
        this.name = ref.storageIdent();
    }

    @Override
    public void indexValue(@NotNull Point point, IndexDocumentBuilder docBuilder) throws IOException {
        if (this.ref.indexType() != IndexType.NONE) {
            docBuilder.addField((IndexableField)new LatLonPoint(this.name, point.getLat(), point.getLon()));
        }
        if (this.ref.hasDocValues()) {
            docBuilder.addField((IndexableField)new LatLonDocValuesField(this.name, point.getLat(), point.getLon()));
        } else {
            docBuilder.addField((IndexableField)new Field("_field_names", (CharSequence)this.name, (IndexableFieldType)SysColumns.FieldNames.FIELD_TYPE));
        }
        if (docBuilder.maybeAddStoredField()) {
            docBuilder.addField((IndexableField)new StoredField(this.name, GeoPointIndexer.toByteArray(point)));
        }
        docBuilder.translogWriter().startArray();
        docBuilder.translogWriter().writeValue(point.getX());
        docBuilder.translogWriter().writeValue(point.getY());
        docBuilder.translogWriter().endArray();
    }

    private static byte[] toByteArray(Point point) {
        byte[] bytes = new byte[16];
        ByteBuffer.wrap(bytes).asDoubleBuffer().put(point.getX()).put(point.getY());
        return bytes;
    }

    @Override
    public String storageIdentLeafName() {
        return this.ref.storageIdentLeafName();
    }
}

