/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml.delete;

import io.crate.execution.dml.ShardRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class ShardDeleteRequest
extends ShardRequest<ShardDeleteRequest, Item> {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(ShardDeleteRequest.class);
    private int skipFromLocation = -1;

    public ShardDeleteRequest(ShardId shardId, UUID jobId) {
        super(shardId, jobId);
    }

    void skipFromLocation(int location) {
        this.skipFromLocation = location;
    }

    int skipFromLocation() {
        return this.skipFromLocation;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.items.size());
        for (Item item : this.items) {
            item.writeTo(out);
        }
        if (this.skipFromLocation > -1) {
            out.writeBoolean(true);
            out.writeVInt(this.skipFromLocation);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    protected long shallowSize() {
        return SHALLOW_SIZE;
    }

    public ShardDeleteRequest(StreamInput in) throws IOException {
        super(in);
        int numItems = in.readVInt();
        this.items = new ArrayList(numItems);
        for (int i = 0; i < numItems; ++i) {
            this.items.add(new Item(in));
        }
        if (in.readBoolean()) {
            this.skipFromLocation = in.readVInt();
        }
    }

    public static class Item
    extends ShardRequest.Item {
        public static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(Item.class);

        protected Item(StreamInput in) throws IOException {
            super(in);
        }

        public Item(String id) {
            super(id);
        }

        public Item(String id, long seqNo, long primaryTerm, long version) {
            super(id);
            this.seqNo = seqNo;
            this.primaryTerm = primaryTerm;
            this.version = version;
        }
    }
}

