/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.execution.dsl.projection.AbstractIndexWriterProjection;
import io.crate.execution.dsl.projection.ProjectionType;
import io.crate.execution.dsl.projection.ProjectionVisitor;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;

public class ColumnIndexWriterProjection
extends AbstractIndexWriterProjection {
    private final boolean ignoreDuplicateKeys;
    private final Map<Reference, Symbol> onDuplicateKeyAssignments;
    private final List<Reference> allTargetColumns;
    private final List<? extends Symbol> outputs;
    private final long fullDocSizeEstimate;
    private List<Symbol> returnValues;

    public ColumnIndexWriterProjection(RelationName relationName, @Nullable String partitionIdent, List<ColumnIdent> primaryKeys, List<Reference> allTargetColumns, boolean ignoreDuplicateKeys, Map<Reference, Symbol> onDuplicateKeyAssignments, List<Symbol> primaryKeySymbols, List<Symbol> partitionedBySymbols, @Nullable ColumnIdent clusteredByColumn, @Nullable Symbol clusteredBySymbol, Settings settings, boolean autoCreateIndices, List<? extends Symbol> outputs, List<Symbol> returnValues, long fullDocSizeEstimate) {
        super(relationName, partitionIdent, primaryKeys, clusteredByColumn, settings, primaryKeySymbols, autoCreateIndices);
        assert (partitionedBySymbols.stream().noneMatch(s -> s.any(Symbol.IS_COLUMN))) : "All references and fields in partitionedBySymbols must be resolved to inputColumns, got: " + String.valueOf(partitionedBySymbols);
        this.allTargetColumns = allTargetColumns;
        this.partitionedBySymbols = partitionedBySymbols;
        this.ignoreDuplicateKeys = ignoreDuplicateKeys;
        this.onDuplicateKeyAssignments = onDuplicateKeyAssignments;
        this.clusteredBySymbol = clusteredBySymbol;
        this.outputs = outputs;
        this.returnValues = returnValues;
        this.fullDocSizeEstimate = fullDocSizeEstimate;
    }

    ColumnIndexWriterProjection(StreamInput in) throws IOException {
        super(in);
        int mapSize;
        int i;
        if (in.getVersion().before(Version.V_5_5_0)) {
            if (in.readBoolean()) {
                Symbols.fromStream(in);
            }
            if (in.readBoolean()) {
                int length = in.readVInt();
                for (i = 0; i < length; ++i) {
                    Reference.fromStream(in);
                }
            }
        }
        this.ignoreDuplicateKeys = in.readBoolean();
        if (in.readBoolean()) {
            mapSize = in.readVInt();
            this.onDuplicateKeyAssignments = new HashMap<Reference, Symbol>(mapSize);
            for (i = 0; i < mapSize; ++i) {
                this.onDuplicateKeyAssignments.put((Reference)Reference.fromStream(in), Symbol.fromStream(in));
            }
        } else {
            this.onDuplicateKeyAssignments = Collections.emptyMap();
        }
        if (in.getVersion().onOrAfter(Version.V_4_2_0)) {
            int i2;
            mapSize = in.readVInt();
            this.allTargetColumns = new ArrayList<Reference>();
            for (i = 0; i < mapSize; ++i) {
                this.allTargetColumns.add((Reference)Reference.fromStream(in));
            }
            int outputSize = in.readVInt();
            if (outputSize > 0) {
                ArrayList<? extends Symbol> result = new ArrayList<Symbol>(outputSize);
                for (i2 = 0; i2 < outputSize; ++i2) {
                    result.add(Symbol.fromStream(in));
                }
                this.outputs = result;
            } else {
                this.outputs = List.of();
            }
            int returnValueSize = in.readVInt();
            if (returnValueSize > 0) {
                this.returnValues = new ArrayList<Symbol>(returnValueSize);
                for (i2 = 0; i2 < returnValueSize; ++i2) {
                    this.returnValues.add(Symbol.fromStream(in));
                }
            } else {
                this.returnValues = List.of();
            }
        } else {
            this.returnValues = List.of();
            this.outputs = List.of();
            this.allTargetColumns = List.of();
        }
        this.fullDocSizeEstimate = in.getVersion().onOrAfter(Version.V_5_10_5) ? in.readLong() : 0L;
    }

    public long fullDocSizeEstimate() {
        return this.fullDocSizeEstimate;
    }

    @Override
    public List<? extends Symbol> outputs() {
        return this.outputs;
    }

    public List<Symbol> returnValues() {
        return this.returnValues;
    }

    public List<Reference> allTargetColumns() {
        return this.allTargetColumns;
    }

    public boolean isIgnoreDuplicateKeys() {
        return this.ignoreDuplicateKeys;
    }

    public Map<Reference, Symbol> onDuplicateKeyAssignments() {
        return this.onDuplicateKeyAssignments;
    }

    @Override
    public <C, R> R accept(ProjectionVisitor<C, R> visitor, C context) {
        return visitor.visitColumnIndexWriterProjection(this, context);
    }

    @Override
    public ProjectionType projectionType() {
        return ProjectionType.COLUMN_INDEX_WRITER;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ColumnIndexWriterProjection that = (ColumnIndexWriterProjection)o;
        return this.onDuplicateKeyAssignments.equals(that.onDuplicateKeyAssignments) && this.allTargetColumns.equals(that.allTargetColumns) && Objects.equals(this.outputs, that.outputs) && Objects.equals(this.returnValues, that.returnValues) && Objects.equals(this.fullDocSizeEstimate, that.fullDocSizeEstimate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.onDuplicateKeyAssignments, this.allTargetColumns, this.outputs, this.returnValues, this.fullDocSizeEstimate);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_5_5_0)) {
            out.writeBoolean(false);
            out.writeBoolean(false);
        }
        out.writeBoolean(this.ignoreDuplicateKeys);
        if (this.onDuplicateKeyAssignments == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.onDuplicateKeyAssignments.size());
            for (Map.Entry<Reference, Symbol> entry : this.onDuplicateKeyAssignments.entrySet()) {
                Reference.toStream(out, entry.getKey());
                Symbol.toStream(entry.getValue(), out);
            }
        }
        if (out.getVersion().onOrAfter(Version.V_4_2_0)) {
            out.writeVInt(this.allTargetColumns.size());
            for (Reference reference : this.allTargetColumns) {
                Symbol.toStream(reference, out);
            }
            if (this.outputs != null) {
                out.writeVInt(this.outputs.size());
                for (Symbol symbol : this.outputs) {
                    Symbol.toStream(symbol, out);
                }
            } else {
                out.writeVInt(0);
            }
            out.writeVInt(this.returnValues.size());
            for (Symbol symbol : this.returnValues) {
                Symbol.toStream(symbol, out);
            }
        }
        if (out.getVersion().onOrAfter(Version.V_5_10_5)) {
            out.writeLong(this.fullDocSizeEstimate);
        }
    }

    public ColumnIndexWriterProjection bind(Function<? super Symbol, Symbol> binder) {
        HashMap<Reference, Symbol> boundOnDuplicateKeyAssignments = new HashMap<Reference, Symbol>(this.onDuplicateKeyAssignments.size());
        for (Map.Entry<Reference, Symbol> assignment : this.onDuplicateKeyAssignments.entrySet()) {
            boundOnDuplicateKeyAssignments.put(assignment.getKey(), binder.apply(assignment.getValue()));
        }
        return new ColumnIndexWriterProjection(this.tableIdent(), null, this.primaryKeys, this.allTargetColumns, this.ignoreDuplicateKeys, boundOnDuplicateKeyAssignments, this.ids(), this.partitionedBySymbols, this.clusteredByIdent(), this.clusteredBySymbol, Settings.EMPTY, this.autoCreateIndices(), this.outputs, this.returnValues, this.fullDocSizeEstimate);
    }
}

