/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.common.collections.Lists;
import io.crate.common.collections.MapBuilder;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.ProjectionType;
import io.crate.execution.dsl.projection.ProjectionVisitor;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.types.DataType;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class LimitAndOffsetProjection
extends Projection {
    private final int limit;
    private final int offset;
    private final List<Symbol> outputs;

    public LimitAndOffsetProjection(int limit, int offset, List<DataType<?>> outputTypes) {
        this.limit = limit;
        this.offset = offset;
        this.outputs = InputColumn.mapToInputColumns(outputTypes);
    }

    public LimitAndOffsetProjection(StreamInput in) throws IOException {
        this.offset = in.readVInt();
        this.limit = in.readVInt();
        this.outputs = Symbols.fromStream(in);
    }

    public List<Symbol> outputs() {
        return this.outputs;
    }

    public int limit() {
        return this.limit;
    }

    public int offset() {
        return this.offset;
    }

    @Override
    public ProjectionType projectionType() {
        return ProjectionType.LIMITANDOFFSET;
    }

    @Override
    public <C, R> R accept(ProjectionVisitor<C, R> visitor, C context) {
        return visitor.visitLimitAndOffsetProjection(this, context);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.offset);
        out.writeVInt(this.limit);
        Symbols.toStream(this.outputs, out);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LimitAndOffsetProjection that = (LimitAndOffsetProjection)o;
        if (this.limit != that.limit) {
            return false;
        }
        if (this.offset != that.offset) {
            return false;
        }
        return this.outputs.equals(that.outputs);
    }

    @Override
    public int hashCode() {
        int result = this.limit;
        result = 31 * result + this.offset;
        result = 31 * result + this.outputs.hashCode();
        return result;
    }

    @Override
    public Map<String, Object> mapRepresentation() {
        return MapBuilder.newMapBuilder().put((Object)"type", (Object)"LimitAndOffset").put((Object)"limit", (Object)this.limit).put((Object)"offset", (Object)this.offset).put((Object)"outputs", (Object)Lists.joinOn((String)", ", this.outputs, (Function<Symbol, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/expression/symbol/Symbol;)Ljava/lang/String;)())).map();
    }

    public String toString() {
        return "LimitAndOffsetProjection{outputs=" + String.valueOf(this.outputs) + ", limit=" + this.limit + ", offset=" + this.offset + "}";
    }
}

