/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine;

import io.crate.execution.engine.InitializationTracker;
import io.crate.execution.engine.JobLauncher;
import io.crate.execution.jobs.transport.JobResponse;
import java.util.List;
import org.elasticsearch.action.ActionListener;

class FailureOnlyResponseListener
implements ActionListener<JobResponse> {
    private final List<JobLauncher.HandlerPhase> handlerPhases;
    private final InitializationTracker initializationTracker;

    FailureOnlyResponseListener(List<JobLauncher.HandlerPhase> handlerPhases, InitializationTracker initializationTracker) {
        this.handlerPhases = handlerPhases;
        this.initializationTracker = initializationTracker;
    }

    @Override
    public void onResponse(JobResponse jobResponse) {
        this.initializationTracker.jobInitialized();
        if (jobResponse.hasDirectResponses()) {
            for (JobLauncher.HandlerPhase handlerPhase : this.handlerPhases) {
                handlerPhase.consumer().accept(null, (Throwable)new IllegalStateException("Got a directResponse but didn't expect one"));
            }
        }
    }

    @Override
    public void onFailure(Exception e) {
        this.initializationTracker.jobInitializationFailed(e);
        for (JobLauncher.HandlerPhase handlerPhase : this.handlerPhases) {
            handlerPhase.consumer().accept(null, (Throwable)e);
        }
    }
}

