/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine;

import io.crate.data.BatchIterator;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.exceptions.SQLExceptions;
import io.crate.execution.engine.InitializationTracker;
import io.crate.execution.jobs.kill.KillJobsNodeRequest;
import io.crate.execution.jobs.kill.KillResponse;
import io.crate.execution.support.ActionExecutor;
import io.crate.execution.support.ThreadPools;
import io.crate.role.Role;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

class InterceptingRowConsumer
implements RowConsumer {
    private static final Logger LOGGER = LogManager.getLogger(InterceptingRowConsumer.class);
    private final AtomicInteger consumerInvokedAndJobInitialized = new AtomicInteger(2);
    private final UUID jobId;
    private final RowConsumer consumer;
    private final Executor executor;
    private final ActionExecutor<KillJobsNodeRequest, KillResponse> killNodeAction;
    private final AtomicBoolean consumerAccepted = new AtomicBoolean(false);
    private Throwable failure = null;
    private BatchIterator<Row> iterator = null;

    InterceptingRowConsumer(UUID jobId, RowConsumer consumer, InitializationTracker jobsInitialized, Executor executor, ActionExecutor<KillJobsNodeRequest, KillResponse> killNodeAction) {
        this.jobId = jobId;
        this.consumer = consumer;
        this.executor = executor;
        this.killNodeAction = killNodeAction;
        jobsInitialized.future.whenComplete((o, f) -> this.tryForwardResult((Throwable)f));
    }

    public void accept(BatchIterator<Row> iterator, @Nullable Throwable failure) {
        if (this.consumerAccepted.compareAndSet(false, true)) {
            this.iterator = iterator;
            this.tryForwardResult(failure);
        }
    }

    public CompletableFuture<?> completionFuture() {
        return this.consumer.completionFuture();
    }

    private void tryForwardResult(Throwable throwable) {
        if (throwable != null && (this.failure == null || this.failure instanceof InterruptedException)) {
            this.failure = SQLExceptions.unwrap(throwable);
        }
        if (this.consumerInvokedAndJobInitialized.decrementAndGet() > 0) {
            return;
        }
        if (this.failure == null) {
            assert (this.iterator != null) : "iterator must be present";
            ThreadPools.forceExecute(this.executor, () -> this.consumer.accept(this.iterator, null));
        } else {
            this.consumer.accept(null, this.failure);
            KillJobsNodeRequest killRequest = new KillJobsNodeRequest(List.of(), List.of(this.jobId), Role.CRATE_USER.name(), "An error was encountered: " + String.valueOf(this.failure));
            this.killNodeAction.execute(killRequest).whenComplete((resp, t) -> {
                if (LOGGER.isTraceEnabled()) {
                    if (t == null) {
                        LOGGER.trace("Killed {} contexts for jobId={} forwarding the failure={}", (Object)resp.numKilled(), (Object)this.jobId, (Object)this.failure);
                    } else {
                        LOGGER.trace("Failed to kill jobId={}, forwarding failure={} anyway", (Object)this.jobId, (Object)this.failure);
                    }
                }
            });
        }
    }

    public String toString() {
        return "InterceptingBatchConsumer{consumerInvokedAndJobInitialized=" + String.valueOf(this.consumerInvokedAndJobInitialized) + ", jobId=" + String.valueOf(this.jobId) + ", consumer=" + String.valueOf(this.consumer) + ", rowReceiverDone=" + String.valueOf(this.consumerAccepted) + ", failure=" + String.valueOf(this.failure) + "}";
    }
}

