/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.common.MutableObject;
import io.crate.data.Input;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import io.crate.expression.reference.doc.lucene.LuceneReferenceResolver;
import io.crate.expression.symbol.Literal;
import io.crate.memory.MemoryManager;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataType;
import io.crate.types.DoubleType;
import io.crate.types.FloatType;
import io.crate.types.TypeSignature;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.Version;
import org.elasticsearch.common.network.NetworkUtils;
import org.jetbrains.annotations.Nullable;

public class ArbitraryAggregation
extends AggregationFunction<Object, Object> {
    public static final String NAME = "arbitrary";
    public static final String ALIAS = "any_value";
    private final Signature signature;
    private final BoundSignature boundSignature;
    private final DataType<Object> partialType;

    public static void register(Functions.Builder builder) {
        TypeSignature T = TypeSignature.parse("T");
        builder.add(Signature.builder(NAME, FunctionType.AGGREGATE).argumentTypes(T).returnType(T).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(TypeVariableConstraint.typeVariableOfAnyType("T")).build(), ArbitraryAggregation::new);
        builder.add(Signature.builder(ALIAS, FunctionType.AGGREGATE).argumentTypes(T).returnType(T).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(TypeVariableConstraint.typeVariableOfAnyType("T")).build(), ArbitraryAggregation::new);
    }

    ArbitraryAggregation(Signature signature, BoundSignature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.partialType = boundSignature.returnType();
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public BoundSignature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public DataType<?> partialType() {
        return this.partialType;
    }

    @Override
    @Nullable
    public Object newState(RamAccounting ramAccounting, Version indexVersionCreated, Version minNodeInCluster, MemoryManager memoryManager) {
        return null;
    }

    @Override
    public Object iterate(RamAccounting ramAccounting, MemoryManager memoryManager, Object state, Input<?> ... args) {
        return this.reduce(ramAccounting, state, args[0].value());
    }

    @Override
    public Object reduce(RamAccounting ramAccounting, Object state1, Object state2) {
        if (state1 == null) {
            if (state2 != null) {
                ramAccounting.addBytes(this.partialType.valueBytes(state2));
            }
            return state2;
        }
        return state1;
    }

    @Override
    public Object terminatePartial(RamAccounting ramAccounting, Object state) {
        return state;
    }

    @Override
    @Nullable
    public DocValueAggregator<?> getDocValueAggregator(LuceneReferenceResolver referenceResolver, List<Reference> aggregationReferences, DocTableInfo table, Version shardCreatedVersion, List<Literal<?>> optionalParams) {
        Reference reference = this.getAggReference(aggregationReferences);
        if (reference == null) {
            return null;
        }
        DataType<?> dataType = reference.valueType();
        switch (dataType.id()) {
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                return new LongArbitraryDocValueAggregator(reference.storageIdent(), dataType);
            }
            case 7: {
                return new FloatArbitraryDocValueAggregator(reference.storageIdent());
            }
            case 6: {
                return new DoubleArbitraryDocValueAggregator(reference.storageIdent());
            }
            case 5: {
                return new ArbitraryIPDocValueAggregator(reference.storageIdent());
            }
            case 4: {
                return new ArbitraryBinaryDocValueAggregator(reference.storageIdent(), dataType);
            }
        }
        return null;
    }

    private static class LongArbitraryDocValueAggregator<T>
    extends ArbitraryNumericDocValueAggregator {
        private final DataType<T> dataType;

        public LongArbitraryDocValueAggregator(String columnName, DataType<T> dataType) {
            super(columnName);
            this.dataType = dataType;
        }

        @Override
        public void apply(RamAccounting ramAccounting, int doc, MutableObject state) throws IOException {
            if (this.values.advanceExact(doc) && this.values.docValueCount() == 1 && !state.hasValue()) {
                T value = this.dataType.sanitizeValue(this.values.nextValue());
                ramAccounting.addBytes(this.dataType.valueBytes(value));
                state.setValue(value);
            }
        }
    }

    private static class FloatArbitraryDocValueAggregator
    extends ArbitraryNumericDocValueAggregator {
        public FloatArbitraryDocValueAggregator(String columnName) {
            super(columnName);
        }

        @Override
        public void apply(RamAccounting ramAccounting, int doc, MutableObject state) throws IOException {
            if (this.values.advanceExact(doc) && this.values.docValueCount() == 1 && !state.hasValue()) {
                float value = NumericUtils.sortableIntToFloat((int)((int)this.values.nextValue()));
                ramAccounting.addBytes((long)FloatType.FLOAT_SIZE);
                state.setValue((Object)Float.valueOf(value));
            }
        }
    }

    private static class DoubleArbitraryDocValueAggregator
    extends ArbitraryNumericDocValueAggregator {
        public DoubleArbitraryDocValueAggregator(String columnName) {
            super(columnName);
        }

        @Override
        public void apply(RamAccounting ramAccounting, int doc, MutableObject state) throws IOException {
            if (this.values.advanceExact(doc) && this.values.docValueCount() == 1 && !state.hasValue()) {
                double value = NumericUtils.sortableLongToDouble((long)this.values.nextValue());
                ramAccounting.addBytes((long)DoubleType.DOUBLE_SIZE);
                state.setValue((Object)value);
            }
        }
    }

    private static class ArbitraryIPDocValueAggregator
    implements DocValueAggregator<MutableObject> {
        private final String columnName;
        private SortedSetDocValues values;

        public ArbitraryIPDocValueAggregator(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public MutableObject initialState(RamAccounting ramAccounting, MemoryManager memoryManager, Version minNodeVersion) {
            return new MutableObject();
        }

        @Override
        public void loadDocValues(LeafReaderContext reader) throws IOException {
            this.values = reader.reader().getSortedSetDocValues(this.columnName);
        }

        @Override
        public void apply(RamAccounting ramAccounting, int doc, MutableObject state) throws IOException {
            if (this.values.advanceExact(doc) && this.values.docValueCount() == 1 && !state.hasValue()) {
                long ord = this.values.nextOrd();
                BytesRef encoded = this.values.lookupOrd(ord);
                String value = NetworkUtils.formatIPBytes(encoded);
                ramAccounting.addBytes(RamUsageEstimator.sizeOf((String)value));
                state.setValue((Object)value);
            }
        }

        @Override
        @Nullable
        public Object partialResult(RamAccounting ramAccounting, MutableObject state) {
            if (state.hasValue()) {
                return state.value();
            }
            return null;
        }
    }

    private static class ArbitraryBinaryDocValueAggregator<T>
    implements DocValueAggregator<MutableObject> {
        private final String columnName;
        private final DataType<T> dataType;
        private SortedSetDocValues values;

        public ArbitraryBinaryDocValueAggregator(String columnName, DataType<T> dataType) {
            this.columnName = columnName;
            this.dataType = dataType;
        }

        @Override
        public MutableObject initialState(RamAccounting ramAccounting, MemoryManager memoryManager, Version minNodeVersion) {
            return new MutableObject();
        }

        @Override
        public void loadDocValues(LeafReaderContext reader) throws IOException {
            this.values = DocValues.getSortedSet((LeafReader)reader.reader(), (String)this.columnName);
        }

        @Override
        public void apply(RamAccounting ramAccounting, int doc, MutableObject state) throws IOException {
            if (this.values.advanceExact(doc) && this.values.docValueCount() == 1 && !state.hasValue()) {
                BytesRef rawValue = this.values.lookupOrd(this.values.nextOrd());
                T value = this.dataType.sanitizeValue(rawValue.utf8ToString());
                ramAccounting.addBytes(this.dataType.valueBytes(value));
                state.setValue(value);
            }
        }

        @Override
        @Nullable
        public Object partialResult(RamAccounting ramAccounting, MutableObject state) {
            if (state.hasValue()) {
                return state.value();
            }
            return null;
        }
    }

    private static abstract class ArbitraryNumericDocValueAggregator
    implements DocValueAggregator<MutableObject> {
        private final String columnName;
        protected SortedNumericDocValues values;

        public ArbitraryNumericDocValueAggregator(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public MutableObject initialState(RamAccounting ramAccounting, MemoryManager memoryManager, Version minNodeVersion) {
            return new MutableObject();
        }

        @Override
        public void loadDocValues(LeafReaderContext reader) throws IOException {
            this.values = DocValues.getSortedNumeric((LeafReader)reader.reader(), (String)this.columnName);
        }

        @Override
        @Nullable
        public Object partialResult(RamAccounting ramAccounting, MutableObject state) {
            if (state.hasValue()) {
                return state.value();
            }
            return null;
        }
    }
}

