/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.common.MutableDouble;
import io.crate.common.MutableFloat;
import io.crate.common.MutableLong;
import io.crate.data.Input;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import io.crate.expression.reference.doc.lucene.LuceneReferenceResolver;
import io.crate.expression.symbol.Literal;
import io.crate.memory.MemoryManager;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.FixedWidthType;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.Version;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.jetbrains.annotations.Nullable;

public abstract class MinimumAggregation
extends AggregationFunction<Object, Object> {
    public static final String NAME = "min";
    private final Signature signature;
    private final BoundSignature boundSignature;
    protected final DataType<Object> type;

    public static void register(Functions.Builder builder) {
        for (DataType<?> supportedType : DataTypes.PRIMITIVE_TYPES) {
            boolean fixedWidthType = supportedType instanceof FixedWidthType;
            builder.add(Signature.builder(NAME, FunctionType.AGGREGATE).argumentTypes(supportedType.getTypeSignature()).returnType(supportedType.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), (signature, boundSignature) -> fixedWidthType ? new FixedMinimumAggregation((Signature)signature, (BoundSignature)boundSignature) : new VariableMinimumAggregation((Signature)signature, (BoundSignature)boundSignature));
        }
    }

    private MinimumAggregation(Signature signature, BoundSignature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.type = boundSignature.returnType();
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public BoundSignature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public DataType<?> partialType() {
        return this.boundSignature.returnType();
    }

    @Override
    public Object terminatePartial(RamAccounting ramAccounting, Object state) {
        return state;
    }

    @Override
    public Object iterate(RamAccounting ramAccounting, MemoryManager memoryManager, Object state, Input<?> ... args) throws CircuitBreakingException {
        return this.reduce(ramAccounting, state, args[0].value());
    }

    private static class FixedMinimumAggregation
    extends MinimumAggregation {
        private final int size = ((FixedWidthType)((Object)this.partialType())).fixedSize();

        FixedMinimumAggregation(Signature signature, BoundSignature boundSignature) {
            super(signature, boundSignature);
        }

        @Override
        @Nullable
        public DocValueAggregator<?> getDocValueAggregator(LuceneReferenceResolver referenceResolver, List<Reference> aggregationReferences, DocTableInfo table, Version shardCreatedVersion, List<Literal<?>> optionalParams) {
            Reference reference = this.getAggReference(aggregationReferences);
            if (reference == null) {
                return null;
            }
            DataType<?> valueType = reference.valueType();
            switch (valueType.id()) {
                case 2: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 15: {
                    return new LongMin(reference.storageIdent(), valueType);
                }
                case 7: {
                    return new FloatMin(reference.storageIdent());
                }
                case 6: {
                    return new DoubleMin(reference.storageIdent());
                }
            }
            return null;
        }

        @Override
        @Nullable
        public Object newState(RamAccounting ramAccounting, Version indexVersionCreated, Version minNodeInCluster, MemoryManager memoryManager) {
            ramAccounting.addBytes((long)this.size);
            return null;
        }

        @Override
        public Object reduce(RamAccounting ramAccounting, Object state1, Object state2) {
            if (state1 == null) {
                return state2;
            }
            if (state2 == null) {
                return state1;
            }
            if (this.type.compare(state1, state2) > 0) {
                return state2;
            }
            return state1;
        }
    }

    private static class VariableMinimumAggregation
    extends MinimumAggregation {
        VariableMinimumAggregation(Signature signature, BoundSignature boundSignature) {
            super(signature, boundSignature);
        }

        @Override
        @Nullable
        public Object newState(RamAccounting ramAccounting, Version indexVersionCreated, Version minNodeInCluster, MemoryManager memoryManager) {
            return null;
        }

        @Override
        public Object reduce(RamAccounting ramAccounting, Object state1, Object state2) {
            if (state1 == null) {
                if (state2 != null) {
                    ramAccounting.addBytes(this.type.valueBytes(state2));
                }
                return state2;
            }
            if (state2 == null) {
                return state1;
            }
            if (this.type.compare(state1, state2) > 0) {
                long delta = this.type.valueBytes(state1) - this.type.valueBytes(state2);
                ramAccounting.addBytes(delta);
                return state2;
            }
            return state1;
        }
    }

    private static class FloatMin
    implements DocValueAggregator<MutableFloat> {
        private final String columnName;
        private SortedNumericDocValues values;

        public FloatMin(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public MutableFloat initialState(RamAccounting ramAccounting, MemoryManager memoryManager, Version minNodeVersion) {
            ramAccounting.addBytes((long)DataTypes.FLOAT.fixedSize());
            return new MutableFloat(Float.MAX_VALUE);
        }

        @Override
        public void loadDocValues(LeafReaderContext reader) throws IOException {
            this.values = DocValues.getSortedNumeric((LeafReader)reader.reader(), (String)this.columnName);
        }

        @Override
        public void apply(RamAccounting ramAccounting, int doc, MutableFloat state) throws IOException {
            float value;
            if (this.values.advanceExact(doc) && this.values.docValueCount() == 1 && (value = NumericUtils.sortableIntToFloat((int)((int)this.values.nextValue()))) < state.value()) {
                state.setValue(value);
            }
        }

        @Override
        public Object partialResult(RamAccounting ramAccounting, MutableFloat state) {
            if (state.hasValue()) {
                return Float.valueOf(state.value());
            }
            return null;
        }
    }

    private static class DoubleMin
    implements DocValueAggregator<MutableDouble> {
        private final String columnName;
        private SortedNumericDocValues values;

        public DoubleMin(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public MutableDouble initialState(RamAccounting ramAccounting, MemoryManager memoryManager, Version minNodeVersion) {
            ramAccounting.addBytes((long)DataTypes.DOUBLE.fixedSize());
            return new MutableDouble(Double.MAX_VALUE);
        }

        @Override
        public void loadDocValues(LeafReaderContext reader) throws IOException {
            this.values = DocValues.getSortedNumeric((LeafReader)reader.reader(), (String)this.columnName);
        }

        @Override
        public void apply(RamAccounting ramAccounting, int doc, MutableDouble state) throws IOException {
            double value;
            if (this.values.advanceExact(doc) && this.values.docValueCount() == 1 && (value = NumericUtils.sortableLongToDouble((long)this.values.nextValue())) < state.value()) {
                state.setValue(value);
            }
        }

        @Override
        public Object partialResult(RamAccounting ramAccounting, MutableDouble state) {
            if (state.hasValue()) {
                return state.value();
            }
            return null;
        }
    }

    private static class LongMin
    implements DocValueAggregator<MutableLong> {
        private final String columnName;
        private final DataType<?> partialType;
        private SortedNumericDocValues values;

        public LongMin(String columnName, DataType<?> partialType) {
            this.columnName = columnName;
            this.partialType = partialType;
        }

        @Override
        public MutableLong initialState(RamAccounting ramAccounting, MemoryManager memoryManager, Version minNodeVersion) {
            ramAccounting.addBytes((long)DataTypes.LONG.fixedSize());
            return new MutableLong(Long.MAX_VALUE);
        }

        @Override
        public void loadDocValues(LeafReaderContext reader) throws IOException {
            this.values = DocValues.getSortedNumeric((LeafReader)reader.reader(), (String)this.columnName);
        }

        @Override
        public void apply(RamAccounting ramAccounting, int doc, MutableLong state) throws IOException {
            long value;
            if (this.values.advanceExact(doc) && this.values.docValueCount() == 1 && (value = this.values.nextValue()) < state.value()) {
                state.setValue(value);
            }
        }

        @Override
        public Object partialResult(RamAccounting ramAccounting, MutableLong state) {
            if (state.hasValue()) {
                return this.partialType.sanitizeValue(state.value());
            }
            return null;
        }
    }
}

